/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puckgui.InputSettings;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.util.ComboBoxIds;

public class IndividualChildrenModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7713941886363202385L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualChildrenModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.tip.puckgui.messages");
    private static ImageIcon smallFemaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/female-16x16.png"));
    private static ImageIcon smallMaleIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/male-16x16.png"));
    private static ImageIcon smallUnknowIcon = new ImageIcon(IndividualChildrenModel.class.getResource("/org/tip/puckgui/images/unknown-16x16.png"));
    private NetGUI netGUI;
    private Individual source;
    private List<Individual> children;

    public IndividualChildrenModel(NetGUI netGUI, Individual source) {
        this.netGUI = netGUI;
        this.source = source;
        this.children = source == null ? new ArrayList<Individual>() : this.source.getChildren().toSortedList();
    }

    public List<Individual> children() {
        List<Individual> result = this.children;
        return result;
    }

    public void escapeNewEdition() {
        if (this.isNewEditionOn()) {
            logger.debug("ESCAPE d");
            int index = this.children.size() - 1;
            this.children.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public Class getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = Number.class;
                break;
            }
            case 1: {
                result = ImageIcon.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = String.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = String.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 6;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = BUNDLE.getString("MainWindow.individual.id");
                break;
            }
            case 1: {
                result = BUNDLE.getString("MainWindow.individual.gender");
                break;
            }
            case 2: {
                result = BUNDLE.getString("MainWindow.individual.name");
                break;
            }
            case 3: {
                result = BUNDLE.getString("MainWindow.individual.birth");
                break;
            }
            case 4: {
                result = BUNDLE.getString("MainWindow.individual.death");
                break;
            }
            case 5: {
                result = BUNDLE.getString("MainWindow.individual.otherparent");
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.children.size();
        return result;
    }

    public Individual getSource() {
        Individual result = this.source;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.source == null) {
            result = null;
        } else if (this.isNewEditionOn() && rowIndex == this.children.size() - 1) {
            switch (columnIndex) {
                case 5: {
                    Individual otherParent = this.children.get(rowIndex).getOtherParent(this.source);
                    if (otherParent == null) {
                        result = null;
                        break;
                    }
                    result = String.format("%c (%d) %s", Character.valueOf(otherParent.getGender().toChar()), otherParent.getId(), otherParent.getName());
                    break;
                }
                default: {
                    result = "";
                    break;
                }
            }
        } else {
            block3 : switch (columnIndex) {
                case 0: {
                    result = this.children.get(rowIndex).getId();
                    break;
                }
                case 1: {
                    switch (this.children.get(rowIndex).getGender()) {
                        case FEMALE: {
                            result = smallFemaleIcon;
                            break block3;
                        }
                        case MALE: {
                            result = smallMaleIcon;
                            break block3;
                        }
                        case UNKNOWN: {
                            result = smallUnknowIcon;
                            break block3;
                        }
                    }
                    result = smallUnknowIcon;
                    break;
                }
                case 2: {
                    result = this.children.get(rowIndex).getName();
                    break;
                }
                case 3: {
                    result = null;
                    break;
                }
                case 4: {
                    result = null;
                    break;
                }
                case 5: {
                    Individual otherParent = this.children.get(rowIndex).getOtherParent(this.source);
                    if (otherParent == null) {
                        result = null;
                        break;
                    }
                    result = String.format("%c (%d) %s", Character.valueOf(otherParent.getGender().toChar()), otherParent.getId(), otherParent.getName());
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result;
        switch (col) {
            case 0: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isNewEditionOn() {
        boolean result = this.source == null ? false : this.children.size() == this.source.getChildren().size() + 1;
        return result;
    }

    public void setNewItem(Family family) {
        Individual newIndividual = new Individual(0, "?", Gender.UNKNOWN);
        newIndividual.setOriginFamily(family);
        this.children.add(newIndividual);
        this.fireTableDataChanged();
    }

    public void setSource(Individual source) {
        this.source = source;
        this.children = source == null ? new ArrayList<Individual>() : this.source.getChildren().toSortedList();
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        logger.debug("setValueAt(" + rowIndex + ", " + columnIndex + ", " + value + ")");
        if (this.netGUI != null && columnIndex == 0) {
            Individual currentIndividual = this.netGUI.selectedIndividual();
            if (this.isNewEditionOn()) {
                Individual newChild = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                if (newChild == null) {
                    this.children.remove(rowIndex);
                    this.fireTableDataChanged();
                } else {
                    Family targetFamily = this.children.get(rowIndex).getOriginFamily();
                    String errorMessage = IndividualChildrenModel.controlChildKin(InputSettings.CheckLevel.ERROR, this.source, targetFamily, newChild);
                    if (errorMessage != null) {
                        JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
                    } else {
                        String warningMessage = IndividualChildrenModel.controlChildKin(InputSettings.CheckLevel.WARNING, this.source, targetFamily, newChild);
                        if (warningMessage != null) {
                            JOptionPane.showMessageDialog(null, warningMessage, "Warning", 2);
                        }
                        logger.debug("halfO=" + newChild.isHalfOrphan());
                        logger.debug("isParent=" + newChild.isParent(this.source));
                        if (!newChild.isHalfOrphan() || !newChild.isParent(this.source)) {
                            this.netGUI.getNet().removeChild(newChild);
                            if (targetFamily == null) {
                                if (NetUtils.isRolesFixedByGender(this.source, null)) {
                                    this.netGUI.getNet().createFamily(this.source, null, newChild);
                                } else {
                                    this.netGUI.getNet().createFamily(null, this.source, newChild);
                                }
                            } else {
                                this.netGUI.getNet().addChild(targetFamily, newChild);
                            }
                            this.netGUI.setChanged(true);
                            this.netGUI.updateAll();
                            this.netGUI.selectIndividualsTab(currentIndividual);
                        }
                    }
                }
            } else {
                Individual oldChild = this.children.get(rowIndex);
                Individual newChild = ComboBoxIds.getOrCreateIndividualFromInput(this.netGUI.getNet(), value, Gender.UNKNOWN);
                Family targetFamily = this.children.get(rowIndex).getOriginFamily();
                if (newChild == null) {
                    this.netGUI.getNet().removeChild(oldChild);
                    this.netGUI.setChanged(true);
                    this.setSource(this.source);
                } else {
                    String errorMessage = IndividualChildrenModel.controlChildKin(InputSettings.CheckLevel.ERROR, this.source, targetFamily, newChild);
                    if (errorMessage != null) {
                        JOptionPane.showMessageDialog(null, errorMessage, "Error", 0);
                    } else {
                        String warningMessage = IndividualChildrenModel.controlChildKin(InputSettings.CheckLevel.WARNING, this.source, targetFamily, newChild);
                        if (warningMessage != null) {
                            JOptionPane.showMessageDialog(null, warningMessage, "Warning", 2);
                        }
                        if (newChild != oldChild) {
                            Family currentFamily = oldChild.getOriginFamily();
                            this.netGUI.getNet().removeChild(oldChild);
                            this.netGUI.getNet().removeChild(newChild);
                            this.netGUI.getNet().addChild(currentFamily, newChild);
                            this.netGUI.setChanged(true);
                            this.netGUI.updateAll();
                            this.netGUI.selectIndividualsTab(currentIndividual);
                        }
                    }
                }
            }
        }
    }

    public Individual source() {
        Individual result = this.source;
        return result;
    }

    public static String controlChildKin(InputSettings.CheckLevel level, Individual ego, Family family, Individual child) {
        Individual alter = family == null ? null : family.getOtherParent(ego);
        String result = level == InputSettings.CheckLevel.ERROR && (NetUtils.isSame(ego, child) || NetUtils.isSame(alter, child)) ? "Same parent child detected." : (level == InputSettings.CheckLevel.ERROR && family != null && family.getChildren().contains(child) ? "Already child detected." : (PuckGUI.instance().getPreferences().getInputSettings().getParentChildMarriages() == level && (NetUtils.isParentChildMarriage(ego, child) || NetUtils.isParentChildMarriage(alter, child)) ? "Parent-child marriages detected." : null));
        return result;
    }
}

