/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.tip.puck.util.ToolBox;

public class RecentFiles
implements Iterable<File> {
    protected static final int MAX_SIZE = 15;
    protected List<File> datas = new ArrayList<File>(16);

    public File getMoreRecent() {
        File result = this.datas.isEmpty() ? null : this.datas.get(0);
        return result;
    }

    public int indexOf(File file) {
        boolean ended = false;
        int result = -1;
        int count = 0;
        while (!ended) {
            if (count < this.datas.size()) {
                if (this.datas.get(count).getAbsolutePath().equals(file.getAbsolutePath())) {
                    ended = true;
                    result = count;
                    continue;
                }
                ++count;
                continue;
            }
            ended = true;
            result = -1;
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.datas.isEmpty();
        return result;
    }

    public boolean isNotEmpty() {
        boolean result = !this.isEmpty();
        return result;
    }

    @Override
    public Iterator<File> iterator() {
        Iterator<File> result = this.datas.iterator();
        return result;
    }

    public int size() {
        int result = this.datas.size();
        return result;
    }

    public File[] toArray() {
        File[] result = new File[this.datas.size()];
        this.datas.toArray(result);
        return result;
    }

    public File[] toReverseArray() {
        Object[] result = this.toArray();
        ArrayUtils.reverse((Object[])result);
        return result;
    }

    public void update(File file) {
        if (file != null) {
            int index = this.indexOf(file);
            if (index != -1) {
                this.datas.remove(index);
            }
            this.datas.add(0, file);
            if (this.datas.size() > 15) {
                this.datas.remove(this.datas.size() - 1);
            }
        }
    }

    public void updateFile(File file) {
        if (ToolBox.getExtension(file) != null) {
            this.update(file);
        }
    }

    public void updateFolder(File folder) {
        if (folder != null && folder.isDirectory()) {
            this.update(folder);
        }
    }
}

