/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.Vector;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Interval;

public class Value
implements Comparable<Value> {
    private static final Logger logger = LoggerFactory.getLogger(Value.class);
    private Object value;

    public Value(char value) {
        this.value = new Character(value);
    }

    public Value(double value) {
        this.value = new Double(value);
    }

    public <E extends Comparable<E>> Value(E value) {
        if (value == null) {
            throw new ClassCastException("Value cannot be null.");
        }
        this.value = value;
    }

    public Value(int value) {
        this.value = new Integer(value);
    }

    public Value(Object value) {
        if (value == null) {
            throw new ClassCastException("Value cannot be null.");
        }
        this.value = value;
    }

    public Value(String value) {
        this.value = new String(value);
    }

    public Chain chainValue() {
        if (!(this.value instanceof Chain)) {
            throw new ClassCastException("Value is not a chain.");
        }
        Chain result = (Chain)this.value;
        return result;
    }

    public char charValue() {
        char result;
        if (this.value == null) {
            result = ' ';
        } else if (this.value instanceof Character) {
            result = ((Character)this.value).charValue();
        } else {
            throw new ClassCastException("Value is not a character.");
        }
        return result;
    }

    @Override
    public int compareTo(Value source) {
        int result = source == null ? 1 : (this.isNumber() && source.isNumber() ? Double.compare(this.doubleValue(), source.doubleValue()) : (this.isVector() && source.isVector() ? this.vectorValue().compareTo(source.vectorValue()) : (this.isChain() && source.isChain() ? this.chainValue().compareTo(source.chainValue()) : (this.isIndividual() && source.isIndividual() ? Integer.valueOf(this.individualValue().getId()).compareTo(source.individualValue().getId()) : (this.isGender() && source.isGender() ? this.genderValue().compareTo(source.genderValue()) : (this.value instanceof Interval && source.getObject() instanceof Interval ? ((Interval)this.getObject()).compareTo((Interval)source.getObject()) : this.stringValue().compareTo(source.stringValue())))))));
        return result;
    }

    public int dimension() {
        int result = this.value instanceof Vector ? ((Vector)this.value).order() : 1;
        return result;
    }

    public double doubleValue() {
        double result;
        if (this.value == null) {
            throw new ClassCastException("Null is not a number.");
        }
        if (this.value instanceof Integer) {
            result = ((Integer)this.value).doubleValue();
        } else if (this.value instanceof Double) {
            result = (Double)this.value;
        } else {
            String stringValue = this.value.toString();
            if (NumberUtils.isNumber((String)stringValue)) {
                result = Double.parseDouble(stringValue);
            } else {
                throw new ClassCastException("Value is not a number.");
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        boolean result = object == null || !(object instanceof Value) ? false : this.stringValue().equals(((Value)object).stringValue());
        return result;
    }

    public Gender genderValue() {
        if (!(this.value instanceof Gender)) {
            throw new ClassCastException("Value is not a gender.");
        }
        Gender result = (Gender)((Object)this.value);
        return result;
    }

    public Object getObject() {
        Object result = this.value;
        return result;
    }

    public int hashCode() {
        int result = this.stringValue().hashCode();
        return result;
    }

    public Individual individualValue() {
        if (!(this.value instanceof Individual)) {
            throw new ClassCastException("Value is not an individual.");
        }
        Individual result = (Individual)this.value;
        return result;
    }

    public int intValue() {
        int result;
        if (this.value == null) {
            throw new ClassCastException("Null is not a number.");
        }
        if (this.value instanceof Integer) {
            result = (Integer)this.value;
        } else if (this.value instanceof Double) {
            result = ((Double)this.value).intValue();
        } else {
            String stringValue = this.value.toString();
            if (NumberUtils.isNumber((String)stringValue)) {
                result = Integer.parseInt(stringValue);
            } else {
                throw new ClassCastException("Value is not a number.");
            }
        }
        return result;
    }

    public boolean isChain() {
        boolean result = this.value == null ? false : this.value instanceof Chain;
        return result;
    }

    public boolean isGender() {
        boolean result = this.value == null ? false : this.value instanceof Gender;
        return result;
    }

    public boolean isIndividual() {
        boolean result = this.value == null ? false : this.value instanceof Individual;
        return result;
    }

    public boolean isNotNumber() {
        boolean result = !this.isNumber();
        return result;
    }

    public boolean isNotZero() {
        boolean result = this.value == null ? true : (this.isNotNumber() ? true : this.doubleValue() != 0.0);
        return result;
    }

    public boolean isNumber() {
        boolean result = this.value == null ? false : this.value instanceof Integer || this.value instanceof Double || NumberUtils.isNumber((String)this.value.toString());
        return result;
    }

    public boolean isPositiveNumber() {
        boolean result = this.isNumber() && this.doubleValue() > 0.0;
        return result;
    }

    public boolean isString() {
        boolean result = this.value instanceof String;
        return result;
    }

    public boolean isVector() {
        boolean result = this.value == null ? false : this.value instanceof Vector;
        return result;
    }

    public boolean isZero() {
        boolean result = this.value == null ? false : (this.isNotNumber() ? false : this.doubleValue() == 0.0);
        return result;
    }

    public String stringValue() {
        String result = this.value == null ? "null" : this.value.toString();
        return result;
    }

    public String toString() {
        String result = this.stringValue();
        return result;
    }

    public Vector vectorValue() {
        if (!(this.value instanceof Vector)) {
            throw new ClassCastException("Value is not a vector.");
        }
        Vector result = (Vector)this.value;
        return result;
    }

    public static int compare(Value value1, Value value2) {
        int result = value1 == null && value2 == null ? 0 : (value1 == null ? -1 : (value2 == null ? 1 : value1.compareTo(value2)));
        return result;
    }

    public static boolean isNumber(Value value) {
        boolean result = value == null ? false : value.isNumber();
        return result;
    }

    public static String stringValue(Value value) {
        String result = value == null ? null : value.stringValue();
        return result;
    }
}

