/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.segmentation;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.segmentation.Segment;

public class RelationSegment
implements Segment {
    private PartitionCriteria criteria;
    private Partition<Relation> partition;
    private Cluster<Relation> currentCluster;
    private int currentClusterIndex;
    private Individuals currentIndividuals;
    private Families currentFamilies;
    private Relations currentRelations;
    private Individuals outOfPartitionIndividuals;
    private Families outOfPartitionFamilies;
    private Relations outOfPartitionRelations;

    public RelationSegment(Segment source, PartitionCriteria criteria) throws PuckException {
        this.criteria = criteria;
        this.refresh(source);
    }

    @Override
    public List<String> getClusterLabels() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.partition != null) {
            for (Cluster<Relation> cluster : this.partition.getClusters().toListSortedByValue()) {
                String label = cluster.getLabel();
                if (label == null) {
                    label = "[null]";
                }
                result.add(String.format("%s (%d)", cluster.getLabel(), cluster.size()));
            }
        }
        result.add("*");
        return result;
    }

    public Cluster<Relation> getCurrentCluster() {
        Cluster<Relation> result = this.currentCluster;
        return result;
    }

    @Override
    public int getCurrentClusterIndex() {
        int result = this.currentClusterIndex;
        return result;
    }

    @Override
    public Families getCurrentFamilies() {
        Families result = this.currentFamilies;
        return result;
    }

    @Override
    public Individuals getCurrentIndividuals() {
        Individuals result = this.currentIndividuals;
        return result;
    }

    @Override
    public Relations getCurrentRelations() {
        Relations result = this.currentRelations;
        return result;
    }

    @Override
    public int getCurrentSize() {
        int result = this.currentCluster == null ? this.outOfPartitionRelations.size() : this.currentCluster.size();
        return result;
    }

    @Override
    public String getLabel() {
        String result = this.currentCluster == null ? String.valueOf(this.partition.getCriteria().toShortString()) + " : *" : String.valueOf(this.partition.getCriteria().toShortString()) + " : " + this.currentCluster.getLabel();
        return result;
    }

    @Override
    public Families getOutOfCurrentClusterFamilies() {
        Families result = new Families();
        if (this.currentCluster == null) {
            for (Cluster<Relation> cluster : this.partition.getClusters()) {
                Individuals individuals = RelationSegment.findIndividualsFromRelations(new Relations(cluster.getItems()), this.outOfPartitionIndividuals);
                Families families = RelationSegment.findFamiliesFromIndividuals(individuals, this.partition.getCriteria().getFamilyScope(), this.outOfPartitionFamilies);
                for (Family family : families) {
                    result.add(family);
                }
            }
        } else {
            for (Cluster<Relation> cluster : this.partition.getClusters()) {
                if (cluster == this.currentCluster) continue;
                Individuals individuals = RelationSegment.findIndividualsFromRelations(new Relations(cluster.getItems()), this.outOfPartitionIndividuals);
                Families families = RelationSegment.findFamiliesFromIndividuals(individuals, this.partition.getCriteria().getFamilyScope(), this.outOfPartitionFamilies);
                for (Family family : families) {
                    if (this.currentFamilies.contains(family)) continue;
                    result.add(family);
                }
            }
            result.add(this.outOfPartitionFamilies);
        }
        return result;
    }

    @Override
    public Individuals getOutOfCurrentClusterIndividuals() {
        Individuals result = new Individuals();
        if (this.currentCluster == null) {
            for (Cluster<Relation> cluster : this.partition.getClusters()) {
                Individuals individuals = RelationSegment.findIndividualsFromRelations(new Relations(cluster.getItems()), this.outOfPartitionIndividuals);
                for (Individual individual : individuals) {
                    result.add(individual);
                }
            }
        } else {
            for (Cluster<Relation> cluster : this.partition.getClusters()) {
                if (cluster == this.currentCluster) continue;
                Individuals individuals = RelationSegment.findIndividualsFromRelations(new Relations(cluster.getItems()), this.outOfPartitionIndividuals);
                for (Individual individual : individuals) {
                    if (this.currentIndividuals.contains(individual)) continue;
                    result.add(individual);
                }
            }
            result.add(this.outOfPartitionIndividuals);
        }
        return result;
    }

    @Override
    public Relations getOutOfCurrentClusterRelations() {
        Relations result = new Relations();
        if (this.partition == null) {
            for (Cluster<Relation> cluster : this.partition.getClusters()) {
                result.add(cluster.getItems());
            }
        } else {
            for (Cluster<Relation> cluster : this.partition.getClusters()) {
                if (cluster == this.currentCluster) continue;
                result.add(cluster.getItems());
            }
            result.add(this.outOfPartitionRelations);
        }
        return result;
    }

    public Partition<Relation> getPartition() {
        Partition<Relation> result = this.partition;
        return result;
    }

    @Override
    public String getShortLabel() {
        String result = this.partition.getCriteria().toShortString();
        return result;
    }

    @Override
    public String getShortShortLabel() {
        String result = this.currentCluster == null ? String.valueOf(this.partition.getCriteria().getLabel()) + " : *" : String.valueOf(this.partition.getCriteria().getLabel()) + " : " + this.currentCluster.getValue();
        return result;
    }

    @Override
    public void refresh(Segment source) throws PuckException {
        this.partition = PartitionMaker.create(this.criteria.toShortString(), source.getCurrentRelations(), this.criteria);
        this.outOfPartitionIndividuals = source.getOutOfCurrentClusterIndividuals();
        this.outOfPartitionFamilies = source.getOutOfCurrentClusterFamilies();
        this.outOfPartitionRelations = source.getOutOfCurrentClusterRelations();
        this.selectCluster(0);
    }

    @Override
    public void selectCluster(Family family) throws PuckException {
    }

    @Override
    public void selectCluster(Individual individual) throws PuckException {
    }

    @Override
    public void selectCluster(int index) throws PuckException {
        if (index < 0) {
            throw PuckExceptions.INVALID_PARAMETER.create("Index out of bounds.", new Object[0]);
        }
        if (this.partition == null && index > 0) {
            throw PuckExceptions.INVALID_PARAMETER.create("Index out of bounds.", new Object[0]);
        }
        if (this.partition != null && index >= this.partition.getClusters().size() + 1) {
            throw PuckExceptions.INVALID_PARAMETER.create("Index out of bounds.", new Object[0]);
        }
        if (index < this.partition.size()) {
            this.currentCluster = this.partition.getClusters().toListSortedByValue().get(index);
            this.currentClusterIndex = index;
            this.currentRelations = new Relations(this.currentCluster.getItems());
            this.currentIndividuals = RelationSegment.findIndividualsFromRelations(this.currentRelations, this.outOfPartitionIndividuals);
            this.currentFamilies = RelationSegment.findFamiliesFromIndividuals(this.currentIndividuals, this.partition.getCriteria().getFamilyScope(), this.outOfPartitionFamilies);
        } else {
            this.currentCluster = null;
            this.currentClusterIndex = this.partition.getClusters().size();
            this.currentRelations = this.outOfPartitionRelations;
            this.currentIndividuals = this.outOfPartitionIndividuals;
            this.currentFamilies = this.outOfPartitionFamilies;
        }
    }

    @Override
    public void selectCluster(Relation relation) throws PuckException {
        if (relation == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        this.currentCluster = this.partition.getCluster(relation);
        if (this.currentCluster == null) {
            this.selectOutOfPartitionCluster();
        } else {
            List<Cluster<Relation>> clusters = this.partition.getClusters().toListSortedByValue();
            boolean ended = false;
            int clusterIndex = 0;
            while (!ended) {
                if (clusters.get(clusterIndex) == this.currentCluster) {
                    ended = true;
                    continue;
                }
                ++clusterIndex;
            }
            this.selectCluster(clusterIndex);
        }
    }

    @Override
    public void selectOutOfPartitionCluster() throws PuckException {
        this.selectCluster(this.partition.size());
    }

    private static Families findFamiliesFromIndividuals(Individuals source, PartitionCriteria.FamilyScope familyScope, Families outs) {
        Families result = new Families();
        for (Individual individual : source) {
            for (Family family : individual.getPersonalFamilies()) {
                if (outs.contains(family)) continue;
                if (familyScope == PartitionCriteria.FamilyScope.SOME) {
                    result.add(family);
                    continue;
                }
                Individual spouse = family.getOtherParent(individual);
                if (spouse == null && !source.contains(spouse)) continue;
                result.add(family);
            }
        }
        return result;
    }

    private static Individuals findIndividualsFromRelations(Relations source, Individuals outs) {
        Individuals result = new Individuals();
        for (Relation relation : source) {
            for (Actor actor : relation.actors()) {
                if (outs.contains(actor.getIndividual())) continue;
                result.add(actor.getIndividual());
            }
        }
        return result;
    }
}

