/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportAttribute;
import org.tip.puck.report.ReportAttributes;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.report.XLSHelper;
import org.tip.puckgui.views.ReportChartMaker;

public class ReportXLSFile {
    private static final Logger logger = LoggerFactory.getLogger(ReportXLSFile.class);

    public static void save(File file, Report source) throws PuckException {
        try {
            WorkbookSettings settings = new WorkbookSettings();
            settings.setLocale(new Locale("fr", "FR"));
            WritableWorkbook workbook = Workbook.createWorkbook((File)file, (WorkbookSettings)settings);
            XLSHelper out = new XLSHelper(workbook);
            ReportXLSFile.writeGeneral(out, source);
            ReportXLSFile.write(out, source);
            workbook.write();
            workbook.close();
        }
        catch (UnsupportedEncodingException exception) {
            throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
        }
        catch (FileNotFoundException exception) {
            throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
        }
        catch (WriteException exception) {
            throw PuckExceptions.IO_ERROR.create("Opening file [" + file + "]", new Object[0]);
        }
        catch (IOException e) {
            throw PuckExceptions.IO_ERROR.create("Opening file [" + file + "]", new Object[0]);
        }
    }

    public static void write(XLSHelper out, Report source) throws RowsExceededException, WriteException, IndexOutOfBoundsException {
        out.newPage(source.title());
        for (Object output : source.outputs()) {
            if (output == null) continue;
            if (output instanceof ReportAttributes) {
                ReportAttributes attributes = (ReportAttributes)output;
                out.appendln("Attribute table");
                for (ReportAttribute item : attributes) {
                    out.append(item.label()).appendln(item.value());
                }
                out.appendln();
                continue;
            }
            if (output instanceof ReportChart) {
                ReportChart chart = (ReportChart)output;
                out.appendln("Chart: " + chart.getTitle());
                BufferedImage image = ReportChartMaker.createBufferedImage(chart, 640, 400);
                out.appendln(image);
                out.appendln();
                continue;
            }
            if (output instanceof ReportTable) {
                ReportTable table = (ReportTable)output;
                int rowIndex = 0;
                while (rowIndex < table.getRowCount()) {
                    int columnIndex = 0;
                    while (columnIndex < table.getColumnCount()) {
                        out.append(table.getString(rowIndex, columnIndex));
                        ++columnIndex;
                    }
                    out.appendln();
                    ++rowIndex;
                }
                out.appendln();
                continue;
            }
            if (output instanceof ReportRawData) {
                ReportRawData rawData = (ReportRawData)output;
                out.newPage("RAW DATA");
                out.appendln(rawData.getData());
                out.appendln();
                continue;
            }
            if (output instanceof Report) {
                Report report = (Report)output;
                ReportXLSFile.write(out, report);
                out.appendln();
                continue;
            }
            out.appendln(output.toString());
            out.appendln();
        }
    }

    public static void writeGeneral(XLSHelper out, Report source) throws RowsExceededException, WriteException, IndexOutOfBoundsException {
        out.newPage("General");
        out.appendln("=== General information");
        out.appendln();
        out.append("Title:").appendln(source.title());
        out.append("Date:").appendln(new SimpleDateFormat("dd/MM/yyyy HH':'mm").format(source.date().getTime()));
        out.append("Target:").appendln(source.target());
        out.append("Title:").appendln(source.timeSpent());
        out.appendln();
        out.appendln("=== Inputs");
        out.append("Input comment:").appendln(source.inputComment());
        out.appendln("Input data:");
        for (ReportAttribute item : source.inputs()) {
            out.append(item.label()).appendln(item.value());
        }
        out.appendln();
    }
}

