/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.Couple;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.UpdateWorker;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.segmentation.Segment;
import org.tip.puck.segmentation.Segmentation;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);

    public static void anonymizeByFirstName(Individuals source) {
        for (Individual individual : source) {
            individual.setName(individual.getFirstName());
        }
    }

    public static void anonymizeByFirstName(Net source) {
        NetUtils.anonymizeByFirstName(source.individuals());
    }

    public static void anonymizeByGenderAndId(Individuals source) {
        for (Individual individual : source) {
            individual.setName(String.valueOf(individual.getGender().toChar()) + " " + individual.getId());
        }
    }

    public static void anonymizeByGenderAndId(Net source) {
        NetUtils.anonymizeByGenderAndId(source.individuals());
    }

    public static void anonymizeByLastName(Individuals source) {
        for (Individual individual : source) {
            individual.setName(String.valueOf(individual.getLastName()) + " " + individual.getId());
        }
    }

    public static Net buildCleanedNet(Net source) throws PuckException {
        Net result = new Net();
        result.setLabel(source.getLabel());
        for (Attribute attribute : source.attributes().toSortedList()) {
            result.attributes().put(attribute.getLabel(), attribute.getValue());
        }
        for (Individual sourceIndividual : source.individuals()) {
            Individual targetIndividual = new Individual(sourceIndividual.getId());
            targetIndividual.setGender(sourceIndividual.getGender());
            targetIndividual.setName(sourceIndividual.getName());
            targetIndividual.setOriginFamily(sourceIndividual.getOriginFamily());
            targetIndividual.getPersonalFamilies().add(sourceIndividual.getPersonalFamilies());
            targetIndividual.attributes().addAll(sourceIndividual.attributes());
            result.individuals().add(targetIndividual);
        }
        for (Family sourceFamily : source.families()) {
            Individual targetParent;
            Individual targetChild;
            int fatherId = sourceFamily.getHusband() == null ? 0 : sourceFamily.getHusband().getId();
            int motherId = sourceFamily.getWife() == null ? 0 : sourceFamily.getWife().getId();
            Family targetFamily = fatherId == 0 || motherId == 0 ? null : result.families().getBySpouses(fatherId, motherId);
            if (targetFamily == null) {
                targetFamily = new Family(result.families().size() + 1);
                result.families().add(targetFamily);
                if (sourceFamily.getHusband() != null) {
                    targetFamily.setHusband((Individual)result.individuals().getById(sourceFamily.getHusband().getId()));
                }
                if (sourceFamily.getWife() != null) {
                    targetFamily.setWife((Individual)result.individuals().getById(sourceFamily.getWife().getId()));
                }
                targetFamily.setUnionStatus(sourceFamily.getUnionStatus());
                for (Individual sourceChild : sourceFamily.getChildren()) {
                    targetChild = (Individual)result.individuals().getById(sourceChild.getId());
                    targetFamily.getChildren().add(targetChild);
                    targetChild.setOriginFamily(targetFamily);
                }
                targetFamily.attributes().addAll(sourceFamily.attributes());
            } else {
                for (Individual sourceChild : sourceFamily.getChildren()) {
                    if (targetFamily.getChildren().getById(sourceChild.getId()) != null) continue;
                    targetChild = (Individual)result.individuals().getById(sourceChild.getId());
                    targetFamily.getChildren().add(targetChild);
                    targetChild.setOriginFamily(targetFamily);
                }
                if (sourceFamily.isMarried()) {
                    targetFamily.setMarried(true);
                }
                targetFamily.attributes().addAll(sourceFamily.attributes());
            }
            if (sourceFamily.getHusband() != null) {
                targetParent = (Individual)result.individuals().getById(sourceFamily.getHusband().getId());
                targetParent.getPersonalFamilies().removeById(sourceFamily.getId());
                targetParent.getPersonalFamilies().add(targetFamily);
            }
            if (sourceFamily.getWife() == null) continue;
            targetParent = (Individual)result.individuals().getById(sourceFamily.getWife().getId());
            targetParent.getPersonalFamilies().removeById(sourceFamily.getId());
            targetParent.getPersonalFamilies().add(targetFamily);
        }
        for (RelationModel model : source.relationModels()) {
            result.relationModels().add(new RelationModel(model));
        }
        for (Relation sourceRelation : source.relations()) {
            Relation targetRelation = new Relation(sourceRelation.getId(), sourceRelation.getTypedId(), result.relationModels().getByName(sourceRelation.getModel().getName()), sourceRelation.getName(), new Actor[0]);
            result.relations().add(targetRelation);
            for (Actor sourceActor : sourceRelation.actors()) {
                result.createRelationActor(targetRelation, sourceActor.getId(), sourceActor.getRole().getName());
            }
        }
        return result;
    }

    public static Net copy(Net source) {
        Net result = new Net(source);
        return result;
    }

    public static Net copyWithMarriedCoparents(Net source) {
        Net result = new Net(source);
        NetUtils.marryCoparents(result);
        return result;
    }

    public static Net copyWithoutMarkedDoubles(Net source) throws PuckException {
        Net result = new Net(source);
        NetUtils.eliminateMarkedDoubles(result);
        return result;
    }

    public static Net copyWithoutSingles(Net source) {
        Net result = new Net(source);
        NetUtils.eliminateSingles(result);
        return result;
    }

    public static Net copyWithoutStructuralChildren(Net source) {
        Net result = new Net(source);
        NetUtils.eliminateStructuralChildren(result);
        return result;
    }

    public static Net copyWithoutVirtuals(Net source) {
        Net result = new Net(source);
        NetUtils.eliminateVirtuals(result);
        return result;
    }

    public static Graph<Individual> createOreGraph(Segmentation source) throws PuckException {
        Graph<Individual> result = new Graph<Individual>("Ore graph " + source.getLabel());
        for (Individual individual : source.getCurrentIndividuals().toSortedList()) {
            result.addNode(individual);
        }
        for (Family family : source.getCurrentFamilies()) {
            Individual father = family.getHusband();
            Individual mother = family.getWife();
            if (father != null && mother != null && family.isMarried()) {
                result.addEdge(father, mother, 1.0);
            }
            if (family.isSterile()) continue;
            for (Individual child : family.getChildren()) {
                if (father != null) {
                    result.addArc(father, child, 1.0);
                }
                if (mother == null) continue;
                result.addArc(mother, child, 1.0);
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public static Graph<Family> createPGraph(Segmentation source) throws PuckException {
        Graph<Family> result = new Graph<Family>("Pgraph " + source.getLabel());
        int familyCount = source.getCurrentFamilies().getLastId();
        for (Individual individual : source.getCurrentIndividuals()) {
            Families personalFamilies;
            Family originFamily = individual.getOriginFamily();
            if (originFamily == null) {
                originFamily = new Family(++familyCount);
                originFamily.getChildren().add(individual);
            }
            if ((personalFamilies = individual.getPersonalFamilies()).size() == 0) {
                Family personalFamily = new Family(++familyCount);
                if (individual.isMale()) {
                    personalFamily.setHusband(individual);
                } else if (individual.isFemale()) {
                    personalFamily.setWife(individual);
                }
            }
            for (Family personalFamily : personalFamilies) {
                int weight = 1 - 2 * (individual.getGender().toInt() % 2);
                result.addArc(originFamily, personalFamily, (double)weight);
            }
        }
        return result;
    }

    public static RelationModel createRelationsFromCircuits(Net net, CircuitFinder finder, RelationModel model) throws PuckException {
        model.roles().add(new Role("PIVOT"));
        model.roles().add(new Role("INTERMEDIARY"));
        int i = 0;
        for (Cluster<Chain> cluster : finder.getCircuits().getClusters().toListSortedByValue()) {
            for (Chain r : cluster.getItems()) {
                Relation relation = net.createRelation(i, r.signature(Notation.NUMBERS), model);
                int j = 0;
                while (j < 2 * r.dim()) {
                    Individual pivot = r.getPivot(j);
                    if (!relation.hasActor(pivot)) {
                        net.createRelationActor(relation, pivot.getId(), "PIVOT");
                    }
                    ++j;
                }
                relation.attributes().add(new Attribute("TYPE", cluster.getValue().toString()));
                relation.attributes().add(new Attribute("CLASSIC", r.signature(Notation.CLASSIC_GENDERED)));
                for (Individual indi : r) {
                    if (relation.hasActor(indi)) continue;
                    if (indi instanceof Couple) {
                        if (((Couple)indi).getFirstId() > 0) {
                            net.createRelationActor(relation, ((Couple)indi).getFirstId(), "INTERMEDIARY");
                        }
                        if (((Couple)indi).getSecondId() <= 0) continue;
                        net.createRelationActor(relation, ((Couple)indi).getSecondId(), "INTERMEDIARY");
                        continue;
                    }
                    net.createRelationActor(relation, indi.getId(), "INTERMEDIARY");
                }
                ++i;
            }
        }
        RelationModel result = model;
        return result;
    }

    public static RelationModel createRelationsFromFamilies(Net net) throws PuckException {
        RelationModel model = net.createRelationModel("FamiliesPlus");
        model.roles().add(new Role("HUSBAND"));
        model.roles().add(new Role("WIFE"));
        model.roles().add(new Role("CHILD"));
        for (Family family : net.families()) {
            Relation relation = net.createRelation(family.getId(), family.hashKey(), model);
            if (family.getHusband() != null) {
                net.createRelationActor(relation, family.getHusband().getId(), "HUSBAND");
            }
            if (family.getWife() != null) {
                net.createRelationActor(relation, family.getWife().getId(), "WIFE");
            }
            for (Individual child : family.getChildren()) {
                net.createRelationActor(relation, child.getId(), "CHILD");
            }
            relation.attributes().addAll(family.attributes());
        }
        RelationModel result = model;
        return result;
    }

    public static Graph<Individual> createTipGraph(Segmentation source) throws PuckException {
        Graph<Individual> result = new Graph<Individual>("Tip graph " + source.getLabel());
        for (Individual individual : source.getCurrentIndividuals().toSortedList()) {
            result.addNode(individual);
        }
        for (Family family : source.getCurrentFamilies()) {
            Individual father = family.getHusband();
            Individual mother = family.getWife();
            if (father != null && mother != null && family.isMarried()) {
                Link<Individual> link = result.addArc(mother, father, 1.0);
                link.setTag(":1 'H.F'");
            }
            if (family.isSterile()) continue;
            for (Individual child : family.getChildren()) {
                Link<Individual> link;
                String relationPattern;
                int relationCode;
                if (father != null) {
                    switch (child.getGender()) {
                        case FEMALE: {
                            relationCode = 4;
                            relationPattern = "'F(H)'";
                            break;
                        }
                        case MALE: {
                            relationCode = 5;
                            relationPattern = "'H(H)'";
                            break;
                        }
                        default: {
                            relationCode = 7;
                            relationPattern = "'X(H)'";
                        }
                    }
                    link = result.addArc(father, child, (double)relationCode);
                    link.setTag(":" + relationCode + " " + relationPattern);
                }
                if (mother == null) continue;
                switch (child.getGender()) {
                    case FEMALE: {
                        relationCode = 2;
                        relationPattern = "'F(F)'";
                        break;
                    }
                    case MALE: {
                        relationCode = 3;
                        relationPattern = "'M(F)'";
                        break;
                    }
                    default: {
                        relationCode = 6;
                        relationPattern = "'X(F)'";
                    }
                }
                link = result.addArc(mother, child, (double)relationCode);
                link.setTag(":" + relationCode + " " + relationPattern);
            }
        }
        NetUtils.setGenderShapes(result);
        return result;
    }

    public static int eliminateMarkedDoubles(Net source) throws PuckException {
        int result = NetUtils.eliminateMarkedDoubles(source, source.individuals());
        return result;
    }

    public static int eliminateMarkedDoubles(Net source, Individuals sample) throws PuckException {
        List individuals = sample.toList();
        int result = 0;
        for (Individual sourceIndividual : individuals) {
            if (!NumberUtils.isNumber((String)sourceIndividual.getFirstName())) continue;
            int originalId = Integer.parseInt(sourceIndividual.getFirstName());
            Individual targetIndividual = (Individual)source.individuals().getById(originalId);
            targetIndividual.setAttribute("DOUBLE", String.valueOf(sourceIndividual.getId()));
            UpdateWorker.update(targetIndividual.attributes(), sourceIndividual.attributes(), UpdateWorker.UpdateMode.APPEND);
            if (targetIndividual.getFather() == null && sourceIndividual.getFather() != null) {
                NetUtils.setFatherRelation(source, sourceIndividual.getFather().getId(), targetIndividual.getId());
            }
            if (targetIndividual.getMother() == null && sourceIndividual.getMother() != null) {
                NetUtils.setMotherRelation(source, sourceIndividual.getMother().getId(), targetIndividual.getId());
            }
            for (Family sourceFamily : sourceIndividual.getPersonalFamilies()) {
                Family targetFamily;
                if (sourceIndividual == sourceFamily.getHusband()) {
                    targetFamily = source.families().getBySpouses(targetIndividual, sourceFamily.getWife());
                    if (targetFamily == null) {
                        sourceFamily.setHusband(targetIndividual);
                        targetIndividual.addPersonalFamily(sourceFamily);
                        continue;
                    }
                    targetFamily.getChildren().add(sourceFamily.getChildren());
                    for (Individual child : sourceFamily.getChildren()) {
                        child.setOriginFamily(targetFamily);
                    }
                    if (sourceFamily.getWife() != null) {
                        sourceFamily.getWife().getPersonalFamilies().removeById(sourceFamily.getId());
                    }
                    source.families().removeById(sourceFamily.getId());
                    continue;
                }
                if (sourceIndividual != sourceFamily.getWife()) continue;
                targetFamily = source.families().getBySpouses(sourceFamily.getHusband(), targetIndividual);
                if (targetFamily == null) {
                    sourceFamily.setWife(targetIndividual);
                    targetIndividual.addPersonalFamily(sourceFamily);
                    continue;
                }
                targetFamily.getChildren().add(sourceFamily.getChildren());
                for (Individual child : sourceFamily.getChildren()) {
                    child.setOriginFamily(targetFamily);
                }
                if (sourceFamily.getHusband() != null) {
                    sourceFamily.getHusband().getPersonalFamilies().removeById(sourceFamily.getId());
                }
                source.families().removeById(sourceFamily.getId());
            }
            ++result;
            source.remove(sourceIndividual);
        }
        return result;
    }

    public static int eliminateMarkedDoubles1(Net source, Individuals sample) {
        List individuals = sample.toList();
        int result = 0;
        for (Individual individual : individuals) {
            if (!NumberUtils.isNumber((String)individual.getFirstName())) continue;
            int originalId = Integer.parseInt(individual.getFirstName());
            Individual original = (Individual)source.individuals().getById(originalId);
            original.setAttribute("DOUBLE", String.valueOf(individual.getId()));
            source.remove(individual);
            ++result;
            for (Attribute sourceAttribute : individual.attributes()) {
                Attribute targetAttribute = (Attribute)original.attributes().get(sourceAttribute.getLabel());
                if (targetAttribute == null) {
                    original.attributes().put(sourceAttribute.getLabel(), sourceAttribute.getValue());
                    continue;
                }
                targetAttribute.setValue(sourceAttribute.getValue());
            }
        }
        return result;
    }

    public static int eliminateSingles(Net source) {
        int result = NetUtils.eliminateSingles(source, source.individuals());
        return result;
    }

    public static int eliminateSingles(Net source, Individuals sample) {
        List individuals = sample.toList();
        int result = 0;
        for (Individual individual : individuals) {
            if (!individual.isSingle()) continue;
            source.remove(individual);
            ++result;
        }
        return result;
    }

    public static int eliminateStructuralChildren(Net source) {
        int result = NetUtils.eliminateStructuralChildren(source, source.individuals());
        return result;
    }

    public static int eliminateStructuralChildren(Net source, Individuals sample) {
        List individuals = sample.toList();
        int result = 0;
        for (Individual individual : individuals) {
            if (!individual.isSingle() || !individual.isSterile()) continue;
            source.remove(individual);
            ++result;
        }
        return result;
    }

    public static int eliminateVirtuals(Net source) {
        int result = NetUtils.eliminateVirtuals(source, source.individuals());
        return result;
    }

    public static int eliminateVirtuals(Net source, Individuals sample) {
        List individuals = sample.toList();
        int result = 0;
        for (Individual individual : individuals) {
            if (!StringUtils.isBlank((CharSequence)individual.getName()) && !individual.getName().equals("?") && individual.getName().charAt(0) != '#') continue;
            source.remove(individual);
            ++result;
        }
        return result;
    }

    private static void expand(Individuals individuals, Individual ego, KinType kinType) {
        if (!individuals.contains(ego)) {
            individuals.add(ego);
            Individuals kin = kinType == null ? ego.getKin() : ego.getKin(kinType);
            for (Individual alter : kin) {
                NetUtils.expand(individuals, alter, kinType);
            }
        }
    }

    public static Net expand(Net source, Segment segment, KinType direction) {
        Individuals individuals = new Individuals();
        for (Individual individual : segment.getCurrentIndividuals()) {
            NetUtils.expand(individuals, individual, direction);
        }
        Net result = NetUtils.extract(source, individuals);
        String label = String.valueOf(result.getLabel()) + "_" + segment.getLabel() + "_expanded";
        if (direction != null) {
            label = String.valueOf(label) + "_" + (Object)((Object)direction);
        }
        result.setLabel(label);
        return result;
    }

    public static Net extract(Net source, Individuals sourceIndividuals) {
        Net result = new Net();
        result.setLabel(source.getLabel());
        for (Individual sourceIndividual : sourceIndividuals) {
            Individual targetIndividual = new Individual(sourceIndividual.getId());
            targetIndividual.setGender(sourceIndividual.getGender());
            targetIndividual.setName(sourceIndividual.getName());
            targetIndividual.setOriginFamily(sourceIndividual.getOriginFamily());
            targetIndividual.getPersonalFamilies().add(sourceIndividual.getPersonalFamilies());
            targetIndividual.attributes().addAll(sourceIndividual.attributes());
            result.individuals().add(targetIndividual);
        }
        for (Family sourceFamily : source.families()) {
            Individual sourceFather = sourceFamily.getFather();
            Individual targetFather = sourceFather == null ? null : (Individual)result.individuals().getById(sourceFather.getId());
            Individual sourceMother = sourceFamily.getMother();
            Individual targetMother = sourceMother == null ? null : (Individual)result.individuals().getById(sourceMother.getId());
            if (targetFather == null && targetMother == null) continue;
            Family targetFamily = new Family(sourceFamily.getId());
            targetFamily.setMarried(sourceFamily.isMarried());
            targetFamily.setFather(targetFather);
            targetFamily.setMother(targetMother);
            for (Individual sourceChild : sourceFamily.getChildren()) {
                Individual targetChild = (Individual)result.individuals().getById(sourceChild.getId());
                if (targetChild == null) continue;
                targetFamily.getChildren().add(targetChild);
            }
            if ((targetFather == null || targetMother == null) && targetFamily.getChildren().isEmpty()) continue;
            result.families().add(targetFamily);
        }
        for (Individual targetIndividual : result.individuals()) {
            Family sourceOriginFamily = targetIndividual.getOriginFamily();
            if (sourceOriginFamily != null) {
                Family targetOriginFamily = (Family)result.families().getById(sourceOriginFamily.getId());
                targetIndividual.setOriginFamily(targetOriginFamily);
            }
            for (Family sourcePersonalFamily : targetIndividual.getPersonalFamilies().toList()) {
                Family targetPersonalFamily = (Family)result.families().getById(sourcePersonalFamily.getId());
                targetIndividual.getPersonalFamilies().removeById(sourcePersonalFamily.getId());
                if (targetPersonalFamily == null) continue;
                targetIndividual.getPersonalFamilies().add(targetPersonalFamily);
            }
        }
        return result;
    }

    public static Net extractByClusterSize(Net source, String label, int minimalNumberOfMembers) throws PuckException {
        Partition<Individual> partition = PartitionMaker.createRaw(source, label);
        Individuals individuals = new Individuals();
        for (Cluster<Individual> cluster : partition.getClusters()) {
            if (cluster.isNull() || cluster.count() < minimalNumberOfMembers) continue;
            individuals.add(cluster.getItems());
        }
        Net result = NetUtils.extract(source, individuals);
        result.setLabel(String.valueOf(result.getLabel()) + "_" + label + "_min_" + minimalNumberOfMembers);
        return result;
    }

    public static Net extractByClusterValue(Net source, String label, int minimalValue) throws PuckException {
        String[] labels = label.split("\\s");
        Partition<Individual> partition = labels.length == 2 ? PartitionMaker.createRaw(source, labels[0], labels[1]) : PartitionMaker.createRaw(source, label);
        Individuals individuals = new Individuals();
        for (Cluster<Individual> cluster : partition.getClusters()) {
            if (cluster.isNull() || !(cluster.getValue().doubleValue() >= (double)minimalValue)) continue;
            individuals.add(cluster.getItems());
        }
        Net result = NetUtils.extract(source, individuals);
        result.setLabel(String.valueOf(result.getLabel()) + "_" + label + "_min_" + minimalValue);
        return result;
    }

    public static Individual fixFatherByGender(Individual ego, Individual alter) {
        Individual result = ego == null && alter == null ? null : (ego == null ? (alter.isFemale() ? ego : alter) : (alter == null ? (ego.isMale() ? ego : alter) : (ego.isMale() || alter.isFemale() && ego.isUnknown() ? ego : alter)));
        return result;
    }

    public static Individual fixMotherByGender(Individual ego, Individual alter) {
        Individual newHusband = NetUtils.fixFatherByGender(ego, alter);
        Individual result = newHusband == ego ? alter : ego;
        return result;
    }

    public static void fixSpouseRolesByGender(Family family) {
        Individual newHusband;
        if (family != null && (newHusband = NetUtils.fixFatherByGender(family.getHusband(), family.getWife())) != family.getHusband()) {
            NetUtils.swapParents(family);
        }
    }

    public static void fixSpouseRolesByGender2(Family family) {
        if (family != null) {
            Individual wife;
            Individual husband;
            Individual ego = family.getHusband();
            Individual alter = family.getWife();
            if (ego.isMale() || alter.isFemale() && ego.isUnknown()) {
                husband = ego;
                wife = alter;
            } else {
                husband = alter;
                wife = ego;
            }
            family.setHusband(husband);
            family.setWife(wife);
        }
    }

    public static boolean isFemaleFatherOrMaleMother(Individual father, Individual mother) {
        boolean result = father == null || mother == null ? false : father.isFemale() || mother.isMale();
        return result;
    }

    public static boolean isParentChildMarriage(Individual parent, Individual children) {
        boolean result = parent == null || children == null ? false : children.getSpouses().contains(parent);
        return result;
    }

    public static boolean isParentChildMarriage(Individual parent, Individual ... children) {
        boolean result;
        if (parent == null) {
            result = false;
        } else {
            boolean ended = false;
            result = false;
            int childIndex = 0;
            while (!ended) {
                if (childIndex < children.length) {
                    if (NetUtils.isParentChildMarriage(parent, children[childIndex])) {
                        ended = true;
                        result = true;
                        continue;
                    }
                    ++childIndex;
                    continue;
                }
                ended = true;
                result = false;
            }
        }
        return result;
    }

    public static boolean isParentChildMarriage(Individual father, Individual mother, Individual ... children) {
        boolean result = NetUtils.isParentChildMarriage(father, children) || NetUtils.isParentChildMarriage(mother, children);
        return result;
    }

    public static boolean isRolesFixedByGender(Individual ego, Individual alter) {
        Individual newHusband = NetUtils.fixFatherByGender(ego, alter);
        boolean result = newHusband == ego;
        return result;
    }

    public static boolean isSame(Individual ego, Individual alter) {
        boolean result = ego == null || alter == null ? false : ego == alter;
        return result;
    }

    public static boolean isSameSex(Individual ego, Individual alter) {
        boolean result = ego == null || alter == null || ego.isUnknown() || alter.isUnknown() ? false : ego.getGender() == alter.getGender();
        return result;
    }

    public static int marryCoparents(Net source) {
        int result = 0;
        for (Family family : source.families()) {
            if (family.isSterile() || family.isSingleParent() || family.isMarried()) continue;
            family.setMarried();
            ++result;
        }
        return result;
    }

    public static void numberNames(Individuals source) {
        if (source != null) {
            for (Individual individual : source) {
                individual.setName(String.valueOf(individual.getTrimmedName()) + " (" + individual.getId() + ")");
            }
        }
    }

    public static void numberNames(Net source) {
        if (source != null) {
            NetUtils.numberNames(source.individuals());
        }
    }

    public static void removeFather(Family family) {
        if (family != null) {
            family.getFather().getPersonalFamilies().removeById(family.getId());
            family.setFather(null);
        }
    }

    public static void removeMother(Family family) {
        if (family != null && family.getMother() != null) {
            family.getMother().getPersonalFamilies().removeById(family.getId());
            family.setMother(null);
        }
    }

    public static void removeSpouse(Family family, Individual spouse) {
        if (family != null && spouse != null) {
            if (family.getFather() == spouse) {
                NetUtils.removeFather(family);
            } else if (family.getMother() == spouse) {
                NetUtils.removeMother(family);
            }
        }
    }

    public static void renumberate(Net source) {
    }

    public static void setAttribute(Net net, int individualId, String label, String value) throws PuckException {
        if (net != null && individualId != 0 && StringUtils.isNotBlank((CharSequence)label) && StringUtils.isNotBlank((CharSequence)value)) {
            Individual individual = (Individual)net.individuals().getById(individualId);
            if (individual == null) {
                individual = new Individual(individualId);
                net.individuals().add(individual);
            }
            individual.attributes().put(label, value);
        }
    }

    public static void setFatherRelation(Net net, int fatherId, int childId) throws PuckException {
        if (net != null && fatherId != 0 && childId != 0) {
            Family childSourceFamily;
            Individual child;
            Individual parent = (Individual)net.individuals().getById(fatherId);
            if (parent == null) {
                parent = new Individual(fatherId);
                net.individuals().add(parent);
            }
            if ((child = (Individual)net.individuals().getById(childId)) == null) {
                child = new Individual(childId);
                net.individuals().add(child);
            }
            if (child.getOriginFamily() == null) {
                childSourceFamily = new Family(net.families().size() + 1);
                net.families().add(childSourceFamily);
                child.setOriginFamily(childSourceFamily);
                childSourceFamily.getChildren().add(child);
            } else {
                childSourceFamily = child.getOriginFamily();
                if (childSourceFamily.getFather() != null) {
                    childSourceFamily.getFather().getPersonalFamilies().removeById(childSourceFamily.getId());
                }
            }
            childSourceFamily.setFather(parent);
            Family parentPersonalFamily = (Family)parent.getPersonalFamilies().getById(childSourceFamily.getId());
            if (parentPersonalFamily == null) {
                parent.getPersonalFamilies().add(childSourceFamily);
            }
        }
    }

    public static void setGenderShapes(Graph<Individual> graph) {
        for (Node<Individual> node : graph.getNodes()) {
            node.setTag(node.getReferent().getGender().toShapeString());
        }
    }

    public static void setKin(Net net, Individual ego, Individual alter, KinType type) throws PuckException {
        if (ego == null || alter == null || type == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        switch (type) {
            case PARENT: {
                NetUtils.setKinParent(net, ego, alter);
                break;
            }
            case CHILD: {
                NetUtils.setKinParent(net, alter, ego);
                break;
            }
            case SPOUSE: {
                NetUtils.setKinSpouse(net, ego, alter);
            }
        }
    }

    public static void setKinFather(Family family, Individual newFather) {
        if (family != null) {
            if (family.getFather() != null) {
                NetUtils.removeFather(family);
            }
            if (newFather != null && (family.getMother() == null || newFather.getId() != family.getMother().getId())) {
                family.setFather(newFather);
                newFather.getPersonalFamilies().add(family);
            }
        }
    }

    public static void setKinFather(Net net, Individual father, Individual child) {
        NetUtils.setKinParent(net, father, KinType.FATHER, child);
    }

    public static void setKinMother(Family family, Individual newMother) {
        if (family != null) {
            if (family.getMother() != null) {
                NetUtils.removeMother(family);
            }
            if (newMother != null && (family.getFather() == null || newMother.getId() != family.getFather().getId())) {
                family.setMother(newMother);
                newMother.getPersonalFamilies().add(family);
            }
        }
    }

    public static void setKinMother(Net net, Individual mother, Individual child) {
        NetUtils.setKinParent(net, mother, KinType.MOTHER, child);
    }

    public static void setKinParent(Net net, Individual parent, Individual child) {
        switch (parent.getGender()) {
            case FEMALE: {
                NetUtils.setKinParent(net, parent, KinType.MOTHER, child);
                break;
            }
            case MALE: {
                NetUtils.setKinParent(net, parent, KinType.FATHER, child);
            }
        }
    }

    public static void setKinParent(Net net, Individual newParent, KinType parentRole, Individual child) {
        if (child != null && parentRole != null && (parentRole == KinType.FATHER || parentRole == KinType.MOTHER)) {
            if (parentRole == KinType.FATHER) {
                if (child.getFather() != null && child.getFather() != newParent) {
                    Family previousFamily = child.getOriginFamily();
                    previousFamily.getChildren().removeById(child.getId());
                    child.setOriginFamily(null);
                    if (previousFamily.getMother() != null) {
                        net.createFamily(null, previousFamily.getMother(), child);
                    }
                    if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                        net.remove(previousFamily);
                    }
                }
                if (newParent != null) {
                    if (child.getOriginFamily() == null) {
                        net.createFamily(newParent, null, child);
                    } else if (child.getFather() == null && child.getMother() == null) {
                        child.getOriginFamily().setFather(newParent);
                    } else if (child.getFather() == null && child.getMother() != null) {
                        Family newOriginFamily = net.families().getBySpouses(newParent, child.getOriginFamily().getMother());
                        if (newOriginFamily == null) {
                            child.getOriginFamily().setFather(newParent);
                            child.getFather().getPersonalFamilies().add(child.getOriginFamily());
                        } else {
                            Family previousFamily = child.getOriginFamily();
                            previousFamily.getChildren().removeById(child.getId());
                            if (previousFamily.isEmpty()) {
                                net.remove(previousFamily);
                            }
                            child.setOriginFamily(newOriginFamily);
                            newOriginFamily.getChildren().add(child);
                            if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                                net.remove(previousFamily);
                            }
                        }
                    }
                }
            } else if (parentRole == KinType.MOTHER) {
                if (child.getMother() != null && child.getMother() != newParent) {
                    Family previousFamily = child.getOriginFamily();
                    previousFamily.getChildren().removeById(child.getId());
                    child.setOriginFamily(null);
                    if (previousFamily.getFather() != null) {
                        net.createFamily(previousFamily.getFather(), null, child);
                    }
                    if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                        net.remove(previousFamily);
                    }
                }
                if (newParent != null) {
                    if (child.getOriginFamily() == null) {
                        net.createFamily(null, newParent, child);
                    } else if (child.getFather() == null && child.getMother() == null) {
                        child.getOriginFamily().setMother(newParent);
                    } else if (child.getFather() != null && child.getMother() == null) {
                        Family newOriginFamily = net.families().getBySpouses(child.getOriginFamily().getFather(), newParent);
                        if (newOriginFamily == null) {
                            child.getOriginFamily().setMother(newParent);
                            child.getMother().getPersonalFamilies().add(child.getOriginFamily());
                        } else {
                            Family previousFamily = child.getOriginFamily();
                            previousFamily.getChildren().removeById(child.getId());
                            if (previousFamily.isEmpty()) {
                                net.remove(previousFamily);
                            }
                            child.setOriginFamily(newOriginFamily);
                            newOriginFamily.getChildren().add(child);
                            if (previousFamily.isSterile() && previousFamily.isSingleParent() && previousFamily.attributes().size() == 0) {
                                net.remove(previousFamily);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void setKinParent2(Net net, Individual newParent, KinType parentRole, Individual child) {
        if (parentRole != null && (parentRole == KinType.FATHER || parentRole == KinType.MOTHER)) {
            if (child.isOrphan()) {
                if (child.getOriginFamily() == null) {
                    if (parentRole == KinType.MOTHER) {
                        child.getOriginFamily().setMother(newParent);
                    } else {
                        child.getOriginFamily().setFather(newParent);
                    }
                } else if (parentRole == KinType.MOTHER) {
                    net.createFamily(null, newParent, child);
                } else {
                    net.createFamily(newParent, null, child);
                }
                newParent.getPersonalFamilies().add(child.getOriginFamily());
            } else if (child.isOrphanOfMother() && parentRole == KinType.FATHER) {
                if (child.getOriginFamily().getFather() != newParent) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        Individual previousFather = child.getOriginFamily().getFather();
                        previousFather.getPersonalFamilies().removeById(child.getOriginFamily().getId());
                        child.getOriginFamily().setFather(newParent);
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(newParent, null, child);
                    }
                }
            } else if (child.isOrphanOfFather() && parentRole == KinType.MOTHER) {
                if (child.getOriginFamily().getMother() != newParent) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        child.getOriginFamily().getMother().getPersonalFamilies().removeById(child.getOriginFamily().getId());
                        child.getOriginFamily().setMother(newParent);
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(child.getFather(), newParent, child);
                    }
                }
            } else if (child.isOrphanOfMother() && parentRole == KinType.MOTHER) {
                Family newChildOriginFamily = net.families().getBySpouses(child.getOriginFamily().getFather(), newParent);
                if (newChildOriginFamily == null) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        child.getOriginFamily().setMother(newParent);
                        newParent.getPersonalFamilies().add(child.getOriginFamily());
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(child.getFather(), newParent, child);
                    }
                } else if (child.getOriginFamily().getChildren().size() == 1) {
                    child.getFather().getPersonalFamilies().removeById(child.getOriginFamily().getId());
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.families().removeById(child.getOriginFamily().getId());
                    child.setOriginFamily(newChildOriginFamily);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().add(child);
                }
            } else if (child.isOrphanOfFather() && parentRole == KinType.FATHER) {
                Family newChildOriginFamily = net.families().getBySpouses(newParent, child.getOriginFamily().getMother());
                if (newChildOriginFamily == null) {
                    if (child.getOriginFamily().getChildren().size() == 1) {
                        child.getOriginFamily().setFather(newParent);
                        newParent.getPersonalFamilies().add(child.getOriginFamily());
                    } else {
                        child.getOriginFamily().getChildren().removeById(child.getId());
                        net.createFamily(child.getFather(), newParent, child);
                    }
                } else if (child.getOriginFamily().getChildren().size() == 1) {
                    child.getMother().getPersonalFamilies().removeById(child.getOriginFamily().getId());
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.families().removeById(child.getOriginFamily().getId());
                    child.setOriginFamily(newChildOriginFamily);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().add(child);
                }
            } else if (parentRole == KinType.FATHER && child.getFather() != newParent) {
                Family newChildOriginFamily = net.families().getBySpouses(newParent, child.getOriginFamily().getMother());
                if (newChildOriginFamily == null) {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.createFamily(newParent, child.getMother(), child);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().put(child);
                }
            } else if (parentRole == KinType.MOTHER && child.getMother() != newParent) {
                Family newChildOriginFamily = net.families().getBySpouses(child.getOriginFamily().getFather(), newParent);
                if (newChildOriginFamily == null) {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    net.createFamily(child.getFather(), newParent, child);
                } else {
                    child.getOriginFamily().getChildren().removeById(child.getId());
                    child.setOriginFamily(newChildOriginFamily);
                    child.getOriginFamily().getChildren().put(child);
                }
            }
        }
    }

    public static void setKinRelation(Net net, Individual ego, Individual alter, KinType kinType) throws PuckException {
        int egoId = ego.getId();
        int alterId = alter.getId();
        block0 : switch (kinType) {
            case PARENT: {
                switch (alter.getGender()) {
                    case MALE: {
                        NetUtils.setFatherRelation(net, alterId, egoId);
                        break;
                    }
                    case FEMALE: {
                        NetUtils.setMotherRelation(net, alterId, egoId);
                    }
                }
                break;
            }
            case CHILD: {
                switch (ego.getGender()) {
                    case MALE: {
                        NetUtils.setFatherRelation(net, egoId, alterId);
                        break;
                    }
                    case FEMALE: {
                        NetUtils.setMotherRelation(net, egoId, alterId);
                    }
                }
                break;
            }
            case SPOUSE: {
                switch (ego.getGender()) {
                    case MALE: {
                        NetUtils.setSpouseRelation(net, egoId, alterId);
                        break block0;
                    }
                    case FEMALE: {
                        NetUtils.setSpouseRelation(net, alterId, egoId);
                    }
                }
            }
        }
    }

    public static void setKinSpouse(Net net, Individual ego, Individual alter) {
        Individual wife;
        Individual husband;
        if (ego.isMale() || alter.isFemale() && ego.isUnknown()) {
            husband = ego;
            wife = alter;
        } else {
            wife = ego;
            husband = alter;
        }
        NetUtils.setKinSpouseByRole(net, husband, wife);
    }

    public static void setKinSpouseByRole(Net net, Individual husband, Individual wife) {
        Family family = net.families().getBySpouses(husband, wife);
        if (family == null) {
            family = new Family(net.families().getFirstFreeId());
            net.families().add(family);
            husband.getPersonalFamilies().add(family);
            wife.getPersonalFamilies().add(family);
        }
        family.setHusband(husband);
        family.setWife(wife);
        family.setMarried(true);
    }

    public static void setMotherRelation(Net net, int motherId, int childId) throws PuckException {
        if (net != null && motherId != 0 && childId != 0) {
            Family childSourceFamily;
            Individual child;
            Individual parent = (Individual)net.individuals().getById(motherId);
            if (parent == null) {
                parent = new Individual(motherId);
                net.individuals().add(parent);
            }
            if ((child = (Individual)net.individuals().getById(childId)) == null) {
                child = new Individual(childId);
                net.individuals().add(child);
            }
            if (child.getOriginFamily() == null) {
                childSourceFamily = new Family(net.families().size() + 1);
                net.families().add(childSourceFamily);
                child.setOriginFamily(childSourceFamily);
                childSourceFamily.getChildren().add(child);
            } else {
                childSourceFamily = child.getOriginFamily();
                if (childSourceFamily.getMother() != null) {
                    childSourceFamily.getMother().getPersonalFamilies().removeById(childSourceFamily.getId());
                }
            }
            childSourceFamily.setMother(parent);
            Family parentPersonalFamily = (Family)parent.getPersonalFamilies().getById(childSourceFamily.getId());
            if (parentPersonalFamily == null) {
                parent.getPersonalFamilies().add(childSourceFamily);
            }
        }
    }

    public static void setParentRelation(Net net, int parentId, int childId) throws PuckException {
        if (net != null && parentId != 0 && childId != 0) {
            Family childSourceFamily;
            Individual child;
            Individual parent = (Individual)net.individuals().getById(parentId);
            if (parent == null) {
                parent = new Individual(parentId);
                net.individuals().add(parent);
            }
            if ((child = (Individual)net.individuals().getById(childId)) == null) {
                child = new Individual(childId);
                net.individuals().add(child);
            }
            if (child.getOriginFamily() == null) {
                childSourceFamily = new Family(net.families().size() + 1);
                net.families().add(childSourceFamily);
                child.setOriginFamily(childSourceFamily);
                childSourceFamily.getChildren().add(child);
            } else {
                childSourceFamily = child.getOriginFamily();
            }
            switch (parent.getGender()) {
                case FEMALE: {
                    childSourceFamily.setMother(parent);
                    break;
                }
                case MALE: 
                case UNKNOWN: {
                    childSourceFamily.setFather(parent);
                }
            }
            Family parentPersonalFamily = (Family)parent.getPersonalFamilies().getById(childSourceFamily.getId());
            if (parentPersonalFamily == null) {
                parent.getPersonalFamilies().add(childSourceFamily);
            }
        }
    }

    public static Family setSpouseRelation(Net net, int husbandId, int wifeId) throws PuckException {
        Family result;
        if (net == null || husbandId == 0 || wifeId == 0) {
            result = null;
        } else {
            Family family;
            Individual wife;
            boolean isNewFamily = false;
            Individual husband = (Individual)net.individuals().getById(husbandId);
            if (husband == null) {
                husband = new Individual(husbandId);
                net.individuals().add(husband);
                isNewFamily = true;
            }
            if ((wife = (Individual)net.individuals().getById(wifeId)) == null) {
                wife = new Individual(wifeId);
                net.individuals().add(wife);
                isNewFamily = true;
            }
            if ((family = isNewFamily ? null : net.families().getBySpouses(husband, wife)) == null) {
                family = new Family(net.families().size() + 1);
                net.families().add(family);
                family.setHusband(husband);
                family.setWife(wife);
                husband.getPersonalFamilies().add(family);
                wife.getPersonalFamilies().add(family);
            }
            family.setMarried(true);
            result = family;
        }
        return result;
    }

    public static void setSpouseRelationAndFixRoles(Net net, int husbandId, int wifeId) throws PuckException {
        Family family = NetUtils.setSpouseRelation(net, husbandId, wifeId);
        if (family != null) {
            NetUtils.fixSpouseRolesByGender(family);
        }
    }

    public static void swapParents(Family source) {
        if (source != null) {
            Individual pivot = source.getFather();
            source.setFather(source.getMother());
            source.setMother(pivot);
        }
    }
}

