/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.NumberedIntegers;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class IndividualValuator {
    public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");

    public static String ageAtYear(Individual source, int year) {
        Integer birtYear = IndividualValuator.getBirthYear(source);
        Integer deatYear = IndividualValuator.getDeathYear(source);
        String result = "UNKNOWN";
        if (birtYear != null && birtYear > year) {
            result = "UNBORN";
        } else if (deatYear != null && deatYear < year) {
            result = "DEAD";
        } else if (birtYear != null) {
            result = String.valueOf(year - birtYear);
        }
        return result;
    }

    public static Individuals extract(Individuals source, String label, Object parameter, Value value) {
        Individuals result = new Individuals();
        for (Individual individual : source) {
            if (!IndividualValuator.get(individual, label, parameter).equals(value)) continue;
            result.put(individual);
        }
        return result;
    }

    public static String extractYear(String source) {
        String result;
        try {
            result = String.valueOf(Integer.parseInt(source));
        }
        catch (NumberFormatException nfe) {
            Matcher matcher = YEAR_PATTERN.matcher(source);
            result = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) : null;
        }
        return result;
    }

    public static Value get(Individual source, String label) {
        Value result = IndividualValuator.get(source, label, null);
        return result;
    }

    public static Value get(Individual source, String label, Object parameter) {
        Object result;
        EndogenousLabel enogenousLabel;
        try {
            enogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
        }
        catch (IllegalArgumentException exception) {
            enogenousLabel = null;
        }
        if (enogenousLabel == null) {
            String year;
            String attributeValue = source.getAttributeValue(label);
            result = attributeValue == null ? null : (label.toUpperCase().contains("DATE") ? ((year = IndividualValuator.extractYear(attributeValue)) == null ? null : new Value(Integer.parseInt(year))) : new Value(attributeValue));
        } else {
            switch (enogenousLabel) {
                case DEPTH: {
                    result = new Value(StatisticsWorker.depth(source));
                    break;
                }
                case FIRSTN: {
                    if (source.getFirstName() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getFirstName());
                    break;
                }
                case FRATM: {
                    Individual parent = source.getMother();
                    if (parent == null) {
                        result = new Value(-source.getId());
                        break;
                    }
                    result = new Value(parent.getId());
                    break;
                }
                case FRATP: {
                    Individual parent = source.getFather();
                    if (parent == null) {
                        result = new Value(-source.getId());
                        break;
                    }
                    result = new Value(parent.getId());
                    break;
                }
                case ID: {
                    result = new Value(source.getId());
                    break;
                }
                case LASTN: {
                    if (source.getLastName() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getLastName());
                    break;
                }
                case PARTN: {
                    result = new Value(source.getPartners().size());
                    break;
                }
                case MATRIC: {
                    result = new Value(StatisticsWorker.ancestor(source, FiliationType.UTERINE));
                    break;
                }
                case MATRID: {
                    result = new Value(StatisticsWorker.depth(source, FiliationType.UTERINE));
                    break;
                }
                case MDEPTH: {
                    result = new Value(StatisticsWorker.meanDepth(source));
                    break;
                }
                case PATRIC: {
                    result = new Value(StatisticsWorker.ancestor(source, FiliationType.AGNATIC));
                    break;
                }
                case PATRID: {
                    result = new Value(StatisticsWorker.depth(source, FiliationType.AGNATIC));
                    break;
                }
                case PEDG: {
                    if (parameter == null || !(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(StatisticsWorker.numberOfLinearKin(source, Integer.parseInt((String)parameter)));
                    break;
                }
                case PROG: {
                    if (parameter == null || !(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(StatisticsWorker.numberOfLinearKin(source, -1 * Integer.parseInt((String)parameter)));
                    break;
                }
                case GENDER: {
                    result = new Value(source.getGender());
                    break;
                }
                case SPOU: {
                    result = new Value(source.getSpouses().size());
                    break;
                }
                case SIMPLE: {
                    result = new Value(source.getName());
                    break;
                }
                case AGE: {
                    if (parameter == null || !(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(IndividualValuator.ageAtYear(source, Integer.parseInt((String)parameter)));
                    break;
                }
                case UNIONSTATUS: {
                    result = new Value(IndividualValuator.getMatrimonialStatus(source));
                    break;
                }
                case FIRST_CHILD_BIRT_PLAC: {
                    String firstChildBirthPlace = IndividualValuator.getFirstChildBirthPlace(source);
                    if (firstChildBirthPlace == null) {
                        result = null;
                        break;
                    }
                    result = new Value(firstChildBirthPlace);
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public static NumberedValues get(Individuals source, String label) {
        NumberedValues result = IndividualValuator.get(source, label, null);
        return result;
    }

    public static NumberedValues get(Individuals source, String label, Object parameter) {
        NumberedValues result = new NumberedValues();
        if (label.equals("GEN")) {
            NumberedIntegers data = StatisticsWorker.genData(source);
            for (Integer key : data.keySet()) {
                result.addValue((int)key, (Integer)data.get(key));
            }
        } else if (label.equals("DEPTH")) {
            NumberedIntegers data = StatisticsWorker.depthData(source, FiliationType.COGNATIC);
            for (Integer key : data.keySet()) {
                result.addValue((int)key, (Integer)data.get(key));
            }
        } else if (label.equals("MATRIC")) {
            HashMap<Individual, Individual> ancestors = StatisticsWorker.ancestors(source, FiliationType.UTERINE);
            for (Individual ego : ancestors.keySet()) {
                result.addValue(ego.getId(), ancestors.get(ego));
            }
        } else if (label.equals("MATRID")) {
            NumberedIntegers depths = StatisticsWorker.depthData(source, FiliationType.UTERINE);
            for (Integer individualId : depths.keySet()) {
                result.addValue((int)individualId, (Integer)depths.get(individualId));
            }
        } else if (label.equals("PATRIC")) {
            HashMap<Individual, Individual> ancestors = StatisticsWorker.ancestors(source, FiliationType.AGNATIC);
            for (Individual ego : ancestors.keySet()) {
                result.addValue(ego.getId(), ancestors.get(ego));
            }
        } else if (label.equals("PATRID")) {
            NumberedIntegers depths = StatisticsWorker.depthData(source, FiliationType.AGNATIC);
            for (Integer individualId : depths.keySet()) {
                result.addValue((int)individualId, (Integer)depths.get(individualId));
            }
        } else {
            for (Individual individual : source) {
                result.put(individual.getId(), IndividualValuator.get(individual, label, parameter));
            }
        }
        return result;
    }

    public static List<String> getAttributeLabels(Individuals individuals) {
        List<String> result = IndividualValuator.getAttributeLabels(individuals, null);
        return result;
    }

    public static List<String> getAttributeLabels(Individuals individuals, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        EndogenousLabel[] endogenousLabelArray = EndogenousLabel.values();
        int n = endogenousLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel label = endogenousLabelArray[n2];
            result.add(label.toString());
            ++n2;
        }
        result.addAll(IndividualValuator.getExogenousAttributeLabels(individuals, limit));
        Collections.sort(result);
        return result;
    }

    public static List<String> getAttributeLabelSample(Individuals individuals) {
        List<String> result = IndividualValuator.getAttributeLabels(individuals, 10000);
        return result;
    }

    public static Integer getBirthYear(Individual individual) {
        String birtDate;
        Integer result = individual == null ? null : ((birtDate = individual.getAttributeValue("BIRT_DATE")) == null ? null : Integer.valueOf(Integer.parseInt(IndividualValuator.extractYear(birtDate))));
        return result;
    }

    public static Integer getDeathYear(Individual individual) {
        String deatDate;
        Integer result = individual == null ? null : ((deatDate = individual.getAttributeValue("DEAT_DATE")) == null ? null : Integer.valueOf(Integer.parseInt(IndividualValuator.extractYear(deatDate))));
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Individuals individuals) {
        List<String> result = IndividualValuator.getExogenousAttributeLabels(individuals, null);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Individuals individuals, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        HashSet<String> buffer = new HashSet<String>();
        if (individuals != null) {
            int index = 0;
            Iterator iterator = individuals.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Individual individual = (Individual)iterator.next();
                for (Attribute attribute : individual.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
        }
        for (String string : buffer) {
            result.add(string);
        }
        Collections.sort(result);
        return result;
    }

    public static String getFirstChildBirthPlace(Individual individual) {
        String result = null;
        Individual firstChild = individual.getKin(KinType.CHILD, IndividualComparator.Sorting.BIRT_YEAR, 1);
        if (firstChild != null) {
            result = firstChild.getAttributeValue("BIRT_PLAC");
        }
        return result;
    }

    public static Integer getMarriageYear(Family family) {
        String year;
        Integer result = null;
        if (family != null && (year = IndividualValuator.extractYear(family.getAttributeValue("MARR_DATE"))) != null) {
            result = Integer.parseInt(year);
        }
        return result;
    }

    public static Integer getMarriageYear(Individual ego, Individual alter) {
        String year;
        Integer result = null;
        Family family = IndividualValuator.getUnion(ego, alter);
        if (family != null && (year = IndividualValuator.extractYear(family.getAttributeValue("MARR_DATE"))) != null) {
            result = Integer.parseInt(year);
        }
        return result;
    }

    public static String getMatrimonialStatus(Individual source) {
        String result = "SINGLE";
        if (source.getPersonalFamilies() != null) {
            for (Family family : source.getPersonalFamilies()) {
                result = "NOT_SINGLE";
                if (family.getUnionStatus().equals((Object)UnionStatus.MARRIED)) {
                    if (result.equals("MARRIED")) {
                        result = "REMARRIED";
                        continue;
                    }
                    result = "MARRIED";
                    continue;
                }
                if (!family.getUnionStatus().equals((Object)UnionStatus.DIVORCED)) continue;
                result = "DIVORCED";
            }
        }
        return result;
    }

    public static Family getUnion(Individual ego, Individual alter) {
        Family result = null;
        Families families = ego.getPersonalFamilies();
        if (families != null) {
            for (Family family : families) {
                if (family.getOtherParent(ego) == alter) continue;
                result = family;
                break;
            }
        }
        return result;
    }

    public static enum EndogenousLabel {
        AGE,
        DEPTH,
        FIRST_CHILD_BIRT_PLAC,
        FIRSTN,
        FRATM,
        FRATP,
        GEN,
        GENDER,
        ID,
        LASTN,
        MDEPTH,
        MATRIC,
        MATRID,
        PARTN,
        PATRIC,
        PATRID,
        PEDG,
        PROG,
        SIMPLE,
        SPOU,
        UNIONSTATUS;

    }
}

