/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.mas;

import java.io.BufferedReader;
import java.io.FileReader;
import org.tip.puck.mas.MAS;
import org.tip.puck.mas.WFAgeLimits;
import org.tip.puck.mas.WFAgnaticCousins;
import org.tip.puck.mas.WFChildren;
import org.tip.puck.mas.WFChildrenCouple;
import org.tip.puck.mas.WFChildrenFather;
import org.tip.puck.mas.WFChildrenMother;
import org.tip.puck.mas.WFCousins;
import org.tip.puck.mas.WFDivorce;
import org.tip.puck.mas.WFDivorce2;
import org.tip.puck.mas.WFMarriage;
import org.tip.puck.mas.WFNormalAge;
import org.tip.puck.mas.WFNormalAgeDifference;
import org.tip.puck.mas.WFPregnancy;
import org.tip.puck.mas.WFUterineCousins;
import org.tip.puck.mas.WeightFactor;
import org.tip.puck.net.Gender;
import org.tip.puck.net.KinType;
import org.tip.puck.net.workers.MemoryCriteria;

public class MASConfig {
    private MAS mas = new MAS();
    private MemoryCriteria memoryCriteria = new MemoryCriteria();

    public void fromFile(String filePath) {
        try {
            StringBuffer fileData = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            reader.close();
            String str = fileData.toString();
            this.fromString(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fromString(String config) {
        this.parse(config);
    }

    private void parse(String config) {
        String[] lines;
        String[] stringArray = lines = config.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.parseLine(line.trim());
            ++n2;
        }
    }

    private void parseLine(String line) {
        if (line.equals("")) {
            return;
        }
        if (line.charAt(0) == '#') {
            return;
        }
        String[] parts = line.split(" ");
        String command = parts[0].toLowerCase();
        String arg = parts[1];
        int i = 2;
        while (i < parts.length) {
            arg = String.valueOf(arg) + " " + parts[i];
            ++i;
        }
        if (command.equals("factor")) {
            this.addFactor(arg);
        } else if (command.equals("years")) {
            this.mas.setYears(Integer.parseInt(arg));
        } else if (command.equals("initialpopulation")) {
            this.mas.setInitialPopulation(Integer.parseInt(arg));
        } else if (command.equals("fertilityrate")) {
            this.mas.setFertilityRate(Double.parseDouble(arg));
        } else if (command.equals("maxage")) {
            this.mas.setMaxAge(Integer.parseInt(arg));
        } else if (command.equals("samples")) {
            this.mas.setSamples(Integer.parseInt(arg));
        } else if (command.equals("marriagesmixratio")) {
            this.mas.setMarriagesMixRatio(Double.parseDouble(arg));
        } else if (command.equals("divorcemixratio")) {
            this.mas.setDivorceMixRatio(Double.parseDouble(arg));
        } else if (command.equals("memoryprob")) {
            this.addMemoryProb(arg);
        } else if (command.equals("nrinformants")) {
            this.memoryCriteria.setNrInformants(Integer.parseInt(arg));
        } else if (command.equals("distancefactor")) {
            this.memoryCriteria.setDistanceFactor(Double.parseDouble(arg));
        } else if (command.equals("maleacceptance")) {
            this.memoryCriteria.setMaleAcceptance(Double.parseDouble(arg));
        } else if (command.equals("femaleacceptance")) {
            this.memoryCriteria.setFemaleAcceptance(Double.parseDouble(arg));
        }
    }

    private Gender str2gender(String str) {
        Gender gender = Gender.UNKNOWN;
        if (str.equals("male")) {
            gender = Gender.MALE;
        } else if (str.equals("female")) {
            gender = Gender.FEMALE;
        }
        return gender;
    }

    private void addFactor(String arg) {
        String[] parts = arg.split("\\(");
        String factorName = parts[0].toLowerCase();
        String paramStr = parts[1].replace(')', ' ').trim();
        String[] params = paramStr.split(",");
        int i = 0;
        while (i < params.length) {
            params[i] = params[i].trim().toLowerCase();
            ++i;
        }
        WeightFactor factor = null;
        if (factorName.equals("normalage")) {
            Gender gender = this.str2gender(params[0]);
            double mean = Double.parseDouble(params[1]);
            double stdev = Double.parseDouble(params[2]);
            factor = new WFNormalAge(gender, mean, stdev);
        } else if (factorName.equals("normaldifferenceage")) {
            double mean = Double.parseDouble(params[0]);
            double stdev = Double.parseDouble(params[1]);
            factor = new WFNormalAgeDifference(mean, stdev);
        } else if (factorName.equals("agelimits")) {
            int minAge = Integer.parseInt(params[0]);
            int maxAge = Integer.parseInt(params[1]);
            factor = new WFAgeLimits(minAge, maxAge);
        } else if (factorName.equals("divorce")) {
            double prob = Double.parseDouble(params[0]);
            factor = new WFDivorce(prob);
        } else if (factorName.equals("divorce2")) {
            double weightDivorceMother = Double.parseDouble(params[0]);
            double weightDivorceFather = Double.parseDouble(params[1]);
            double weightDivorceBoth = Double.parseDouble(params[2]);
            factor = new WFDivorce2(weightDivorceMother, weightDivorceFather, weightDivorceBoth);
        } else if (factorName.equals("marriage")) {
            double weightCurrentMarriage = Double.parseDouble(params[0]);
            double weightPreviousMarriage = Double.parseDouble(params[1]);
            factor = new WFMarriage(weightCurrentMarriage, weightPreviousMarriage);
        } else if (factorName.equals("cousins")) {
            double cousins1 = Double.parseDouble(params[0]);
            double cousins2 = Double.parseDouble(params[1]);
            factor = new WFCousins(cousins1, cousins2);
        } else if (factorName.equals("agnaticcousins")) {
            double cousins1 = Double.parseDouble(params[0]);
            double cousins2 = Double.parseDouble(params[1]);
            factor = new WFAgnaticCousins(cousins1, cousins2);
        } else if (factorName.equals("uterinecousins")) {
            double cousins1 = Double.parseDouble(params[0]);
            double cousins2 = Double.parseDouble(params[1]);
            factor = new WFUterineCousins(cousins1, cousins2);
        } else if (factorName.equals("pregnancy")) {
            double weight = Double.parseDouble(params[0]);
            factor = new WFPregnancy(weight);
        } else if (factorName.equals("children")) {
            double c0 = Double.parseDouble(params[0]);
            double c1 = Double.parseDouble(params[1]);
            double c2 = Double.parseDouble(params[2]);
            double c3 = Double.parseDouble(params[3]);
            double c4 = Double.parseDouble(params[4]);
            factor = new WFChildren(c0, c1, c2, c3, c4);
        } else if (factorName.equals("childrenfather")) {
            double c0 = Double.parseDouble(params[0]);
            double c1 = Double.parseDouble(params[1]);
            double c2 = Double.parseDouble(params[2]);
            double c3 = Double.parseDouble(params[3]);
            double c4 = Double.parseDouble(params[4]);
            factor = new WFChildrenFather(c0, c1, c2, c3, c4);
        } else if (factorName.equals("childrenmother")) {
            double c0 = Double.parseDouble(params[0]);
            double c1 = Double.parseDouble(params[1]);
            double c2 = Double.parseDouble(params[2]);
            double c3 = Double.parseDouble(params[3]);
            double c4 = Double.parseDouble(params[4]);
            factor = new WFChildrenMother(c0, c1, c2, c3, c4);
        } else if (factorName.equals("childrencouple")) {
            double c0 = Double.parseDouble(params[0]);
            double c1 = Double.parseDouble(params[1]);
            double c2 = Double.parseDouble(params[2]);
            double c3 = Double.parseDouble(params[3]);
            double c4 = Double.parseDouble(params[4]);
            factor = new WFChildrenCouple(c0, c1, c2, c3, c4);
        }
        if (factor != null) {
            this.mas.addFactor(factor);
        }
    }

    private Gender strToGender(String str) {
        if (str.equals("male")) {
            return Gender.MALE;
        }
        if (str.equals("female")) {
            return Gender.FEMALE;
        }
        return Gender.UNKNOWN;
    }

    private KinType strToKinType(String str) {
        if (str.equals("parent")) {
            return KinType.PARENT;
        }
        if (str.equals("child")) {
            return KinType.CHILD;
        }
        return KinType.SPOUSE;
    }

    private void addMemoryProb(String arg) {
        String[] parts = arg.split(" ");
        String strEgo = parts[0].toLowerCase();
        String strAlter = parts[1].toLowerCase();
        String strKinType = parts[2].toLowerCase();
        String strInformant = parts[3].toLowerCase();
        String strProb = parts[4];
        Gender ego = this.strToGender(strEgo);
        Gender alter = this.strToGender(strAlter);
        KinType kinType = this.strToKinType(strKinType);
        Gender informant = this.strToGender(strInformant);
        double prob = Double.parseDouble(strProb);
        this.memoryCriteria.setMemoryProb(ego, alter, kinType, informant, prob);
    }

    public MAS getMas() {
        return this.mas;
    }

    public MemoryCriteria getMemoryCriteria() {
        return this.memoryCriteria;
    }
}

