/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.ods;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODSBufferedReader
extends BufferedReader {
    private static final Logger logger = LoggerFactory.getLogger(ODSBufferedReader.class);
    protected SpreadSheet workbook;
    protected int currentSheet;
    protected int currentRow;
    protected int savedSheet;
    protected int savedRow;

    public ODSBufferedReader(File file) throws Exception {
        super(new InputStreamReader(new FileInputStream(file)));
        try {
            this.workbook = SpreadSheet.createFromFile((File)file);
            this.currentSheet = 0;
            this.currentRow = 0;
        }
        catch (Exception exception) {
            throw new Exception("JOpenDocumnent error.", exception);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void mark(int size) {
        this.savedSheet = this.currentSheet;
        this.savedRow = this.currentRow;
    }

    @Override
    public boolean markSupported() {
        boolean result = true;
        return result;
    }

    @Override
    public String readLine() throws IOException {
        boolean ended = false;
        String result = null;
        while (!ended) {
            if (this.currentSheet < this.workbook.getSheetCount()) {
                Sheet sheet = this.workbook.getSheet(this.currentSheet);
                if (this.currentRow < sheet.getRowCount()) {
                    ended = true;
                    result = ODSBufferedReader.toTXTLine(sheet, this.currentRow);
                    ++this.currentRow;
                    continue;
                }
                ++this.currentSheet;
                this.currentRow = 0;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    @Override
    public void reset() {
        this.currentSheet = this.savedSheet;
        this.currentRow = this.savedRow;
    }

    public static String toTXTLine(Sheet sheet, int currentRow) {
        StringBuffer buffer = new StringBuffer(1024);
        int cellIndex = 0;
        while (cellIndex < sheet.getColumnCount()) {
            String cellContent;
            if (buffer.length() != 0) {
                buffer.append("\t");
            }
            if (StringUtils.isNotBlank((CharSequence)(cellContent = sheet.getValueAt(cellIndex, currentRow) == null ? "" : sheet.getValueAt(cellIndex, currentRow).toString()))) {
                cellContent = cellContent.replaceAll("[\r\n\t]+", "");
            }
            buffer.append(cellContent);
            ++cellIndex;
        }
        String result = buffer.toString();
        return result;
    }
}

