/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.ged;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.ged.GEDBlock;
import org.tip.puck.io.ged.GEDLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;

public class GEDFile {
    private static final Logger logger = LoggerFactory.getLogger(GEDFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 4096;
    public static final Pattern GEDLINE_PATTERN = Pattern.compile("^(\\d|[1-9]\\d+) (@(\\D*)(\\d*)(\\D*)@)? ?(\\w+) ?((@(\\D*)(\\d*)(\\D*)@)|(.*))$");

    public static void addSubmitterData(Net net, GEDBlock source) {
        boolean ended = false;
        int index = 1;
        while (!ended) {
            if (index < source.size()) {
                switch (((GEDLine)source.get(index)).getLevel()) {
                    case 1: {
                        net.attributes().put("SUBM_" + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                        break;
                    }
                    default: {
                        if (((GEDLine)source.get(index)).tag().equals("CONT")) {
                            String prefix = "SUBM_" + GEDFile.buildPrefix(source, index);
                            String label = prefix.substring(0, prefix.length() - 1);
                            Attribute attribute = (Attribute)net.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(index)).value());
                            break;
                        }
                        net.attributes().put("SUBM_" + GEDFile.buildPrefix(source, index) + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                    }
                }
                ++index;
                continue;
            }
            ended = true;
        }
    }

    public static void buildFamily(Net net, GEDBlock source) {
        Family currentFamily = null;
        boolean ended = false;
        int index = 0;
        while (!ended) {
            if (index < source.size()) {
                switch (((GEDLine)source.get(index)).getLevel()) {
                    case 0: {
                        currentFamily = (Family)net.families().getById(((GEDLine)source.get(0)).getRefId());
                        if (currentFamily != null) break;
                        currentFamily = new Family(((GEDLine)source.get(0)).getRefId());
                        net.families().add(currentFamily);
                        break;
                    }
                    case 1: {
                        Individual spouse;
                        if (((GEDLine)source.get(index)).tag().equals("HUSB")) {
                            spouse = (Individual)net.individuals().getById(((GEDLine)source.get(index)).valueId());
                            if (spouse == null) {
                                spouse = new Individual(((GEDLine)source.get(index)).valueId());
                                net.individuals().add(spouse);
                            }
                            currentFamily.setHusband(spouse);
                            currentFamily.setMarried(true);
                            spouse.getPersonalFamilies().add(currentFamily);
                            break;
                        }
                        if (((GEDLine)source.get(index)).tag().equals("WIFE")) {
                            spouse = (Individual)net.individuals().getById(((GEDLine)source.get(index)).valueId());
                            if (spouse == null) {
                                spouse = new Individual(((GEDLine)source.get(index)).valueId());
                                net.individuals().add(spouse);
                            }
                            currentFamily.setWife(spouse);
                            currentFamily.setMarried(true);
                            spouse.getPersonalFamilies().add(currentFamily);
                            break;
                        }
                        if (((GEDLine)source.get(index)).tag().equals("CHIL")) break;
                        if (((GEDLine)source.get(index)).hasValue()) {
                            currentFamily.attributes().put(((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                            break;
                        }
                        if (!((GEDLine)source.get(index)).hasTag()) break;
                        currentFamily.attributes().put(((GEDLine)source.get(index)).tag(), "");
                        break;
                    }
                    default: {
                        if (((GEDLine)source.get(index)).tag().equals("CONT")) {
                            String prefix = GEDFile.buildPrefix(source, index);
                            String label = prefix.substring(0, prefix.length() - 1);
                            Attribute attribute = (Attribute)currentFamily.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(index)).value());
                            break;
                        }
                        currentFamily.attributes().put(String.valueOf(GEDFile.buildPrefix(source, index)) + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                    }
                }
                ++index;
                continue;
            }
            ended = true;
        }
    }

    public static void buildHeader(Net net, GEDBlock source) {
        boolean ended = false;
        int index = 1;
        while (!ended) {
            if (index < source.size()) {
                switch (((GEDLine)source.get(index)).getLevel()) {
                    case 1: {
                        net.attributes().put(((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                        break;
                    }
                    default: {
                        if (((GEDLine)source.get(index)).tag().equals("CONT")) {
                            String prefix = GEDFile.buildPrefix(source, index);
                            String label = prefix.substring(0, prefix.length() - 1);
                            Attribute attribute = (Attribute)net.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(index)).value());
                            break;
                        }
                        net.attributes().put(String.valueOf(GEDFile.buildPrefix(source, index)) + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                    }
                }
                ++index;
                continue;
            }
            ended = true;
        }
    }

    public static void buildIndividual(Net net, GEDBlock source) throws PuckException {
        Individual individual = null;
        boolean ended = false;
        int index = 0;
        String tagLevel1 = null;
        while (!ended) {
            if (index < source.size()) {
                switch (((GEDLine)source.get(index)).getLevel()) {
                    case 0: {
                        individual = (Individual)net.individuals().getById(((GEDLine)source.get(0)).getRefId());
                        if (individual != null) break;
                        individual = new Individual(((GEDLine)source.get(0)).getRefId());
                        net.individuals().add(individual);
                        break;
                    }
                    case 1: {
                        tagLevel1 = null;
                        if (((GEDLine)source.get(index)).tag().equals("NAME")) {
                            individual.setName(((GEDLine)source.get(index)).value());
                            break;
                        }
                        if (((GEDLine)source.get(index)).tag().equals("SEX")) {
                            if (StringUtils.isBlank((CharSequence)((GEDLine)source.get(index)).value())) {
                                individual.setGender(Gender.UNKNOWN);
                                break;
                            }
                            individual.setGender(Gender.valueOf(((GEDLine)source.get(index)).value().charAt(0)));
                            break;
                        }
                        if (((GEDLine)source.get(index)).tag().equals("FAMS")) break;
                        if (((GEDLine)source.get(index)).tag().equals("FAMC")) {
                            GEDLine nextLine;
                            boolean computeThisLink = index < source.size() - 1 ? (nextLine = (GEDLine)source.get(index + 1)).getLevel() != 2 || !nextLine.tag().equals("PEDI") || !nextLine.hasValue() || nextLine.value().equals("birth") : true;
                            if (!computeThisLink) break;
                            Family currentFamily = (Family)net.families().getById(((GEDLine)source.get(index)).valueId());
                            if (currentFamily == null) {
                                currentFamily = new Family(((GEDLine)source.get(index)).valueId());
                                net.families().add(currentFamily);
                            }
                            if (individual.getOriginFamily() != null && individual.getOriginFamily().getId() != currentFamily.getId()) {
                                logger.warn("Individual orginal family defined twice " + individual.getId());
                                String adoptionName = String.valueOf(individual.getName()) + " " + individual.getId();
                                Relation adoption = net.createRelation(adoptionName, net.relationModels().getByName("Adoption"));
                                net.createRelationActor(adoption, individual.getId(), "child");
                                adoption.attributes().put("adoptive_family", String.valueOf(((GEDLine)source.get(index)).valueId()));
                                adoption.attributes().put("pedigree", "duplicate");
                                break;
                            }
                            if (individual.getOriginFamily() != null) break;
                            currentFamily.getChildren().add(individual);
                            individual.setOriginFamily(currentFamily);
                            break;
                        }
                        if (((GEDLine)source.get(index)).tag().equals("ADOP")) {
                            tagLevel1 = "ADOP";
                            break;
                        }
                        if (((GEDLine)source.get(index)).hasValue()) {
                            individual.attributes().put(((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                            break;
                        }
                        if (!((GEDLine)source.get(index)).hasTag()) break;
                        individual.attributes().put(((GEDLine)source.get(index)).tag(), "");
                        break;
                    }
                    case 2: {
                        Attribute attribute;
                        String label;
                        if (StringUtils.equals(tagLevel1, (CharSequence)"ADOP") && ((GEDLine)source.get(index)).tag().equals("FAMC")) {
                            String adoptionName = String.valueOf(individual.getName()) + " " + individual.getId();
                            Relation adoption = net.createRelation(adoptionName, net.relationModels().getByName("Adoption"));
                            net.createRelationActor(adoption, individual.getId(), "child");
                            adoption.attributes().put("adoptive_family", String.valueOf(((GEDLine)source.get(index)).valueId()));
                            adoption.attributes().put("pedigree", "Adoption");
                            break;
                        }
                        if (((GEDLine)source.get(index)).tag().equals("CONT")) {
                            String prefix = GEDFile.buildPrefix(source, index);
                            label = prefix.substring(0, prefix.length() - 1);
                            attribute = (Attribute)individual.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(index)).value());
                            break;
                        }
                        individual.attributes().put(String.valueOf(GEDFile.buildPrefix(source, index)) + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                        break;
                    }
                    default: {
                        Attribute attribute;
                        String label;
                        if (((GEDLine)source.get(index)).tag().equals("CONT")) {
                            String prefix = GEDFile.buildPrefix(source, index);
                            label = prefix.substring(0, prefix.length() - 1);
                            attribute = (Attribute)individual.attributes().get(label);
                            attribute.setValue(String.valueOf(attribute.getValue()) + ((GEDLine)source.get(index)).value());
                            break;
                        }
                        individual.attributes().put(String.valueOf(GEDFile.buildPrefix(source, index)) + ((GEDLine)source.get(index)).tag(), ((GEDLine)source.get(index)).value());
                    }
                }
                ++index;
                continue;
            }
            ended = true;
        }
    }

    public static String buildPrefix(GEDBlock source, int currentIndex) {
        boolean ended = false;
        String result = "";
        int lastGoodIndex = currentIndex;
        int index = currentIndex - 1;
        while (!ended) {
            if (((GEDLine)source.get(index)).getLevel() > 0) {
                if (((GEDLine)source.get(index)).getLevel() < ((GEDLine)source.get(lastGoodIndex)).getLevel() && !((GEDLine)source.get(index)).tag().equals(source.get(lastGoodIndex))) {
                    result = String.valueOf(((GEDLine)source.get(index)).tag()) + "_" + result;
                    lastGoodIndex = index;
                }
                --index;
                continue;
            }
            ended = true;
        }
        return result;
    }

    public static Net load(File file) throws PuckException {
        Net result = GEDFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = GEDFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        RelationModel adoptionModel = result.createRelationModel("Adoption");
        result.createRelationRole(adoptionModel, "child");
        result.createRelationRole(adoptionModel, "adoptive parent");
        result.createRelationRole(adoptionModel, "birth parent");
        logger.debug("Read.");
        boolean ended = false;
        while (!ended) {
            GEDBlock source = GEDFile.readGEDBlock(in);
            if (source == null) {
                throw PuckExceptions.BAD_FILE_FORMAT.create("File ends too early.", new Object[0]);
            }
            if (((GEDLine)source.get(0)).tag().equals("INDI")) {
                GEDFile.buildIndividual(result, source);
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("FAM")) {
                GEDFile.buildFamily(result, source);
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("HEAD")) {
                GEDFile.buildHeader(result, source);
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("TRLR")) {
                ended = true;
                continue;
            }
            if (((GEDLine)source.get(0)).tag().equals("CSTA") || ((GEDLine)source.get(0)).tag().equals("SOURCE") || ((GEDLine)source.get(0)).tag().equals("REPO") || ((GEDLine)source.get(0)).tag().equals("NOTE") || ((GEDLine)source.get(0)).tag().equals("OBJE")) continue;
            if (((GEDLine)source.get(0)).tag().equals("SUBM")) {
                GEDFile.addSubmitterData(result, source);
                continue;
            }
            logger.warn("IGNORING zero level tag [" + ((GEDLine)source.get(0)).tag() + "]");
        }
        if (result.relations().getByModel(adoptionModel).isEmpty()) {
            result.remove(adoptionModel);
        } else {
            Relations adoptions = result.relations().getByModel(adoptionModel);
            for (Relation adoption : adoptions) {
                Individual child = ((Actor)adoption.actors().getByRole("child").get(0)).getIndividual();
                for (Individual parent : child.getParents()) {
                    result.createRelationActor(adoption, parent.getId(), "birth parent");
                }
                String birthFamilyId = child.getOriginFamily() == null ? "" : String.valueOf(child.getOriginFamily().getId());
                adoption.attributes().put("birth_family", birthFamilyId);
                String adoptiveFamilyIdString = adoption.attributes().getValue("adoptive_family");
                if (!NumberUtils.isDigits((String)adoptiveFamilyIdString)) continue;
                int adoptiveFamilyId = Integer.parseInt(adoptiveFamilyIdString);
                Family adoptiveFamily = (Family)result.families().getById(adoptiveFamilyId);
                for (Individual parent : adoptiveFamily.getParents()) {
                    result.createRelationActor(adoption, parent.getId(), "adoptive parent");
                }
            }
        }
        logger.debug("Done.");
        return result;
    }

    public static GEDBlock readGEDBlock(BufferedReader in) throws PuckException {
        GEDBlock result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                in.mark(4096);
                GEDLine source = GEDFile.readGEDLine(in);
                if (source == null) {
                    ended = true;
                    continue;
                }
                if (result == null) {
                    result = new GEDBlock();
                    result.add(source);
                    continue;
                }
                if (source.getLevel() == 0) {
                    ended = true;
                    in.reset();
                    continue;
                }
                result.add(source);
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading GEDCOM line.", new Object[0]);
        }
        return result;
    }

    public static GEDLine readGEDLine(BufferedReader in) throws PuckException {
        GEDLine result;
        block10: {
            try {
                String line = in.readLine();
                if (line != null) {
                    line = line.trim();
                }
                if (line == null) {
                    result = null;
                    break block10;
                }
                if (line.length() == 0) {
                    result = null;
                    break block10;
                }
                Matcher matcher = GEDLINE_PATTERN.matcher(line);
                if (matcher.find() && matcher.groupCount() == 12) {
                    String valuePostfix;
                    Integer valueId;
                    String valuePrefix;
                    String refPostfix;
                    Integer refId;
                    String refPrefix;
                    int level = Integer.parseInt(matcher.group(1));
                    String ref = matcher.group(2);
                    if (ref == null) {
                        refPrefix = null;
                        refId = null;
                        refPostfix = null;
                    } else {
                        refPrefix = matcher.group(3);
                        refId = StringUtils.isBlank((CharSequence)matcher.group(4)) ? null : Integer.valueOf(matcher.group(4));
                        refPostfix = matcher.group(5);
                    }
                    String tag = matcher.group(6);
                    String value = StringUtils.isBlank((CharSequence)matcher.group(7)) ? null : matcher.group(7);
                    if (value != null && matcher.group(12) == null) {
                        valuePrefix = matcher.group(9);
                        valueId = StringUtils.isBlank((CharSequence)matcher.group(10)) ? null : Integer.valueOf(matcher.group(10));
                        valuePostfix = matcher.group(11);
                    } else {
                        valuePrefix = null;
                        valueId = null;
                        valuePostfix = null;
                    }
                    result = matcher.group(12) == null ? new GEDLine(level, refPrefix, refId, refPostfix, tag, valuePrefix, valueId, valuePostfix) : new GEDLine(level, refPrefix, refId, refPostfix, tag, value);
                    break block10;
                }
                throw PuckExceptions.BAD_FILE_FORMAT.create("Bad line format: [" + line + "].", new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
            }
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                GEDFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void write(PrintWriter out, GEDLine source) {
        StringBuffer line = new StringBuffer(1024);
        line.append(source.getLevel()).append(" ");
        if (source.getRef() != null) {
            line.append(source.getRef()).append(" ");
        }
        line.append(source.tag());
        if (source.hasValue()) {
            line.append(" ").append(source.value());
        }
        out.println(line.toString());
    }

    public static void write(PrintWriter out, Net net) {
        GEDFile.write(out, new GEDLine(0, null, null, null, "HEAD", null));
        for (Attribute attribute : net.attributes().toList()) {
            GEDFile.write(out, new GEDLine(1, null, null, null, attribute.getLabel(), attribute.getValue()));
        }
        for (Individual individual : net.individuals().toSortedList()) {
            GEDFile.write(out, new GEDLine(0, "I", (Integer)individual.getId(), "", "INDI", null));
            GEDFile.write(out, new GEDLine(1, null, null, null, "NAME", individual.getName()));
            GEDFile.write(out, new GEDLine(1, null, null, null, "SEX", individual.getGender().toChar()));
            if (individual.getOriginFamily() != null) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "FAMC", "F", individual.getOriginFamily().getId(), ""));
            }
            for (Family family : individual.getPersonalFamilies()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "FAMS", "F", family.getId(), ""));
            }
            for (Attribute attribute : individual.attributes().toList()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, attribute.getLabel(), attribute.getValue()));
            }
        }
        for (Family family : net.families().toSortedList()) {
            GEDFile.write(out, new GEDLine(0, "F", (Integer)family.getId(), "", "FAM", null));
            if (family.getHusband() != null) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "HUSB", "I", family.getHusband().getId(), ""));
            }
            if (family.getWife() != null) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "WIFE", "I", family.getWife().getId(), ""));
            }
            for (Individual child : family.getChildren()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, "CHIL", "I", child.getId(), ""));
            }
            for (Attribute attribute : family.attributes().toList()) {
                GEDFile.write(out, new GEDLine(1, null, null, null, attribute.getLabel(), attribute.getValue()));
            }
        }
        GEDFile.write(out, new GEDLine(0, null, null, null, "TRLR", null));
    }
}

