/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.random;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.Nodes;
import org.tip.puck.graphs.random.DistributionType;
import org.tip.puck.graphs.random.RandomCriteria;
import org.tip.puck.util.RandomUtils;
import org.tip.puck.util.ToolBox;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvar.ParetoGen;
import umontreal.iro.lecuyer.randvar.PowerGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.WELL607;

public class RandomGraphMaker<E> {
    int arcWeightSum;
    int maxArcWeightSum;
    int nodeCount;
    double[] inertia;
    double outPreference;
    TreeMap<Double, Node<E>> nodeChoiceMap;
    Map<Node<E>, Double> egoWeightMap;
    Map<Node<E>, Double> alterWeightMap;
    Map<Node<E>, Set<Node<E>>> exhaustedInNeighbors;
    Map<Node<E>, Set<Node<E>>> exhaustedOutNeighbors;
    Set<Node<E>> exhaustedInNodes;
    Set<Node<E>> exhaustedOutNodes;
    Map<Node<E>, Set<Link<E>>> exhaustedInLinks;
    Map<Node<E>, Set<Link<E>>> exhaustedOutLinks;
    List<double[]> probas;
    DistributionType dist;
    Random randGen;
    StringList protocol;

    public RandomGraphMaker() {
    }

    public RandomGraphMaker(RandomCriteria criteria) {
        this.maxArcWeightSum = criteria.getArcWeightSum();
        this.nodeCount = criteria.getNodeCount();
        this.outPreference = criteria.getOutPreference();
        this.dist = criteria.getDistributionType();
        this.protocol = new StringList();
        this.inertia = criteria.getInertia();
        this.randGen = new Random();
    }

    public Graph<E> createRandomGraph(int nodeCount, int arcCount) {
        Graph result = new Graph(nodeCount);
        int k = 0;
        while (k < arcCount) {
            result.incArcWeight((int)(Math.random() * (double)nodeCount + 1.0), (int)(Math.random() * (double)nodeCount) + 1);
            ++k;
        }
        return result;
    }

    private boolean isExhausted(Node<E> node) {
        boolean result = this.exhaustedInNodes == null || this.exhaustedOutNodes == null ? false : this.exhaustedInNodes.contains(node) && this.exhaustedOutNodes.contains(node);
        return result;
    }

    private void updateWeightMap(Graph<E> graph, Node<E> ego) {
        this.alterWeightMap = new HashMap<Node<E>, Double>();
        for (Node<E> node : graph.getNodes()) {
            if (this.isExhausted(node)) {
                this.alterWeightMap.put(node, 0.0);
                continue;
            }
            if (this.egoWeightMap == null) {
                this.alterWeightMap.put(node, 1.0);
                continue;
            }
            this.alterWeightMap.put(node, this.egoWeightMap.get(node));
        }
        Map<Integer, Nodes<E>> neighbors = ego.getNeighbors(graph.getNodes(), this.inertia.length);
        int distance = 0;
        while (distance < this.inertia.length) {
            for (Node<E> node : neighbors.get(distance)) {
                if (node == ego && distance != 0) continue;
                this.alterWeightMap.put(node, this.alterWeightMap.get(node) * this.inertia[distance]);
            }
            ++distance;
        }
        double[] proba = new double[this.inertia.length];
        double maxValue = 0.0;
        Iterator<Object> iterator = this.alterWeightMap.values().iterator();
        while (iterator.hasNext()) {
            double value = iterator.next();
            maxValue += value;
        }
        int distance2 = 0;
        while (distance2 < this.inertia.length) {
            for (Node node : neighbors.get(distance2)) {
                int n = distance2;
                proba[n] = proba[n] + this.alterWeightMap.get(node);
            }
            proba[distance2] = proba[distance2] / maxValue;
            ++distance2;
        }
        this.probas.add(proba);
    }

    public double[][] getProbaEvolution() {
        return ToolBox.toArray(this.probas);
    }

    public Graph<E> createRandomGraphByAgentSimulation() {
        Graph<E> result = new Graph<E>(this.nodeCount);
        this.arcWeightSum = 0;
        this.probas = new ArrayList<double[]>();
        int factor = 1;
        if (this.dist != DistributionType.FREE) {
            Map<Integer, Double> weightDistribution = RandomGraphMaker.getRandomDistribution(this.dist, this.nodeCount, this.maxArcWeightSum, factor);
            this.egoWeightMap = new HashMap<Node<E>, Double>();
            for (Node node : result.getNodes()) {
                this.egoWeightMap.put(node, weightDistribution.get(node.getId() - 1));
            }
        }
        int k = 0;
        while (k < this.maxArcWeightSum) {
            Node ego = this.egoWeightMap == null ? RandomUtils.draw(result.getNodes().toList()) : RandomUtils.draw(this.egoWeightMap, this.randGen);
            this.updateWeightMap(result, ego);
            Node<E> alter = RandomUtils.draw(this.alterWeightMap, this.randGen);
            if (alter != null) {
                if (RandomUtils.event(this.outPreference)) {
                    result.incArcWeight(ego, alter);
                } else {
                    result.incArcWeight(alter, ego);
                }
                ++this.arcWeightSum;
            }
            ++k;
        }
        return result;
    }

    private void setExhaustedInNeighbors(Node<E> ego, Node<E> neighbor) {
        if (this.exhaustedInNeighbors.get(ego) == null) {
            this.exhaustedInNeighbors.put(ego, new HashSet());
        }
        this.exhaustedInNeighbors.get(ego).add(neighbor);
    }

    private List<Node<E>> getUnexhaustedDirectInNeighbors(Node<E> ego) {
        ArrayList<Node<Node<E>>> result = new ArrayList<Node<Node<E>>>();
        Set<Node<E>> exhausted = this.exhaustedInNeighbors.get(ego);
        for (Node<E> neighbor : ego.getDirectInNeighbors()) {
            if (exhausted.contains(neighbor)) continue;
            result.add(neighbor);
        }
        return result;
    }

    private void setExhaustedOutNeighbors(Node<E> ego, Node<E> neighbor) {
        if (this.exhaustedOutNeighbors.get(ego) == null) {
            this.exhaustedOutNeighbors.put(ego, new HashSet());
        }
        this.exhaustedOutNeighbors.get(ego).add(neighbor);
    }

    private List<Node<E>> getUnexhaustedDirectOutNeighbors(Node<E> ego) {
        ArrayList<Node<Node<E>>> result = new ArrayList<Node<Node<E>>>();
        Set<Node<E>> exhausted = this.exhaustedOutNeighbors.get(ego);
        for (Node<E> neighbor : ego.getDirectOutNeighbors()) {
            if (exhausted.contains(neighbor)) continue;
            result.add(neighbor);
        }
        return result;
    }

    private Map<Node<E>, Double> getUnexhaustedWeightedDirectOutNeighbors(Node<E> ego, Graph<E> source, Graph<E> target) {
        HashMap<Node<E>, Double> result = new HashMap<Node<E>, Double>();
        for (Node<E> neighbor : ego.getDirectOutNeighbors()) {
            double surplus = source.getArcWeight(ego.getId(), neighbor.getId()) - target.getArcWeight(ego.getId(), neighbor.getId());
            if (!(surplus > 0.0)) continue;
            result.put(neighbor, surplus);
        }
        return result;
    }

    private Map<Node<E>, Double> getUnexhaustedWeightedDirectInNeighbors(Node<E> ego, Graph<E> source, Graph<E> target) {
        HashMap<Node<E>, Double> result = new HashMap<Node<E>, Double>();
        for (Node<E> neighbor : ego.getDirectInNeighbors()) {
            double surplus = source.getArcWeight(neighbor.getId(), ego.getId()) - target.getArcWeight(neighbor.getId(), ego.getId());
            if (!(surplus > 0.0)) continue;
            result.put(neighbor, surplus);
        }
        return result;
    }

    public Graph<E> createRandomGraphByObserverSimulation(Graph<E> source) {
        Graph<E> result = new Graph<E>(source.nodeCount());
        this.exhaustedOutNodes = new HashSet<Node<E>>();
        this.exhaustedInNodes = new HashSet<Node<E>>();
        this.exhaustedInNeighbors = new HashMap<Node<E>, Set<Node<E>>>();
        this.exhaustedOutNeighbors = new HashMap<Node<E>, Set<Node<E>>>();
        this.exhaustedInLinks = new HashMap<Node<E>, Set<Link<E>>>();
        this.exhaustedOutLinks = new HashMap<Node<E>, Set<Link<E>>>();
        for (Node<E> nodeModel : source.getNodes()) {
            result.addNode(nodeModel.getId(), nodeModel.getReferent());
            this.exhaustedInNeighbors.put(nodeModel, new HashSet());
            this.exhaustedOutNeighbors.put(nodeModel, new HashSet());
            this.exhaustedInLinks.put(nodeModel, new HashSet());
            this.exhaustedOutLinks.put(nodeModel, new HashSet());
        }
        this.arcWeightSum = 0;
        this.probas = new ArrayList<double[]>();
        Node<E> egoModel = RandomUtils.draw(source.getNodes().toList());
        int egoId = egoModel.getId();
        Node ego = result.getNode(egoId);
        StringList protocol = new StringList();
        while (this.arcWeightSum < this.maxArcWeightSum) {
            int alterId;
            Node<E> alterModel;
            if (RandomUtils.event(this.outPreference)) {
                alterModel = RandomUtils.draw(this.getUnexhaustedWeightedDirectOutNeighbors(egoModel, source, result), this.randGen);
                if (alterModel != null) {
                    alterId = alterModel.getId();
                    if (result.getArcWeight(egoId, alterId) < source.getArcWeight(egoId, alterId)) {
                        result.incArcWeight(egoId, alterId);
                        ++this.arcWeightSum;
                        protocol.appendln(String.valueOf(egoId) + " " + alterId);
                    } else {
                        this.setExhaustedOutNeighbors(egoModel, alterModel);
                        protocol.appendln("exhausted link " + egoId + " " + alterId);
                    }
                } else {
                    this.exhaustedOutNodes.add(ego);
                    protocol.appendln("exhausted out: " + ego.getId());
                }
            } else {
                alterModel = RandomUtils.draw(this.getUnexhaustedWeightedDirectInNeighbors(egoModel, source, result), this.randGen);
                if (alterModel != null) {
                    alterId = alterModel.getId();
                    if (result.getArcWeight(alterId, egoId) < source.getArcWeight(alterId, egoId)) {
                        result.incArcWeight(alterId, egoId);
                        ++this.arcWeightSum;
                        protocol.appendln(String.valueOf(alterId) + " " + egoId);
                    } else {
                        this.setExhaustedInNeighbors(egoModel, alterModel);
                        protocol.appendln("exhausted link " + egoId + " " + alterId);
                    }
                } else {
                    this.exhaustedInNodes.add(ego);
                    protocol.appendln("exhausted in: " + ego.getId());
                }
            }
            this.updateWeightMap(result, ego);
            ego = RandomUtils.draw(this.alterWeightMap, this.randGen);
            egoId = ego.getId();
            egoModel = source.getNode(egoId);
        }
        return result;
    }

    public Graph<E> createRandomGraphByPermutation(Graph<E> source) {
        Graph<E> result = new Graph<E>(source.nodeCount());
        result.addNodes(source.getNodes());
        int n = source.nodeCount();
        ArrayList<Integer> rowIndex = new ArrayList<Integer>();
        ArrayList<Integer> columnIndex = new ArrayList<Integer>();
        double[] outCountdown = new double[n];
        double[] inCountdown = new double[n];
        int i = 0;
        while (i < n) {
            Node<E> node = source.getNode(i + 1);
            double outForce = node.getOutForce();
            double inForce = node.getInForce();
            if (outForce > 0.0) {
                rowIndex.add(i);
                outCountdown[i] = outForce;
            }
            if (inForce > 0.0) {
                columnIndex.add(i);
                inCountdown[i] = inForce;
            }
            ++i;
        }
        while (rowIndex.size() > 0 && columnIndex.size() > 0) {
            int a = (int)(Math.random() * (double)rowIndex.size());
            int b = (int)(Math.random() * (double)columnIndex.size());
            int i2 = (Integer)rowIndex.get(a);
            int j = (Integer)columnIndex.get(b);
            result.incArcWeight(i2 + 1, j + 1);
            int n2 = i2;
            outCountdown[n2] = outCountdown[n2] - 1.0;
            int n3 = j;
            inCountdown[n3] = inCountdown[n3] - 1.0;
            if (outCountdown[i2] == 0.0) {
                rowIndex.remove(a);
            }
            if (inCountdown[j] != 0.0) continue;
            columnIndex.remove(b);
        }
        return result;
    }

    public Graph<E> createRandomGraphByReshuffling(int nodeCount, int arcCount, Map<int[], Double> map) {
        Graph result = new Graph(nodeCount);
        int k = 0;
        while (k < arcCount) {
            int[] i = RandomUtils.draw(map, this.randGen);
            result.incArcWeight(i[0], i[1]);
            ++k;
        }
        return result;
    }

    private void addProbas(List<double[]> probasAgg) {
        int i = 0;
        while (i < this.maxArcWeightSum) {
            double[] probaAgg = probasAgg.get(i);
            double[] proba = this.probas.get(i);
            int j = 0;
            while (j < this.inertia.length) {
                int n = j;
                probaAgg[n] = probaAgg[n] + proba[j];
                ++j;
            }
            ++i;
        }
    }

    public List<Graph<E>> createRandomGraphsByAgentSimulation(int runs) {
        ArrayList<double[]> probasAgg = new ArrayList<double[]>();
        int i = 0;
        while (i < this.maxArcWeightSum) {
            probasAgg.add(new double[this.inertia.length]);
            ++i;
        }
        ArrayList<Graph<Graph<E>>> result = new ArrayList<Graph<Graph<E>>>();
        int run = 0;
        while (run < runs) {
            result.add(this.createRandomGraphByAgentSimulation());
            this.addProbas(probasAgg);
            ++run;
        }
        this.probas = probasAgg;
        i = 0;
        while (i < this.maxArcWeightSum) {
            double[] proba = this.probas.get(i);
            int j = 0;
            while (j < this.inertia.length) {
                proba[j] = proba[j] / (double)runs;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public List<Graph<E>> createRandomGraphsByObserverSimulation(Graph<E> source, int runs) {
        ArrayList<double[]> probasAgg = new ArrayList<double[]>();
        int i = 0;
        while (i < this.maxArcWeightSum) {
            probasAgg.add(new double[this.inertia.length]);
            ++i;
        }
        ArrayList<Graph<Graph<E>>> result = new ArrayList<Graph<Graph<E>>>();
        int run = 0;
        while (run < runs) {
            result.add(this.createRandomGraphByObserverSimulation(source));
            this.addProbas(probasAgg);
            ++run;
        }
        this.probas = probasAgg;
        i = 0;
        while (i < this.maxArcWeightSum) {
            double[] proba = this.probas.get(i);
            int j = 0;
            while (j < this.inertia.length) {
                proba[j] = proba[j] / (double)runs;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public List<Graph<E>> createRandomGraphsByPermutation(Graph<E> source, int runs) {
        ArrayList<Graph<Graph<E>>> result = new ArrayList<Graph<Graph<E>>>();
        int run = 0;
        while (run < runs) {
            result.add(this.createRandomGraphByPermutation(source));
            ++run;
        }
        return result;
    }

    public List<Graph<E>> createRandomGraphsByRandomDistribution(DistributionType dist, int nodeCount, int arcCount, int factor, int runs) {
        ArrayList<Graph<Graph<E>>> result = new ArrayList<Graph<Graph<E>>>();
        if (dist == DistributionType.FREE) {
            int run = 0;
            while (run < runs) {
                result.add(this.createRandomGraph(nodeCount, arcCount));
                ++run;
            }
        } else {
            Map<Integer, Double> outForces = RandomGraphMaker.getRandomDistribution(dist, nodeCount, arcCount, factor);
            Map<Integer, Double> inForces = RandomGraphMaker.getRandomDistribution(dist, nodeCount, arcCount, factor);
            Map<int[], Double> map = RandomGraphMaker.getNodePairChoiceMap(outForces, inForces);
            int run = 0;
            while (run < runs) {
                result.add(this.createRandomGraphByReshuffling(nodeCount, arcCount, map));
                ++run;
            }
        }
        return result;
    }

    public List<Graph<E>> createRandomGraphsByReshuffling(Graph<E> source, int runs) {
        ArrayList<Graph<Graph<E>>> result = new ArrayList<Graph<Graph<E>>>();
        Map<int[], Double> map = RandomGraphMaker.getNodePairChoiceMap(source.getOutForces(), source.getInForces());
        int run = 0;
        while (run < runs) {
            result.add(this.createRandomGraphByReshuffling(source.nodeCount(), (int)source.getArcWeightSum(), map));
            ++run;
        }
        return result;
    }

    public int getArcCount() {
        return this.arcWeightSum;
    }

    private static <E> Nodes<E> getNeighborsBeyond(Map<Integer, Nodes<E>> neighbors, int lowerLimit) {
        Nodes<E> result = new Nodes<E>();
        for (int distance : neighbors.keySet()) {
            if (distance <= lowerLimit) continue;
            result.addAll(neighbors.get(distance));
        }
        return result;
    }

    private static <E> Map<int[], Double> getNodePairChoiceMap(Map<Integer, Double> outForces, Map<Integer, Double> inForces) {
        HashMap<int[], Double> result = new HashMap<int[], Double>();
        for (int outId : outForces.keySet()) {
            for (int inId : inForces.keySet()) {
                result.put(new int[]{outId, inId}, outForces.get(outId) * inForces.get(inId));
            }
        }
        return result;
    }

    private static <E> Map<Integer, Double> getRandomDistribution(DistributionType dist, int nodeCount, int arcCount, int factor) {
        TreeMap<Integer, Double> result = new TreeMap<Integer, Double>();
        if (dist == DistributionType.FREE) {
            result = null;
        } else if (dist == DistributionType.BERNOULLI) {
            int k = 0;
            while (k < arcCount) {
                int i = (int)((double)nodeCount * Math.random());
                Double value = (Double)result.get(i);
                if (value == null) {
                    value = 0.0;
                }
                result.put(i, value + 1.0);
                ++k;
            }
        } else if (dist == DistributionType.NORMAL) {
            double mu = new Double(arcCount) / new Double(nodeCount);
            int i = 0;
            while (i < nodeCount) {
                result.put(i, RandomGraphMaker.getNormalGenerator(mu, 1.0).nextDouble());
                ++i;
            }
        } else {
            int i = 0;
            while (i < nodeCount) {
                result.put(i, RandomGraphMaker.getPowerGenerator(dist, nodeCount, arcCount, factor).nextDouble());
                ++i;
            }
        }
        return result;
    }

    private static RandomVariateGen getPowerGenerator(DistributionType dist, int nodeCount, int arcCount, int factor) {
        PowerGen rvg = null;
        WELL607 s = new WELL607();
        switch (dist) {
            case PARETO: {
                double b = arcCount;
                rvg = new ParetoGen((RandomStream)s, (double)factor);
            }
            case POWER: {
                rvg = new PowerGen((RandomStream)s, (double)factor);
            }
        }
        return rvg;
    }

    private static RandomVariateGen getNormalGenerator(double mu, double sigma) {
        NormalGen rvg = null;
        WELL607 s = new WELL607();
        rvg = new NormalGen((RandomStream)s, mu, sigma);
        return rvg;
    }
}

