/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.generators;

import java.io.File;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.generators.PGraph;
import org.tip.puck.io.txt1.TXT1File;
import org.tip.puck.net.Net;
import org.tip.puck.segmentation.Segmentation;

public class Shuffler {
    public static Net shuffle(Net net, int k, int maxGenDist, double minShufflePer, int minStableIter) {
        PGraph pgraph = new PGraph(net);
        Shuffler.shuffle(pgraph, k, maxGenDist, minShufflePer, minStableIter);
        Net result = pgraph.toNet();
        return result;
    }

    public static CircuitFinder findCircuits(Net net, int k, int maxGenDist, double minShufflePer, int minStableIter, int runs, CensusCriteria criteria) throws PuckException {
        CircuitFinder result = new CircuitFinder(new Segmentation(net), criteria);
        result.initializeCounts();
        int run = 0;
        while (run < runs) {
            Net shuffledNet = Shuffler.shuffle(net, k, maxGenDist, minShufflePer, minStableIter);
            CircuitFinder finder = new CircuitFinder(new Segmentation(shuffledNet), criteria);
            finder.findCircuits();
            result.incrementCounts(finder);
            ++run;
        }
        result.normalizeCounts(runs);
        return result;
    }

    public static void shuffle(PGraph pgraph, int k, int maxGenDist, double minShufflePer, int minStableIter) {
        PGraph origPGraph = new PGraph(pgraph);
        pgraph.storeOriginalDescendants();
        int iteration = 0;
        int switches = 0;
        double maxDist = 0.0;
        int stableIterations = 0;
        boolean stop = false;
        while (!stop) {
            double shuffled = pgraph.percentageShuffledLinks();
            double dist = pgraph.distance(origPGraph);
            System.out.println("#iter " + iteration + "\t\tswaps: " + switches + "\t\tstable iter: " + stableIterations);
            System.out.println("  shuffled: " + shuffled + "%; dist: " + dist + "; max dist: " + maxDist);
            if (dist > maxDist) {
                maxDist = dist;
                stableIterations = 0;
            } else {
                ++stableIterations;
            }
            if (pgraph.switchLinks(k, maxGenDist)) {
                ++switches;
            }
            ++iteration;
            if (!(shuffled >= minShufflePer) || stableIterations < minStableIter) continue;
            stop = true;
        }
    }

    public static void main(String[] args) {
        int k = 2;
        int maxGenDist = 2;
        double minShufflePer = 100.0;
        int minStableIter = 1000;
        try {
            Net net = TXT1File.load(new File("Chimane6.txt"));
            PGraph pgraph = new PGraph(net);
            System.out.println(pgraph);
            System.out.println("\n");
            Shuffler.shuffle(pgraph, 2, 2, 100.0, 1000);
            Net newNet = pgraph.toNet();
            System.out.println(newNet);
            System.out.println("\n");
            System.out.println(pgraph);
            System.out.println("done.");
        }
        catch (PuckException e) {
            e.printStackTrace();
        }
    }
}

