/*
 * Decompiled with CFR 0.152.
 */
package oldcore.calc.partitions;

import java.util.Map;
import java.util.TreeMap;
import oldcore.calc.partitions.RandomMatrix;
import oldcore.util.Mat;

public class Matrix {
    int[][] matrix;
    int[] rows;
    int[] columns;
    int sum;
    protected TreeMap<Integer, Integer> index;
    TreeMap<Integer, int[]> map;
    double[] relinkings;
    boolean isSymmetric;
    private int numberOfCircuits;
    private int numberOfParallelCircuits;
    private int numberOfCrossCircuits;
    private int numberOfCyclicTriangles;
    private int numberOfTransitiveTriangles;
    private double normalizedNumberOfCircuits;
    private double normalizedNumberOfParallelCircuits;
    private double normalizedNumberOfCrossCircuits;
    private double normalizedNumberOfCyclicTriangles;
    private double normalizedNumberOftransitiveTriangles;
    private double concentrationIndex;
    private double symmetryIndex;
    private double endogamicConcentrationIndex;
    private double endogamyIndex;
    private double strengthConcentrationIndex;
    private double endogamicStrengthConcentrationIndex;
    private double strengthSymmetryIndex;
    private double expectedNumberOfCircuits;
    private double expectedNumberOfParallelCircuits;
    private double expectedNumberOfCrossCircuits;
    private double expectedNormalizedNumberOfCircuits;
    private double expectedNormalizedNumberOfParallelCircuits;
    private double expectedNormalizedNumberOfCrossCircuits;
    private double expectedConcentrationIndex;
    private double expectedEndogamicConcentrationIndex;
    private double expectedSymmetryIndex;
    private double expectedEndogamyIndex;

    public static double[] getRelinkingStatistics(double[] rel) {
        double[] delta;
        delta = new double[]{rel[0] + rel[1], rel[0] - rel[1], delta[1] / delta[0]};
        return delta;
    }

    public static double rd(double d) {
        throw new Error("Unresolved compilation problem: \n\tThe method round(double, int) is undefined for the type Mat\n");
    }

    public Matrix(int n) {
        this.matrix = new int[n][n];
        this.rows = new int[n];
        this.columns = new int[n];
    }

    public Matrix(int m, int n) {
        this.matrix = new int[m][n];
        this.rows = new int[m];
        this.columns = new int[n];
    }

    public Matrix(int n, Map<int[], Matrix> matrices) {
        this.matrix = new int[n][n];
        this.rows = new int[n];
        this.columns = new int[n];
        for (Matrix mat : matrices.values()) {
            int m = mat.getRowDim();
            int i = 0;
            while (i < m) {
                int a = mat.getIndex(i);
                int j = 0;
                while (j < m) {
                    int b = mat.getIndex(j);
                    this.augment(a, b, mat.get(i, j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public Matrix(Matrix mat) {
        int n = 0;
        int i = 0;
        while (i < mat.getRowDim()) {
            if (!mat.cannotPass(i)) {
                ++n;
            }
            ++i;
        }
        this.matrix = new int[n][n];
        this.rows = new int[n];
        this.columns = new int[n];
        int a = 0;
        int i2 = 0;
        while (i2 < mat.getRowDim()) {
            if (!mat.cannotPass(i2)) {
                int b = 0;
                int j = 0;
                while (j < mat.getRowDim()) {
                    if (!mat.cannotPass(j)) {
                        int k;
                        this.matrix[a][b] = k = mat.matrix[i2][j];
                        this.rows[a] = this.rows[a] + k;
                        this.columns[b] = this.columns[b] + k;
                        this.sum += k;
                        ++b;
                    }
                    ++j;
                }
                ++a;
            }
            ++i2;
        }
    }

    protected void augment(int i, int j) {
        int[] nArray = this.matrix[i];
        int n = j;
        nArray[n] = nArray[n] + 1;
        int n2 = i;
        this.rows[n2] = this.rows[n2] + 1;
        int n3 = j;
        this.columns[n3] = this.columns[n3] + 1;
        ++this.sum;
    }

    public void augment(int i, int j, int v) {
        this.matrix[i][j] = this.matrix[i][j] + v;
        this.rows[i] = this.rows[i] + v;
        this.columns[j] = this.columns[j] + v;
        this.sum += v;
    }

    private boolean cannotPass(int i) {
        if (this.rows[i] > 0 && this.columns[i] > 0) {
            return false;
        }
        return this.rows[i] <= 1 && this.columns[i] <= 1;
    }

    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    public int getColDim() {
        return this.columns.length;
    }

    public int getColSum(int i) {
        return this.columns[i];
    }

    public double getColSumMeans() {
        return new Double(this.sum) / new Double(this.getColDim());
    }

    public int[] getColSums() {
        return this.columns;
    }

    public double getColSumVariance() {
        double means = this.getColSumMeans();
        double var = 0.0;
        int i = 0;
        while (i < this.getColDim()) {
            var += Math.pow((double)this.columns[i] - means, 2.0);
            ++i;
        }
        return var / new Double(this.getRowDim());
    }

    public double getSymmetryIndex() {
        return this.symmetryIndex;
    }

    protected int getIndex(int i) {
        return this.index.get(i);
    }

    public double[] getRelinkings() {
        if (this.relinkings != null) {
            return this.relinkings;
        }
        this.relinkings = new double[8];
        int i = 0;
        while (i < this.getRowDim()) {
            int j = 0;
            while (j < i) {
                double v = this.get(i, j);
                double w = this.get(j, i);
                double x = v * (v - 1.0) / 2.0 + w * (w - 1.0) / 2.0;
                double y = v * w;
                this.relinkings[3] = this.relinkings[3] + x;
                this.relinkings[4] = this.relinkings[4] + y;
                if (v > 1.0) {
                    this.relinkings[5] = this.relinkings[5] + v;
                }
                if (w > 1.0) {
                    this.relinkings[5] = this.relinkings[5] + w;
                }
                if (v > 0.0 && w > 0.0) {
                    this.relinkings[6] = this.relinkings[6] + v + w;
                }
                if (v > 1.0 || v > 0.0 && w > 0.0) {
                    this.relinkings[7] = this.relinkings[7] + v;
                }
                if (w > 1.0 || v > 0.0 && w > 0.0) {
                    this.relinkings[7] = this.relinkings[7] + w;
                }
                ++j;
            }
            ++i;
        }
        this.relinkings[0] = this.relinkings[3] + this.relinkings[4];
        this.relinkings[1] = this.relinkings[3] - this.relinkings[4];
        this.relinkings[2] = this.relinkings[1] / this.relinkings[0];
        return this.relinkings;
    }

    double[] getRelinkings(int runs, boolean exact) {
        if (runs == 0) {
            return this.getRelinkings();
        }
        double[] n = new double[8];
        if (this.map == null) {
            this.setMap();
        }
        int k = 0;
        while (k < runs) {
            Matrix rm = this.permute(exact);
            double[] r = rm.getRelinkings();
            Mat.addArray(n, r);
            ++k;
        }
        Mat.divArray(n, runs);
        return n;
    }

    double[] getRelinkingStatistics() {
        double[] delta = new double[3];
        long[] k = new long[4];
        int i = 0;
        while (i < this.getRowDim()) {
            long x = this.rows[i];
            long y = this.columns[i];
            long x2 = (long)Math.pow(x, 2.0);
            long y2 = (long)Math.pow(y, 2.0);
            k[0] = k[0] + x2;
            k[1] = k[1] + y2;
            k[2] = k[2] + x * y;
            k[3] = k[3] + x2 * y2;
            ++i;
        }
        k[2] = (long)Math.pow(k[2], 2.0);
        long num = k[0] * k[1] - k[2];
        long den = k[0] * k[1] + k[2] - 2L * k[3];
        double a = new Double(this.sum - 1) / (2.0 * Math.pow(this.sum, 3.0));
        delta[0] = a * (double)den;
        delta[1] = a * (double)num;
        delta[2] = delta[1] / delta[0];
        return delta;
    }

    public int getRowDim() {
        return this.rows.length;
    }

    public int getRowSum(int i) {
        return this.rows[i];
    }

    public double getRowSumMeans() {
        return new Double(this.sum) / new Double(this.getRowDim());
    }

    public int[] getRowSums() {
        return this.rows;
    }

    public double getRowSumVariance() {
        double means = this.getRowSumMeans();
        double var = 0.0;
        int i = 0;
        while (i < this.getRowDim()) {
            var += Math.pow((double)this.rows[i] - means, 2.0);
            ++i;
        }
        return var / new Double(this.getRowDim());
    }

    public int getSum() {
        return this.sum;
    }

    protected Matrix permute(boolean exact) {
        return new RandomMatrix(this, exact);
    }

    protected void print() {
        int i = 0;
        while (i < this.matrix.length) {
            String s = "";
            int j = 0;
            while (j < this.matrix.length) {
                s = String.valueOf(s) + this.matrix[i][j] + "\t";
                ++j;
            }
            System.out.println(s);
            ++i;
        }
    }

    public Matrix reduce() {
        return new Matrix(this);
    }

    public String reportRelinkingStatistics(int runs) {
        double[] d0 = this.getRelinkings();
        double[] d1 = this.getRelinkings(runs, false);
        double[] d2 = this.getRelinkings(runs, true);
        double[] d3 = this.getRelinkingStatistics();
        String s = "";
        s = String.valueOf(s) + this.getRowDim() + "\t";
        s = String.valueOf(s) + this.getSum() + "\t";
        s = String.valueOf(s) + Matrix.rd(this.getRowSumMeans()) + "\t";
        s = String.valueOf(s) + Matrix.rd(this.getRowSumVariance()) + "\t";
        s = String.valueOf(s) + Matrix.rd(this.getColSumVariance()) + "\t";
        s = String.valueOf(s) + Matrix.rd(d0[0]) + "\t";
        s = String.valueOf(s) + Matrix.rd(d1[0]) + "\t";
        s = String.valueOf(s) + Matrix.rd(d2[0]) + "\t";
        s = String.valueOf(s) + Matrix.rd(d3[0]) + "\t";
        s = String.valueOf(s) + Matrix.rd(d0[1]) + "\t";
        s = String.valueOf(s) + Matrix.rd(d1[1]) + "\t";
        s = String.valueOf(s) + Matrix.rd(d2[1]) + "\t";
        s = String.valueOf(s) + Matrix.rd(d3[1]) + "\t";
        s = String.valueOf(s) + Matrix.rd(100.0 * d0[2]) + "%\t";
        s = String.valueOf(s) + Matrix.rd(100.0 * d1[2]) + "%\t";
        s = String.valueOf(s) + Matrix.rd(100.0 * d2[2]) + "%\t";
        s = String.valueOf(s) + Matrix.rd(100.0 * d3[2]) + "%\t";
        return s;
    }

    public void set(int i, int j, int v) {
        this.matrix[i][j] = v;
        if (this.isSymmetric) {
            this.matrix[j][i] = v;
        }
    }

    public int[] getRow(int i) {
        return this.matrix[i];
    }

    protected void setIndex(int i, int j) {
        if (this.index.get(i) == null) {
            this.index.put(i, j);
        }
    }

    protected void setMap() {
        if (this.map != null) {
            return;
        }
        this.map = new TreeMap();
        int t = 0;
        int k = 1;
        int i = 0;
        while (i < this.getRowDim()) {
            int j = 0;
            while (j < this.getColDim()) {
                int d = this.rows[i] * this.columns[j];
                if (d != 0) {
                    this.map.put(t += d, new int[]{i, j});
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    void analyze() {
        double squareSum = 0.0;
        double crossSum = 0.0;
        double loopSum = 0.0;
        double squareLoopSum = 0.0;
        double sumSquare = Math.pow(this.sum, 2.0);
        double sumDoubleSquare = Math.pow(this.sum, 4.0);
        double squareOutStrengthSum = 0.0;
        double squareInStrengthSum = 0.0;
        double squareStrengthProductSum = 0.0;
        double strengthProductSum = 0.0;
        this.numberOfCyclicTriangles = 0;
        this.numberOfTransitiveTriangles = 0;
        int i = 0;
        while (i < this.getRowDim()) {
            loopSum += (double)this.get(i, i);
            squareLoopSum += Math.pow(this.get(i, i), 2.0);
            squareOutStrengthSum += Math.pow(this.rows[i], 2.0);
            squareInStrengthSum += Math.pow(this.columns[i], 2.0);
            strengthProductSum += (double)(this.rows[i] * this.columns[i]);
            squareStrengthProductSum += Math.pow(this.rows[i] * this.columns[i], 2.0);
            int j = 0;
            while (j < this.getColDim()) {
                squareSum += Math.pow(this.get(i, j), 2.0);
                crossSum += (double)(this.get(i, j) * this.get(j, i));
                if (this.get(i, j) > 0) {
                    int k = 0;
                    while (k < this.getRowDim()) {
                        int indirectPaths = this.get(i, j) * this.get(j, k);
                        if (i < j && j < k) {
                            this.numberOfCyclicTriangles += indirectPaths * this.get(k, i);
                        }
                        if (i != j && j != k && k != i) {
                            this.numberOfTransitiveTriangles += indirectPaths * this.get(i, k);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.concentrationIndex = squareSum / sumSquare;
        this.symmetryIndex = crossSum / squareSum;
        this.endogamicConcentrationIndex = loopSum > 0.0 ? squareLoopSum / Math.pow(loopSum, 2.0) : 0.0;
        this.endogamyIndex = loopSum / (double)this.sum;
        this.numberOfParallelCircuits = new Double(squareSum - (double)this.sum - squareLoopSum + loopSum).intValue() / 2;
        this.normalizedNumberOfParallelCircuits = (squareSum - (double)this.sum - squareLoopSum + loopSum) / sumSquare;
        this.numberOfCrossCircuits = new Double(crossSum - squareLoopSum).intValue() / 2;
        this.normalizedNumberOfCrossCircuits = (crossSum - squareLoopSum) / sumSquare;
        this.numberOfCircuits = this.numberOfParallelCircuits + this.numberOfCrossCircuits;
        this.normalizedNumberOfCircuits = this.normalizedNumberOfParallelCircuits + this.normalizedNumberOfCrossCircuits;
        this.strengthConcentrationIndex = squareInStrengthSum * squareOutStrengthSum / sumDoubleSquare;
        this.endogamicStrengthConcentrationIndex = squareStrengthProductSum / Math.pow(strengthProductSum, 2.0);
        this.strengthSymmetryIndex = Math.pow(squareStrengthProductSum, 0.5) / strengthProductSum;
        double factor0 = new Double(1.0 / (double)this.sum);
        int factor1 = this.sum * (this.sum - 1) / 2;
        double factor2 = 1.0 - factor0;
        double factor3 = factor2 * Math.pow(strengthProductSum, 2.0) / sumDoubleSquare + factor0 * strengthProductSum / sumSquare;
        double factor4 = factor2 * squareStrengthProductSum / sumDoubleSquare + factor0 * strengthProductSum / sumSquare;
        this.expectedEndogamyIndex = strengthProductSum / sumSquare;
        this.expectedConcentrationIndex = factor2 * this.strengthConcentrationIndex + factor0;
        this.expectedSymmetryIndex = factor3 / this.expectedConcentrationIndex;
        this.expectedEndogamicConcentrationIndex = factor4 / factor3;
        double expectedRelativeNumberOfParallelCircuits = this.strengthConcentrationIndex - squareStrengthProductSum / sumDoubleSquare;
        double expectedRelativeNumberOfCrossCircuits = Math.pow(strengthProductSum, 2.0) / sumDoubleSquare - squareStrengthProductSum / sumDoubleSquare;
        this.expectedNumberOfParallelCircuits = (double)factor1 * expectedRelativeNumberOfParallelCircuits;
        this.expectedNumberOfCrossCircuits = (double)factor1 * expectedRelativeNumberOfCrossCircuits;
        this.expectedNumberOfCircuits = this.expectedNumberOfParallelCircuits + this.expectedNumberOfCrossCircuits;
        this.expectedNormalizedNumberOfParallelCircuits = factor2 * expectedRelativeNumberOfParallelCircuits;
        this.expectedNormalizedNumberOfCrossCircuits = factor2 * expectedRelativeNumberOfCrossCircuits;
        this.expectedNormalizedNumberOfCircuits = this.expectedNormalizedNumberOfParallelCircuits + this.expectedNormalizedNumberOfCrossCircuits;
    }

    public int getNumberOfCyclicTriangles() {
        return this.numberOfCyclicTriangles;
    }

    public int getNumberOfTransitiveTriangles() {
        return this.numberOfTransitiveTriangles;
    }

    public double getExpectedConcentrationIndex() {
        return this.expectedConcentrationIndex;
    }

    public double getExpectedEndogamicConcentrationIndex() {
        return this.expectedEndogamicConcentrationIndex;
    }

    public double getExpectedSymmetryIndex() {
        return this.expectedSymmetryIndex;
    }

    public double getExpectedEndogamyIndex() {
        return this.expectedEndogamyIndex;
    }

    public double getStrengthSymmetryIndex() {
        return this.strengthSymmetryIndex;
    }

    public double getExpectedNumberOfCircuits() {
        return this.expectedNumberOfCircuits;
    }

    public double getExpectedNumberOfParallelCircuits() {
        return this.expectedNumberOfParallelCircuits;
    }

    public double getExpectedNumberOfCrossCircuits() {
        return this.expectedNumberOfCrossCircuits;
    }

    public double getExpectedNormalizedNumberOfCircuits() {
        return this.expectedNormalizedNumberOfCircuits;
    }

    public double getExpectedNormalizedNumberOfParallelCircuits() {
        return this.expectedNormalizedNumberOfParallelCircuits;
    }

    public double getExpectedNormalizedNumberOfCrossCircuits() {
        return this.expectedNormalizedNumberOfCrossCircuits;
    }

    public int getBalanceOfParallelVsCrossCircuits() {
        return this.numberOfParallelCircuits - this.numberOfCrossCircuits;
    }

    public double getExpectedBalanceOfParallelVsCrossCircuits() {
        return this.expectedNumberOfParallelCircuits - this.expectedNumberOfCrossCircuits;
    }

    public double getExpectedNormalizedBalanceOfParallelVsCrossCircuits() {
        return this.expectedNormalizedNumberOfParallelCircuits - this.expectedNormalizedNumberOfCrossCircuits;
    }

    public double getNormalizedBalanceOfParallelVsCrossCircuits() {
        return this.normalizedNumberOfParallelCircuits - this.normalizedNumberOfCrossCircuits;
    }

    public int getNumberOfCircuits() {
        return this.numberOfCircuits;
    }

    public int getMaximalNumberOfCircuits() {
        return new Double(Math.pow(this.sum, 2.0)).intValue() / 2;
    }

    public int getNumberOfParallelCircuits() {
        return this.numberOfParallelCircuits;
    }

    public int getNumberOfCrossCircuits() {
        return this.numberOfCrossCircuits;
    }

    public double getNormalizedNumberOfCircuits() {
        return this.normalizedNumberOfCircuits;
    }

    public double getNormalizedNumberOfParallelCircuits() {
        return this.normalizedNumberOfParallelCircuits;
    }

    public double getNormalizedNumberOfCrossCircuits() {
        return this.normalizedNumberOfCrossCircuits;
    }

    public double getConcentrationIndex() {
        return this.concentrationIndex;
    }

    public double getEndogamicConcentrationIndex() {
        return this.endogamicConcentrationIndex;
    }

    public double getEndogamyIndex() {
        return this.endogamyIndex;
    }

    public double getStrengthConcentrationIndex() {
        return this.strengthConcentrationIndex;
    }

    public double getEndogamicStrengthConcentrationIndex() {
        return this.endogamicStrengthConcentrationIndex;
    }

    public double getSurplusOfCircuits() {
        return ((double)this.numberOfCircuits - this.expectedNumberOfCircuits) / this.expectedNumberOfCircuits;
    }

    public double getSurplusOfParallelCircuits() {
        return ((double)this.numberOfParallelCircuits - this.expectedNumberOfParallelCircuits) / this.expectedNumberOfParallelCircuits;
    }

    public double getSurplusOfCrossCircuits() {
        return ((double)this.numberOfCrossCircuits - this.expectedNumberOfCrossCircuits) / this.expectedNumberOfCrossCircuits;
    }

    public double getMinimumConcentration() {
        return 1.0 / Math.pow(this.getRowDim(), 2.0);
    }
}

