/*
 * Decompiled with CFR 0.152.
 */
package oldcore.calc.partitions;

import java.util.ArrayList;
import java.util.Set;
import oldcore.calc.CountMap;
import oldcore.calc.VectorComparator;
import oldcore.calc.partitions.Clusterable;
import oldcore.calc.partitions.Partition;
import oldcore.util.Trafo;
import org.jfree.data.category.DefaultCategoryDataset;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;

public class Cluster<E extends Clusterable>
extends ArrayList<E>
implements Comparable<Cluster<E>> {
    private Object value;
    private int weight;
    private int netWeight;
    private int[] degree;
    private CountMap<Cluster<E>> links;
    private CountMap<Cluster<E>> invLinks;

    public Object getVal() {
        return this.value;
    }

    public void setValueTo(Object value) {
        this.value = value;
    }

    public Cluster() {
    }

    public Cluster(Object value) {
        this.value = value;
    }

    public Cluster(Object v, Cluster<E> c) {
        this.value = v;
        this.addAll(c);
    }

    public Cluster(Object value, E item) {
        this.value = value;
        this.add(item);
    }

    @Override
    public int compareTo(Cluster<E> otherCluster) {
        if (otherCluster.getVal() == null) {
            return 1;
        }
        if (this.getVal() instanceof Double) {
            return ((Double)this.getVal()).compareTo((Double)otherCluster.getVal());
        }
        if (this.getVal() instanceof Integer) {
            return ((Integer)this.getVal()).compareTo((Integer)otherCluster.getVal());
        }
        if (this.getVal() instanceof String) {
            if (((String)this.getVal()).matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+")) {
                return new Integer((String)this.getVal()).compareTo(new Integer((String)otherCluster.getVal()));
            }
            return ((String)this.getVal()).compareTo((String)otherCluster.getVal());
        }
        if (this.getVal() instanceof int[]) {
            return new VectorComparator().compare((int[])this.getVal(), (int[])otherCluster.getVal(), true);
        }
        return 0;
    }

    @Override
    public boolean equals(Object otherCluster) {
        return this.compareTo((Cluster)otherCluster) == 0;
    }

    @Override
    public boolean contains(Object obj) {
        for (Clusterable other : this) {
            if (!other.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public int count() {
        return this.size();
    }

    public int getID(int i) {
        return ((Individual)this.get(i)).getId();
    }

    public boolean hasValueEqualTo(Object value) {
        if (this.value == null) {
            return false;
        }
        return this.value.equals(value);
    }

    public boolean isNullCluster() {
        return this.getVal() == null || this.getVal().equals(0);
    }

    public String signature(int i) {
        if (i == 1) {
            return String.valueOf(Trafo.asString(this.getVal())) + "\t" + this.size();
        }
        return Trafo.asString(this.getVal());
    }

    public int size(Gender g) {
        int k = 0;
        for (Clusterable e : this) {
            if (((Individual)e).getGender() != g) continue;
            ++k;
        }
        return k;
    }

    public int getInDegree() {
        if (this.degree == null) {
            return 0;
        }
        return this.degree[1];
    }

    public CountMap<Cluster<E>> getLinks() {
        return this.links;
    }

    public CountMap<Cluster<E>> getInvLinks() {
        return this.invLinks;
    }

    public double getMeanLevel(Partition<E> generations) {
        double g = 0.0;
        for (Clusterable a : this) {
            g += (double)((Integer)generations.getVal(a)).intValue();
        }
        return g / (double)this.size();
    }

    public int getNetWeight() {
        return this.netWeight;
    }

    public int getOutDegree() {
        if (this.degree == null) {
            return 0;
        }
        return this.degree[0];
    }

    public int getWeight(int t) {
        if (t == 0) {
            return this.weight;
        }
        if (t == 1) {
            return this.netWeight;
        }
        if (t == 2) {
            return this.getAutoWeight();
        }
        return 0;
    }

    private void setDegree(int i, int j) {
        if (this.degree == null) {
            this.degree = new int[2];
        }
        this.degree[i] = j;
    }

    public void setDegrees() {
        if (this.getLinks() == null) {
            return;
        }
        for (Cluster v : this.getLinks().keySet()) {
            int d = this.getLinks().get(v);
            this.setDegree(0, this.getOutDegree() + d);
            v.setDegree(1, v.getInDegree() + d);
        }
    }

    public void setLink(Cluster<E> v) {
        this.setLink(v, 1);
    }

    public void setInvLink(Cluster<E> v) {
        this.setInvLink(v, 1);
    }

    public void setLink(Cluster<E> v, int k) {
        if (this.getLinks() == null) {
            this.setLinks(new CountMap<Cluster<E>>());
        }
        this.getLinks().add(v, k);
    }

    public void setInvLink(Cluster<E> v, int k) {
        if (this.getInvLinks() == null) {
            this.setInvLinks(new CountMap<Cluster<E>>());
        }
        this.getInvLinks().add(v, k);
    }

    private void setLinks(CountMap<Cluster<E>> links) {
        this.links = links;
    }

    private void setInvLinks(CountMap<Cluster<E>> invLinks) {
        this.invLinks = invLinks;
    }

    public int with(Cluster<E> v) {
        if (this.getLinks() == null) {
            return 0;
        }
        if (this.getLinks().get(v) == null) {
            return 0;
        }
        return this.getLinks().get(v);
    }

    public void augmentWeight() {
        ++this.weight;
    }

    public int getAutoWeight() {
        try {
            return this.links.get(this);
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public Set<Cluster<E>> getTakers() {
        if (this.getLinks() == null) {
            return null;
        }
        return this.getLinks().keySet();
    }

    public Set<Cluster<E>> getGivers() {
        if (this.getInvLinks() == null) {
            return null;
        }
        return this.getInvLinks().keySet();
    }

    public void diminishLink(Cluster<E> v) {
        this.getLinks().diminish(v);
        v.getInvLinks().diminish(this);
    }

    public void augment(boolean condition) {
        if (condition) {
            ++this.netWeight;
        }
    }

    public int toDataset(DefaultCategoryDataset defaultCategoryDataset, int n, int n2, int n3, boolean bl, Net net, Partition<E> partition) {
        throw new Error("Unresolved compilation problems: \n\tThe method signature(int) in the type Cluster<E> is not applicable for the arguments (Notation)\n\tThe method signature(int) in the type Cluster<E> is not applicable for the arguments (Notation)\n");
    }
}

