/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.util;

import java.util.Date;

public class Chronometer {
    private long sum;
    private long startTime;

    public Chronometer() {
        this.reset();
    }

    public long appendingInterval() {
        long result = this.sum + new Date().getTime() - this.startTime;
        return result;
    }

    public long interval() {
        long result = this.sum;
        return result;
    }

    public Chronometer reset() {
        this.sum = 0L;
        this.startTime = new Date().getTime();
        Chronometer result = this;
        return result;
    }

    public long runningInterval() {
        long result = new Date().getTime() - this.startTime;
        return result;
    }

    public Chronometer start() {
        this.startTime = new Date().getTime();
        Chronometer result = this;
        return result;
    }

    public Chronometer stop() {
        long now = new Date().getTime();
        this.sum += now - this.startTime;
        this.startTime = now;
        Chronometer result = this;
        return result;
    }

    public static String toHumanString(long interval) {
        String result = interval < 1000L ? String.valueOf(interval) + " ms" : (interval < 60000L ? String.valueOf(interval / 1000L) + "," + interval % 1000L + " s" : (interval < 3600000L ? String.valueOf(interval / 1000L / 60L) + " mn " + interval / 1000L % 60L + "," + interval % 1000L + " s" : (interval < 86400000L ? String.valueOf(interval / 1000L) + "," + interval % 1000L + " s" : (interval < 604800000L ? String.valueOf(interval / 1000L) + "," + interval % 1000L + " s" : String.valueOf(interval / 1000L) + "," + interval % 1000L + " s"))));
        return result;
    }

    public static String toShortHumanString(long interval) {
        String result = interval < 1000L ? String.valueOf(interval) + " ms" : (interval < 2000L ? String.valueOf(interval / 1000L) + " seconde" : (interval < 60000L ? String.valueOf(interval / 1000L) + " secondes" : (interval < 120000L ? String.valueOf(interval / 60000L) + " minute" : (interval < 3600000L ? String.valueOf(interval / 60000L) + " minutes" : (interval < 0x6DDD00L ? String.valueOf(interval / 3600000L) + " heure" : (interval < 86400000L ? String.valueOf(interval / 3600000L) + " heures" : (interval < 172800000L ? String.valueOf(interval / 86400000L) + " jour" : (interval < 604800000L ? String.valueOf(interval / 86400000L) + " jours" : (interval < 1209600000L ? String.valueOf(interval / 604800000L) + " semaine" : (interval < 2592000000L ? String.valueOf(interval / 604800000L) + " semaines" : (interval < 31449600000L ? String.valueOf(interval / 2592000000L) + " mois" : (interval < 62899200000L ? String.valueOf(interval / 31449600000L) + " ann\u00e9e" : String.valueOf(interval / 31449600000L) + " ann\u00e9es"))))))))))));
        return result;
    }

    public static String toTimer(long interval) {
        long value = interval / 1000L;
        long seconds = value % 60L;
        long minutes = value / 60L % 60L;
        long hours = value / 60L / 60L;
        String result = String.format("%02d:%02d:%02d", hours, minutes, seconds);
        return result;
    }
}

