/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.swing;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.FileTools;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.gui.views.help.TutorialDialog;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.GeoNamesFlatDatabase;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.GeoNamesLines;
import org.tip.flatdb4geonames.model.GeoNamesSearchCriteria;
import org.tip.flatdb4geonames.model.GeoNamesSearchResult;
import org.tip.flatdb4geonames.model.index.FeatureClass;
import org.tip.flatdb4geonames.util.Chronometer;

public class FlatDB4GeoNamesRequestPanel
extends JPanel {
    private static final long serialVersionUID = -6719667140204170550L;
    private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNamesRequestPanel.class);
    private JTextField txtfldInput;
    private JEditorPane resultPane;
    private JCheckBox chckbxCountryStateRegion;
    private JCheckBox chckbxStreamlake;
    private JCheckBox chckbxParkArea;
    private JCheckBox chckbxCityVillage;
    private JCheckBox chckbxSpotBuildingFarm;
    private JCheckBox chckbxMountainHillRock;
    private JCheckBox chckbxUndersea;
    private JCheckBox chckbxForestHeath;
    private JButton btnSearch;
    private JLabel lblTips;

    public FlatDB4GeoNamesRequestPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel queryPanel = new JPanel();
        this.add((Component)queryPanel, "North");
        queryPanel.setLayout(new BoxLayout(queryPanel, 1));
        JPanel panel1 = new JPanel();
        queryPanel.add(panel1);
        panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblInput = new JLabel("Input:");
        panel1.add((Component)lblInput, "2, 2");
        this.txtfldInput = new JTextField();
        this.txtfldInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    FlatDB4GeoNamesRequestPanel.this.btnSearch.doClick();
                }
            }
        });
        panel1.add((Component)this.txtfldInput, "4, 2");
        this.txtfldInput.setColumns(50);
        this.btnSearch = new JButton("Search");
        this.btnSearch.setEnabled(false);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GeoNamesSearchCriteria criteria = FlatDB4GeoNamesRequestPanel.this.getCriteria();
                    Chronometer chrono = new Chronometer();
                    GeoNamesLines lines = FlatDB4GeoNames.instance().search(criteria);
                    chrono.stop();
                    logger.debug("result lines count=" + lines.size());
                    GeoNamesSearchResult result = new GeoNamesSearchResult(criteria, lines, chrono.interval());
                    FlatDB4GeoNamesRequestPanel.this.refreshResult(result);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
                catch (FlatDB4GeoNamesException exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
        panel1.add((Component)this.btnSearch, "6, 2");
        this.lblTips = new JLabel("(space = AND, comma = OR)");
        panel1.add((Component)this.lblTips, "4, 3, right, default");
        JPanel panel_5 = new JPanel();
        queryPanel.add(panel_5);
        panel_5.setBorder(new TitledBorder(null, "Feature Class", 4, 2, null, null));
        panel_5.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.chckbxCountryStateRegion = new JCheckBox("Country State Region");
        panel_5.add((Component)this.chckbxCountryStateRegion, "2, 2");
        this.chckbxParkArea = new JCheckBox("Park Area");
        panel_5.add((Component)this.chckbxParkArea, "4, 2");
        this.chckbxSpotBuildingFarm = new JCheckBox("Spot Building Farm");
        panel_5.add((Component)this.chckbxSpotBuildingFarm, "6, 2");
        this.chckbxUndersea = new JCheckBox("Undersea");
        panel_5.add((Component)this.chckbxUndersea, "8, 2");
        this.chckbxStreamlake = new JCheckBox("Stream Lake");
        panel_5.add((Component)this.chckbxStreamlake, "2, 4");
        this.chckbxCityVillage = new JCheckBox("City Village");
        panel_5.add((Component)this.chckbxCityVillage, "4, 4");
        this.chckbxMountainHillRock = new JCheckBox("Mountain Hill Rock");
        panel_5.add((Component)this.chckbxMountainHillRock, "6, 4");
        this.chckbxForestHeath = new JCheckBox("Forest Heath");
        panel_5.add((Component)this.chckbxForestHeath, "8, 4");
        JSeparator separator = new JSeparator();
        queryPanel.add(separator);
        JPanel resultPanel = new JPanel();
        this.add((Component)resultPanel, "Center");
        resultPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        resultPanel.add(scrollPane);
        this.resultPane = new JEditorPane();
        this.resultPane.setEditable(false);
        this.resultPane.setBackground(new Color(238, 238, 238));
        this.resultPane.setContentType("text/html;charset=UTF-8");
        scrollPane.setViewportView(this.resultPane);
        if (FlatDB4GeoNames.isOpened()) {
            this.btnSearch.setEnabled(true);
        } else {
            this.btnSearch.setEnabled(false);
        }
    }

    public GeoNamesSearchCriteria getCriteria() {
        GeoNamesSearchCriteria result = new GeoNamesSearchCriteria();
        result.setInput(this.txtfldInput.getText());
        result.featureClasses().clear();
        if (this.chckbxCityVillage.isSelected()) {
            result.featureClasses().add(FeatureClass.CITY_VILLAGE);
        }
        if (this.chckbxCountryStateRegion.isSelected()) {
            result.featureClasses().add(FeatureClass.COUNTRY_STATE_REGION);
        }
        if (this.chckbxForestHeath.isSelected()) {
            result.featureClasses().add(FeatureClass.FOREST_HEATH);
        }
        if (this.chckbxMountainHillRock.isSelected()) {
            result.featureClasses().add(FeatureClass.MOUNTAIN_HILL_ROCK);
        }
        if (this.chckbxParkArea.isSelected()) {
            result.featureClasses().add(FeatureClass.PARK_AREA);
        }
        if (this.chckbxSpotBuildingFarm.isSelected()) {
            result.featureClasses().add(FeatureClass.SPOT_BUILDING_FARM);
        }
        if (this.chckbxStreamlake.isSelected()) {
            result.featureClasses().add(FeatureClass.STREAM_LAKE);
        }
        if (this.chckbxUndersea.isSelected()) {
            result.featureClasses().add(FeatureClass.UNDERSEA);
        }
        return result;
    }

    public void refresh() {
        if (FlatDB4GeoNames.isOpened()) {
            this.btnSearch.setEnabled(true);
        } else {
            this.btnSearch.setEnabled(false);
        }
    }

    public void refreshResult(GeoNamesSearchResult result) throws IOException, FlatDB4GeoNamesException {
        GeoNamesFlatDatabase database = FlatDB4GeoNames.instance();
        if (database == null) {
            this.resultPane.setText("");
        } else {
            StringList lines = FlatDB4GeoNamesRequestPanel.toRaw(result, 100);
            logger.debug("raw lines count={}", (Object)lines.size());
            logger.debug("raw lines length={}", (Object)lines.length());
            StringList page = new StringList(FileTools.load((URL)TutorialDialog.class.getResource("/org/tip/flatdb4geonames/swing/default.html")).split("\n"));
            page.add(page.size() - 2, (Object)lines.toString());
            this.resultPane.setText(page.toString());
            this.resultPane.setCaretPosition(0);
        }
    }

    public static StringList toRaw(GeoNamesSearchResult source, int maxLineCount) {
        StringList result = new StringList();
        result.append("<p>").append(String.format("%,d results in %.3f second(s)", source.getLines().size(), Float.valueOf((float)source.getDuration() / 1000.0f))).appendln("</p>");
        result.appendln("<p>");
        result.appendln("<table class=\"table_default\">");
        result.appendln("  <tr>");
        result.appendln("    <th>Nr.</th>");
        result.appendln("    <th>GeonameId</th>");
        result.appendln("    <th>Name</th>");
        result.appendln("    <th>Ascii Name</th>");
        result.appendln("    <th>Alternate names</th>");
        result.appendln("    <th>latitude</th>");
        result.appendln("    <th>longitude</th>");
        result.appendln("    <th>Feature Class</th>");
        result.appendln("    <th>Feature Code</th>");
        result.appendln("    <th>Country code</th>");
        result.appendln("    <th>CC2</th>");
        result.appendln("    <th title=\"fipscode\">Admin1 code</th>");
        result.appendln("    <th>Admin2 code</th>");
        result.appendln("    <th>Admin3 code</th>");
        result.appendln("    <th>Admin4 code</th>");
        result.appendln("    <th>Population</th>");
        result.appendln("    <th title=\"in meters\">Elevation</th>");
        result.appendln("    <th>Dem</th>");
        result.appendln("    <th>Timezone</th>");
        result.appendln("    <th>Modification<br/>Date</th>");
        result.appendln("  </tr>");
        int lineCount = 0;
        while (lineCount < NumberUtils.min((int)source.getLines().size(), (int)maxLineCount, (int)maxLineCount)) {
            GeoNamesLine line = (GeoNamesLine)source.getLines().get(lineCount);
            result.appendln("  <tr>");
            result.append("    <td class=\"center\">").append(lineCount + 1).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getGeoNameId()).appendln("</td>");
            result.append("    <td class=\"left\">").append(line.getName()).appendln("</td>");
            result.append("    <td class=\"left\">").append(line.getAsciiName()).appendln("</td>");
            result.append("    <td class=\"left\">").append(line.getAlternateNames().toStringList().toStringWithCommas()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getLatitude()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getLongitude()).appendln("</td>");
            result.append("    <td class=\"center\">").append(FeatureClass.toString(line.getFeatureClass())).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getFeatureCode()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getCountryCode()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getAlternateCountryCodes().toStringList().toStringWithCommas()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getAdministrativeCode1()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getAdministrativeCode2()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getAdministrativeCode3()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getAdministrativeCode4()).appendln("</td>");
            result.append("    <td class=\"right\">").append(line.getPopulation().longValue()).appendln("</td>");
            result.append("    <td class=\"right\">").append(line.getElevation().intValue()).appendln("</td>");
            if (line.getDem() == null) {
                result.append("    <td>").append("").appendln("</td>");
            } else {
                result.append("    <td class=\"center\">").append(line.getDem().intValue()).appendln("</td>");
            }
            result.append("    <td class=\"center\">").append(line.getTimeZone()).appendln("</td>");
            result.append("    <td class=\"center\">").append(line.getModificationDate()).appendln("</td>");
            result.appendln("  </tr>");
            ++lineCount;
        }
        result.appendln("</table>");
        result.appendln("</p>");
        return result;
    }

    public static StringList toTiny(GeoNamesLines source) {
        StringList result = new StringList();
        return result;
    }
}

