/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.swing;

import fr.devinsy.util.FileTools;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tip.flatdb4geonames.gui.views.help.TutorialDialog;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.GeoNamesFlatDatabase;

public class FlatDB4GeoNamesGeneralPanel
extends JPanel {
    private static final long serialVersionUID = 8900658076835485258L;
    private JEditorPane editorPane;

    public FlatDB4GeoNamesGeneralPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "Center");
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        scrollPane.setViewportView(this.editorPane);
    }

    public void refresh() throws IOException {
        GeoNamesFlatDatabase database = FlatDB4GeoNames.instance();
        if (database == null) {
            this.editorPane.setText("");
        } else {
            StringList lines = new StringList();
            lines.appendln("<p>Repository directory: ").append(database.getRepository().getAbsolutePath()).appendln("</p>");
            lines.appendln("<p>");
            lines.appendln("<table>");
            long total = 0L;
            Object[] filenames = database.getRepository().list();
            Arrays.sort(filenames);
            Object[] objectArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                Object filename = objectArray[n2];
                File file = new File(database.getRepository() + File.separator + (String)filename);
                lines.appendln("  <tr>");
                lines.append("    <td>").append(file.getName()).appendln("</td>");
                lines.append("    <td style=\"text-align: right;\">").append(String.format("%,d", file.length() / 1024L)).append(" KB").appendln("</td>");
                lines.appendln("  </tr>");
                total += file.length();
                ++n2;
            }
            lines.append("    <td style=\"text-align: right;\">").append("Total:").appendln("</td>");
            lines.append("    <td style=\"text-align: right;\">").append(String.format("%,d", total / 1024L)).append(" KB").appendln("</td>");
            lines.appendln("</table>");
            lines.appendln("</p>");
            StringList page = new StringList(FileTools.load((URL)TutorialDialog.class.getResource("/org/tip/flatdb4geonames/swing/default.html")).split("\n"));
            page.add(page.size() - 2, (Object)lines.toString());
            this.editorPane.setText(page.toString());
            this.editorPane.setCaretPosition(0);
        }
    }
}

