/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.workers;

import fr.devinsy.util.StringSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.index.IndexOfWordSeeksBuilder;
import org.tip.flatdb4geonames.util.StringLongPair;
import org.tip.flatdb4geonames.util.StringLongPairs;

public class StatisticsWorker {
    private static Logger logger = LoggerFactory.getLogger(StatisticsWorker.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static StringLongPairs censusLongestWords(int maxLineCount) throws IOException {
        StringLongPairs result = new StringLongPairs();
        String geonamesFile = FlatDB4GeoNames.instance().getRepository() + File.separator + "allCountries.txt";
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(geonamesFile)), DEFAULT_CHARSET_NAME));
            boolean ended = false;
            int lineCount = 0;
            HashMap<String, StringLongPair> indexOfWords = new HashMap<String, StringLongPair>();
            while (!ended) {
                String line = in.readLine();
                if (++lineCount % 100000 == 0) {
                    logger.debug("lineCount={} {}", (Object)lineCount, (Object)indexOfWords.size());
                }
                if (line == null) {
                    ended = true;
                    continue;
                }
                StringSet words = IndexOfWordSeeksBuilder.geoNameLineToRawWords(line);
                for (String word : words.toStringList()) {
                    if (word.length() <= 25) continue;
                    StringLongPair pair = (StringLongPair)indexOfWords.get(word);
                    if (pair == null) {
                        pair = new StringLongPair(word, word.length());
                        pair.inc();
                        result.add(pair);
                        indexOfWords.put(word, pair);
                        continue;
                    }
                    pair.inc();
                }
            }
            for (StringLongPair pair : indexOfWords.values()) {
                result.add(pair);
            }
            result.sortByLong().reverse();
            while (result.size() > maxLineCount) {
                indexOfWords.remove(result.removeLast());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static StringLongPairs censusLongestWords2(int maxLineCount) throws IOException {
        StringLongPairs result = new StringLongPairs();
        String geonamesFile = FlatDB4GeoNames.instance().getRepository() + File.separator + "allCountries.txt";
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(geonamesFile)), DEFAULT_CHARSET_NAME));
            boolean ended = false;
            int lineCount = 0;
            HashMap<String, StringLongPair> indexOfWords = new HashMap<String, StringLongPair>();
            while (!ended) {
                String line = in.readLine();
                if (++lineCount % 100000 == 0) {
                    logger.debug("lineCount={}", (Object)lineCount);
                }
                if (line == null) {
                    ended = true;
                    continue;
                }
                StringSet words = IndexOfWordSeeksBuilder.geoNameLineToRawWords(line);
                for (String word : words.toStringList()) {
                    StringLongPair pair = (StringLongPair)indexOfWords.get(word);
                    if (pair == null) {
                        pair = new StringLongPair(word, word.length());
                        pair.inc();
                        result.add(pair);
                        indexOfWords.put(word, pair);
                        continue;
                    }
                    pair.inc();
                }
                result.sortByLong().reverse();
                while (result.size() > maxLineCount) {
                    indexOfWords.remove(result.removeLast());
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return result;
    }

    public static StringLongPairs censusWordMatching(int maxLineCount) throws IOException {
        StringLongPairs result = new StringLongPairs();
        String index2 = FlatDB4GeoNames.instance().getRepository() + File.separator + "word_seek.index";
        String index1 = FlatDB4GeoNames.instance().getRepository() + File.separator + "seeks.index";
        BufferedReader in2 = null;
        BufferedReader in1 = null;
        try {
            in2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(index2)), DEFAULT_CHARSET_NAME));
            in1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(index1)), DEFAULT_CHARSET_NAME));
            boolean ended = false;
            int lineCount = 0;
            while (!ended) {
                String line2 = in2.readLine();
                String line1 = in1.readLine();
                if (++lineCount % 100000 == 0) {
                    logger.debug("lineCount={}", (Object)lineCount);
                }
                if (line2 == null) {
                    ended = true;
                    continue;
                }
                String word = line2.split("\t")[0];
                long matchingCount = 1L;
                int position = 0;
                while (position < line1.length()) {
                    if (line1.charAt(position) == ',') {
                        ++matchingCount;
                    }
                    ++position;
                }
                StringLongPair pair = new StringLongPair(word, matchingCount);
                result.add(pair);
                result.sortByLong().reverse();
                while (result.size() > maxLineCount) {
                    result.removeLast();
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in2);
            IOUtils.closeQuietly(in1);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in2);
        IOUtils.closeQuietly((Reader)in1);
        return result;
    }
}

