/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.index.StringLineIdComparator;
import org.tip.flatdb4geonames.util.Chronometer;
import org.tip.flatdb4geonames.util.StringFileSorter;

public class IndexOfIdSeekBuilder {
    private static Logger logger = LoggerFactory.getLogger(IndexOfIdSeekBuilder.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String DEFAULT_INDEX_FILENAME = "id_seek.index";
    public static final int DEFAULT_SPLIT_LINE = 2000000;
    public static final int DEFAULT_PADDING_LENGTH = 11;

    public static void buildIndex(File geonamesMainFile, File outputDirectory) throws IOException {
        IndexOfIdSeekBuilder.buildIndex(geonamesMainFile, outputDirectory, 2000000, 11);
    }

    public static void buildIndex(File geonamesMainFile, File outputDirectory, int splitLimit, int paddingLength) throws IOException {
        logger.debug("Build index id->seek starting...");
        File target = new File(outputDirectory.getAbsoluteFile() + File.separator + DEFAULT_INDEX_FILENAME);
        IndexOfIdSeekBuilder.geonamesToIdSeek(geonamesMainFile, target);
        StringFileSorter.sortBigStringFile(target, splitLimit, new StringLineIdComparator());
        IndexOfIdSeekBuilder.padFile(target, paddingLength);
        logger.debug("Build index id->seek done.");
    }

    public static void geonamesToIdSeek(File source, File target) throws IOException {
        logger.debug("geonamesToIdSeek starting...");
        Chronometer chronoStep = new Chronometer();
        long currentSeekValue = 0L;
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), DEFAULT_CHARSET_NAME));
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), DEFAULT_CHARSET_NAME));
            int lineCount = 0;
            boolean ended = false;
            while (!ended) {
                String line;
                if (lineCount % 1000000 == 0) {
                    System.gc();
                    logger.debug("\tlineCount=" + lineCount + "\tcurrentSeekValue=" + currentSeekValue + " \tmemory=" + Runtime.getRuntime().totalMemory() / 1024L / 1024L + " Mo \t" + (int)(chronoStep.stop().interval() / 1000L) + " s");
                    chronoStep.reset();
                }
                if ((line = in.readLine()) == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                String id = line.split("\t")[0];
                out.println(String.valueOf(id) + "\t" + currentSeekValue);
                currentSeekValue += (long)(line.getBytes().length + 1);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
        logger.debug("geonamesToIdSeek done.");
    }

    public static void padFile(File source, File target, int paddingLength) throws IOException {
        Chronometer chronoStep = new Chronometer();
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), DEFAULT_CHARSET_NAME));
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), DEFAULT_CHARSET_NAME));
            int lineCount = 0;
            int currentId = 0;
            boolean ended = false;
            while (!ended) {
                String line;
                if (lineCount % 1000000 == 0) {
                    System.gc();
                    logger.debug("\tlineCount=" + lineCount + " \tmemory=" + Runtime.getRuntime().totalMemory() / 1024L / 1024L + " Mo \t" + (int)(chronoStep.stop().interval() / 1000L) + " s");
                    chronoStep.reset();
                }
                if ((line = in.readLine()) == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                ++currentId;
                String[] tokens = line.split("\t");
                int id = Integer.parseInt(tokens[0]);
                long seekValue = Long.parseLong(tokens[1]);
                while (currentId < id) {
                    out.println(StringUtils.rightPad((String)"", (int)paddingLength));
                    ++currentId;
                }
                String newLine = StringUtils.rightPad((String)String.valueOf(seekValue), (int)paddingLength);
                out.println(newLine);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }

    public static void padFile(File source, int paddingLength) throws IOException {
        File target = new File(String.valueOf(source.getAbsolutePath()) + ".padded" + System.currentTimeMillis());
        IndexOfIdSeekBuilder.padFile(source, target, paddingLength);
        target.renameTo(source);
    }
}

