/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import org.apache.commons.lang3.StringUtils;

public enum FeatureClass {
    COUNTRY_STATE_REGION("A", "Country, state, region\u2026"),
    STREAM_LAKE("H", "Stream, lake\u2026"),
    PARK_AREA("L", "Parks,area\u2026"),
    CITY_VILLAGE("P", "City, village\u2026"),
    ROAD_RAILROAD("R", "Road, railroad"),
    SPOT_BUILDING_FARM("S", "Spot, building, farm"),
    MOUNTAIN_HILL_ROCK("T", "Mountain, hill, rock\u2026"),
    UNDERSEA("U", "Undersea"),
    FOREST_HEATH("V", "Forest,heath\u2026");

    private String code;
    private String description;

    private FeatureClass(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static boolean isClassCode(String code) {
        boolean result = code != null && code.length() == 1 && StringUtils.contains((CharSequence)"AHLPRSTUV", (CharSequence)code);
        return result;
    }

    public static String toString(FeatureClass source) {
        String result = source == null ? "" : source.toString();
        return result;
    }

    public static FeatureClass valueOfCode(String code) {
        FeatureClass result = code == null ? null : (code.equals("A") ? COUNTRY_STATE_REGION : (code.equals("H") ? STREAM_LAKE : (code.equals("L") ? PARK_AREA : (code.equals("P") ? CITY_VILLAGE : (code.equals("R") ? ROAD_RAILROAD : (code.equals("S") ? SPOT_BUILDING_FARM : (code.equals("T") ? MOUNTAIN_HILL_ROCK : (code.equals("U") ? UNDERSEA : (code.equals("V") ? FOREST_HEATH : null)))))))));
        return result;
    }
}

