/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import org.tip.flatdb4geonames.model.index.FeatureClasses;

public class GeoNamesSearchCriteria {
    private SearchMode searchMode;
    private Continent continentScope;
    private String countryCode;
    private FeatureClasses featureClasses;
    private String input;

    public GeoNamesSearchCriteria() {
        this.searchMode = SearchMode.PART_MATCH;
        this.continentScope = Continent.ALL;
        this.countryCode = null;
        this.featureClasses = new FeatureClasses();
    }

    public GeoNamesSearchCriteria(GeoNamesSearchCriteria source) {
        this.searchMode = source.getSearchMode();
        this.continentScope = source.getContinentScope();
        this.countryCode = source.getCountryCode();
        this.featureClasses = source.featureClasses();
        this.input = source.getInput();
    }

    public FeatureClasses featureClasses() {
        return this.featureClasses;
    }

    public Continent getContinentScope() {
        return this.continentScope;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getInput() {
        return this.input;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setContinentScope(Continent continentScope) {
        this.continentScope = continentScope;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public static enum Continent {
        ALL("*"),
        AFRICA("AF"),
        ANTARCTICA("AN"),
        ASIA("AS"),
        EUROPE("EU"),
        NORTH_AMERICA("NA"),
        OCEANIA("OC"),
        SOUTH_AMERICA("SA");

        private String code;

        private Continent(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public Continent valueOfCode(String code) {
            Continent result = code == null ? ALL : (code.equals("AF") ? AFRICA : (code.equals("AN") ? ANTARCTICA : (code.equals("AS") ? ASIA : (code.equals("EU") ? EUROPE : (code.equals("NA") ? NORTH_AMERICA : (code.equals("OC") ? OCEANIA : (code.equals("SA") ? SOUTH_AMERICA : ALL)))))));
            return result;
        }
    }

    public static enum SearchMode {
        PART_MATCH,
        FULL_MATCH;

    }
}

