/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.index.FeatureClass;

public class GeoNamesLine {
    private static Logger logger = LoggerFactory.getLogger(GeoNamesLine.class);
    private long geoNameId;
    private String name;
    private String asciiName;
    private StringSet alternateNames = new StringSet();
    private Double latitude;
    private Double longitude;
    private FeatureClass featureClass;
    private String featureCode;
    private String countryCode;
    private StringSet alternateCountryCodes = new StringSet();
    private String administrativeCode1;
    private String administrativeCode2;
    private String administrativeCode3;
    private String administrativeCode4;
    private Long population;
    private Integer elevation;
    private Integer dem;
    private String timeZone;
    private String modificationDate;

    public String getAdministrativeCode1() {
        return this.administrativeCode1;
    }

    public String getAdministrativeCode2() {
        return this.administrativeCode2;
    }

    public String getAdministrativeCode3() {
        return this.administrativeCode3;
    }

    public String getAdministrativeCode4() {
        return this.administrativeCode4;
    }

    public String getAdministrativeCodePath() {
        StringList buffer = new StringList();
        buffer.append(this.countryCode);
        buffer.append(this.administrativeCode1);
        buffer.append(this.administrativeCode2);
        buffer.append(this.administrativeCode3);
        buffer.append(this.administrativeCode4);
        String result = buffer.toStringSeparatedBy(".");
        return result;
    }

    public String getAdministrativeShortCodePath() {
        StringList buffer = new StringList();
        buffer.append(this.countryCode);
        buffer.append(this.administrativeCode1);
        buffer.append(this.administrativeCode2);
        String result = buffer.toStringSeparatedBy(".");
        return result;
    }

    public StringSet getAlternateCountryCodes() {
        return this.alternateCountryCodes;
    }

    public StringSet getAlternateNames() {
        return this.alternateNames;
    }

    public String getAsciiName() {
        return this.asciiName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Integer getDem() {
        return this.dem;
    }

    public Integer getElevation() {
        return this.elevation;
    }

    public FeatureClass getFeatureClass() {
        return this.featureClass;
    }

    public String getFeatureCode() {
        return this.featureCode;
    }

    public String getFeatureCodePath() {
        StringList buffer = new StringList();
        buffer.append(this.featureClass.getCode());
        buffer.append(this.featureCode);
        String result = buffer.toStringSeparatedBy(".");
        return result;
    }

    public long getGeoNameId() {
        return this.geoNameId;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getModificationDate() {
        return this.modificationDate;
    }

    public String getName() {
        return this.name;
    }

    public Long getPopulation() {
        return this.population;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setAdminCode1(String adminCode1) {
        this.administrativeCode1 = adminCode1;
    }

    public void setAdminCode2(String adminCode2) {
        this.administrativeCode2 = adminCode2;
    }

    public void setAdminCode3(String adminCode3) {
        this.administrativeCode3 = adminCode3;
    }

    public void setAdminCode4(String adminCode4) {
        this.administrativeCode4 = adminCode4;
    }

    public void setAsciiName(String asciiName) {
        this.asciiName = asciiName;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setDem(Integer dem) {
        this.dem = dem;
    }

    public void setElevation(Integer elevation) {
        this.elevation = elevation;
    }

    public void setFeatureClass(FeatureClass featureClass) {
        this.featureClass = featureClass;
    }

    public void setFeatureCode(String featureCode) {
        this.featureCode = featureCode;
    }

    public void setGeoNameId(long geoNameId) {
        this.geoNameId = geoNameId;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setModificationDate(String modificationDate) {
        this.modificationDate = modificationDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPopulation(Long population) {
        this.population = population;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String toLine() {
        StringList buffer = new StringList(50);
        buffer.append(this.geoNameId);
        buffer.append('\t').append(this.name);
        buffer.append('\t').append(this.asciiName);
        buffer.append('\t').append(this.alternateNames.toStringList().toStringWithCommas());
        if (this.latitude == null) {
            buffer.append('\t');
        } else {
            buffer.append('\t').append(this.latitude);
        }
        if (this.longitude == null) {
            buffer.append('\t');
        } else {
            buffer.append('\t').append(this.longitude);
        }
        buffer.append('\t').append(this.featureClass.getCode());
        buffer.append('\t').append(this.featureCode);
        buffer.append('\t').append(this.countryCode);
        buffer.append('\t').append(this.alternateCountryCodes.toStringList().toStringWithCommas());
        buffer.append('\t').append(this.administrativeCode1);
        buffer.append('\t').append(this.administrativeCode2);
        buffer.append('\t').append(this.administrativeCode3);
        buffer.append('\t').append(this.administrativeCode4);
        if (this.population == null) {
            buffer.append('\t');
        } else {
            buffer.append('\t').append(this.population.longValue());
        }
        if (this.elevation == null) {
            buffer.append('\t');
        } else {
            buffer.append('\t').append(this.elevation.intValue());
        }
        if (this.dem == null) {
            buffer.append('\t');
        } else {
            buffer.append('\t').append(this.dem.intValue());
        }
        buffer.append('\t').append(this.timeZone);
        buffer.append('\t').append(this.modificationDate);
        String result = buffer.toString();
        return result;
    }
}

