/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.GeoNamesLineParser;
import org.tip.flatdb4geonames.model.GeoNamesLines;
import org.tip.flatdb4geonames.model.GeoNamesSearchCriteria;
import org.tip.flatdb4geonames.model.index.AdministrativePath;
import org.tip.flatdb4geonames.model.index.FeatureClass;
import org.tip.flatdb4geonames.model.index.IndexOfAdministrativePaths;
import org.tip.flatdb4geonames.model.index.IndexOfFeatures;
import org.tip.flatdb4geonames.model.index.IndexOfIdSeek;
import org.tip.flatdb4geonames.model.index.IndexOfWordSeeks;
import org.tip.flatdb4geonames.model.index.IndexOfWordSeeksBuilder;
import org.tip.flatdb4geonames.util.StringLengthComparator;

public class GeoNamesFlatDatabase {
    private static Logger logger = LoggerFactory.getLogger(GeoNamesFlatDatabase.class);
    public static final String GEONAMES_DUMP_REPOSITORY = "http://download.geonames.org/export/dump/";
    public static final String GEONAMES_MAIN_FILENAME = "allCountries.txt";
    public static final String GEONAMES_FEATURES_FILE = "featureCodes_en.txt";
    public static final String GEONAMES_ADMINISTRATIVE_CODE1_FILE = "admin1CodesASCII.txt";
    public static final String GEONAMES_ADMINISTRATIVE_CODE2_FILE = "admin2Codes.txt";
    private File repository;
    private IndexOfIdSeek indexOfIdSeek;
    private IndexOfWordSeeks indexOfWordSeeks;
    private IndexOfFeatures indexOfFeatures;
    private IndexOfAdministrativePaths indexOfAdministrativePaths;

    public GeoNamesFlatDatabase(File repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException("Bad repository (null).");
        }
        if (!repository.exists()) {
            throw new IllegalArgumentException("Bad repository (not existing) " + repository.getAbsolutePath());
        }
        if (!repository.isDirectory()) {
            throw new IllegalArgumentException("Bad repository (not directory) " + repository.getAbsolutePath());
        }
        if (!repository.canRead()) {
            throw new IllegalArgumentException("Bad repository (not readable) " + repository.getAbsolutePath());
        }
        this.repository = repository;
        this.open();
    }

    public void close() {
        this.indexOfIdSeek.close();
        this.indexOfIdSeek = null;
        this.indexOfWordSeeks.close();
        this.indexOfWordSeeks = null;
        this.indexOfFeatures.clear();
        this.indexOfFeatures = null;
        this.indexOfAdministrativePaths.clear();
        this.indexOfAdministrativePaths = null;
    }

    public File getRepository() {
        return this.repository;
    }

    public void open() throws IOException {
        if (this.repository == null || !this.repository.isDirectory()) {
            throw new IllegalArgumentException("Bad repository.");
        }
        File geonamesFile = new File(this.repository.getAbsoluteFile() + File.separator + GEONAMES_MAIN_FILENAME);
        logger.debug("memory={} Mo", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        this.indexOfFeatures = new IndexOfFeatures(new File(this.repository.getAbsoluteFile() + File.separator + GEONAMES_FEATURES_FILE));
        logger.debug("memory={} Mo", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        this.indexOfIdSeek = new IndexOfIdSeek(geonamesFile, this.repository);
        this.indexOfWordSeeks = new IndexOfWordSeeks(geonamesFile, this.repository);
        logger.debug("memory={} Mo", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        this.indexOfAdministrativePaths = new IndexOfAdministrativePaths(new File(this.repository.getAbsoluteFile() + File.separator + GEONAMES_ADMINISTRATIVE_CODE1_FILE), new File(this.repository.getAbsoluteFile() + File.separator + GEONAMES_ADMINISTRATIVE_CODE2_FILE));
    }

    public GeoNamesLines search(GeoNamesSearchCriteria criteria) throws IOException, FlatDB4GeoNamesException {
        GeoNamesLines result;
        if (criteria == null) {
            result = new GeoNamesLines();
        } else if (NumberUtils.isDigits((String)criteria.getInput())) {
            result = new GeoNamesLines();
            GeoNamesLine line = this.searchByGeoNameId(Integer.parseInt(criteria.getInput()));
            if (line != null) {
                result.add(line);
            }
        } else {
            String[] toponyms = criteria.getInput().split(",");
            if (toponyms.length == 1) {
                result = this.searchBySingleInput(criteria);
            } else {
                result = new GeoNamesLines();
                HashSet<Long> index = new HashSet<Long>();
                GeoNamesSearchCriteria subCriteria = new GeoNamesSearchCriteria(criteria);
                String[] stringArray = toponyms;
                int n = toponyms.length;
                int n2 = 0;
                while (n2 < n) {
                    String toponym = stringArray[n2];
                    logger.debug("sub=[{}]", (Object)toponym);
                    subCriteria.setInput(toponym);
                    GeoNamesLines subResult = this.searchBySingleInput(subCriteria);
                    for (GeoNamesLine line : subResult) {
                        if (index.contains(line.getGeoNameId())) continue;
                        result.add(line);
                        index.add(line.getGeoNameId());
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    public GeoNamesLines search(String input) throws IOException, FlatDB4GeoNamesException {
        GeoNamesLines result;
        if (input == null) {
            result = new GeoNamesLines();
        } else {
            GeoNamesSearchCriteria criteria = new GeoNamesSearchCriteria();
            criteria.setSearchMode(GeoNamesSearchCriteria.SearchMode.PART_MATCH);
            criteria.setContinentScope(GeoNamesSearchCriteria.Continent.ALL);
            criteria.setInput(input);
            result = this.search(criteria);
        }
        return result;
    }

    public GeoNamesLines search(String input, FeatureClass ... featureClasses) throws IOException, FlatDB4GeoNamesException {
        GeoNamesLines result;
        if (input == null) {
            result = new GeoNamesLines();
        } else {
            GeoNamesSearchCriteria criteria = new GeoNamesSearchCriteria();
            criteria.setSearchMode(GeoNamesSearchCriteria.SearchMode.PART_MATCH);
            criteria.featureClasses().addAll(featureClasses);
            criteria.setContinentScope(GeoNamesSearchCriteria.Continent.ALL);
            criteria.setInput(input);
            result = this.search(criteria);
        }
        return result;
    }

    public Integer searchAdministrativeGeoNameId(String administrativeCodePath) {
        AdministrativePath path = this.indexOfAdministrativePaths.get(administrativeCodePath);
        Integer result = path == null ? null : Integer.valueOf(path.getGeonameId());
        return result;
    }

    public Integer searchAdministrativeGeoNameId(String countryCode, String adminCode1, String adminCode2, String adminCode3, String adminCode4) {
        AdministrativePath path = this.indexOfAdministrativePaths.get(countryCode, adminCode1, adminCode2, adminCode3, adminCode4);
        Integer result = path == null ? null : Integer.valueOf(path.getGeonameId());
        return result;
    }

    public String searchAdministrativeToponym(String administrativeCodePath) {
        AdministrativePath path = this.indexOfAdministrativePaths.get(administrativeCodePath);
        String result = path == null ? null : path.getToponym();
        return result;
    }

    public String searchAdministrativeToponym(String countryCode, String adminCode1, String adminCode2, String adminCode3, String adminCode4) {
        AdministrativePath path = this.indexOfAdministrativePaths.get(countryCode, adminCode1, adminCode2, adminCode3, adminCode4);
        String result = path == null ? null : path.getToponym();
        return result;
    }

    public String searchAdministrativeToponymPath(String administrativeCodePath) {
        String result = this.indexOfAdministrativePaths.searchAdministrativeToponymPath(administrativeCodePath);
        return result;
    }

    public String searchAdministrativeToponymPath(String countryCode, String adminCode1, String adminCode2, String adminCode3, String adminCode4) {
        String result = this.indexOfAdministrativePaths.searchAdministrativeToponymPath(countryCode, adminCode1, adminCode2, adminCode3, adminCode4);
        return result;
    }

    public GeoNamesLine searchByAdministrativeCodePath(String administrativeCodePath) throws IOException, FlatDB4GeoNamesException {
        Integer geonameId = this.searchAdministrativeGeoNameId(administrativeCodePath);
        GeoNamesLine result = geonameId == null ? null : this.searchByGeoNameId(geonameId);
        return result;
    }

    public GeoNamesLine searchByAdministrativeCodePath(String countryCode, String adminCode1, String adminCode2, String adminCode3, String adminCode4) throws IOException, FlatDB4GeoNamesException {
        Integer geonameId = this.searchAdministrativeGeoNameId(countryCode, adminCode1, adminCode2, adminCode3, adminCode4);
        GeoNamesLine result = geonameId == null ? null : this.searchByGeoNameId(geonameId);
        return result;
    }

    public GeoNamesLine searchByGeoNameId(int geonameId) throws IOException, FlatDB4GeoNamesException {
        String line = this.indexOfIdSeek.get(geonameId);
        GeoNamesLine result = GeoNamesLineParser.parse(line);
        return result;
    }

    public GeoNamesLines searchBySingleInput(GeoNamesSearchCriteria criteria) throws IOException, FlatDB4GeoNamesException {
        GeoNamesLines result;
        if (criteria == null) {
            result = new GeoNamesLines();
        } else {
            StringList inputWords = IndexOfWordSeeksBuilder.nameToWords(criteria.getInput()).getSelection().toStringList();
            Collections.sort(inputWords, StringLengthComparator.instance());
            Collections.reverse(inputWords);
            logger.debug("inputWords={}", (Object)inputWords.toStringWithCommas());
            if (inputWords.isEmpty()) {
                result = new GeoNamesLines();
            } else {
                logger.debug("pivot word=" + (String)inputWords.get(0));
                result = this.searchByWord((String)inputWords.get(0));
                if (!criteria.featureClasses().isEmpty()) {
                    result = result.getByFeatureClasses(criteria.featureClasses());
                }
                if (inputWords.size() > 1) {
                    GeoNamesLines filteredResult = new GeoNamesLines();
                    inputWords.remove(0);
                    logger.debug("other input Words=" + inputWords.toStringWithCommas());
                    for (GeoNamesLine toponym : result) {
                        StringSet toponymNames = IndexOfWordSeeksBuilder.lineToNames(toponym);
                        StringSet toponymWords = IndexOfWordSeeksBuilder.namesToWords(toponymNames).getSelection();
                        if (!CollectionUtils.containsAll((Collection)toponymWords, (Collection)inputWords)) continue;
                        filteredResult.add(toponym);
                    }
                    result = filteredResult;
                }
            }
        }
        return result;
    }

    public GeoNamesLines searchByWord(String word) throws IOException, FlatDB4GeoNamesException {
        StringList lines = this.indexOfWordSeeks.get(word);
        GeoNamesLines result = GeoNamesLineParser.parse(lines);
        return result;
    }

    public String searchFeatureDescription(String featurePath) {
        String result = this.indexOfFeatures.getFeatureDescription(featurePath);
        return result;
    }

    public String searchFeatureDescription(String className, String code) {
        String result = this.indexOfFeatures.getFeatureDescription(className, code);
        return result;
    }

    public String searchFeatureDescriptionPath(String codePath) {
        String result = this.indexOfFeatures.getFeatureDescriptionPath(codePath);
        return result;
    }

    public String searchFeatureDescriptionPath(String className, String code) {
        String result = this.indexOfFeatures.getFeatureDescriptionPath(className, code);
        return result;
    }

    public String searchFeatureShortDescription(String codePath) {
        String result = this.indexOfFeatures.getFeatureShortDescription(codePath);
        return result;
    }

    public String searchFeatureShortDescription(String className, String code) {
        String result = this.indexOfFeatures.getFeatureShortDescription(className, code);
        return result;
    }

    public String searchRawLineByGeoNameId(int geonameId) throws IOException {
        String result = this.indexOfIdSeek.get(geonameId);
        return result;
    }

    public String searchRawLineByGeoNameId(String geonameId) throws IOException {
        String result = NumberUtils.isDigits((String)geonameId) ? this.searchRawLineByGeoNameId(Integer.parseInt(geonameId)) : null;
        return result;
    }

    public StringList searchRawLineByWord(String word) throws IOException {
        StringList result = this.indexOfWordSeeks.get(word);
        return result;
    }
}

