/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.GeoNamesFlatDatabase;
import org.tip.flatdb4geonames.model.index.IndexOfIdSeekBuilder;
import org.tip.flatdb4geonames.model.index.IndexOfWordSeeksBuilder;
import org.tip.flatdb4geonames.util.Downloader;
import org.tip.flatdb4geonames.util.Unzipper;

public class FlatDB4GeoNamesFactory {
    private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNamesFactory.class);
    public static final String GEONAMES_DUMP_REPOSITORY = "http://download.geonames.org/export/dump/";
    public static final String DEFAULT_DATABASE_FILE = "FlatDB4GeoNames-database.zip";

    public static void buildIndex(File localRepository) throws IOException {
        logger.debug("Build index start...");
        File geonamesFile = new File(localRepository.getAbsoluteFile() + File.separator + "allCountries.txt");
        IndexOfWordSeeksBuilder.buildIndex(geonamesFile, localRepository, 2000000, 40);
        IndexOfIdSeekBuilder.buildIndex(geonamesFile, localRepository, 2000000, 11);
        logger.debug("Build index done.");
    }

    public static void close(GeoNamesFlatDatabase database) {
        if (database != null) {
            database.close();
        }
    }

    public static void create(File localTargetDirectory) throws IOException {
        FlatDB4GeoNamesFactory.downloadGeoNamesFiles(localTargetDirectory);
        FlatDB4GeoNamesFactory.buildIndex(localTargetDirectory);
    }

    public static void downloadDatabase(String sourceRepositoryUrl, File localTargetRepository) throws IOException {
        if (StringUtils.isBlank((CharSequence)sourceRepositoryUrl) || localTargetRepository == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        String sourceUrl = sourceRepositoryUrl.endsWith("/") ? sourceRepositoryUrl : String.valueOf(sourceRepositoryUrl) + "/";
        File target = Downloader.download(String.valueOf(sourceUrl) + DEFAULT_DATABASE_FILE, localTargetRepository);
        Unzipper.unzip(target, localTargetRepository);
        boolean deleteStatus = target.delete();
        if (!deleteStatus) {
            logger.error("Failed to delete file [{}]", (Object)target.getAbsolutePath());
        }
    }

    public static void downloadGeoNamesFiles(File localTargetRepository) throws IOException {
        FlatDB4GeoNamesFactory.downloadGeoNamesFiles(GEONAMES_DUMP_REPOSITORY, localTargetRepository);
    }

    public static void downloadGeoNamesFiles(String sourceRepositoryUrl, File localTargetRepository) throws IOException {
        if (StringUtils.isBlank((CharSequence)sourceRepositoryUrl) || localTargetRepository == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        if (!localTargetRepository.isDirectory()) {
            throw new IllegalArgumentException("Local target repository is not a directory.");
        }
        String sourceUrl = sourceRepositoryUrl.endsWith("/") ? sourceRepositoryUrl : String.valueOf(sourceRepositoryUrl) + "/";
        File target = Downloader.download(String.valueOf(sourceUrl) + "allCountries.zip", localTargetRepository);
        Unzipper.unzip(target, localTargetRepository);
        boolean deleteStatus = target.delete();
        if (!deleteStatus) {
            logger.error("Failed to delete file [{}]", (Object)target.getAbsolutePath());
        }
        Downloader.download(String.valueOf(sourceUrl) + "featureCodes_en.txt", localTargetRepository);
        Downloader.download(String.valueOf(sourceUrl) + "admin1CodesASCII.txt", localTargetRepository);
        Downloader.download(String.valueOf(sourceUrl) + "admin2Codes.txt", localTargetRepository);
        FileUtils.copyURLToFile((URL)FlatDB4GeoNamesFactory.class.getResource("/org/tip/flatdb4geonames/model/ressources/README"), (File)new File(localTargetRepository, "README"));
        FileUtils.copyURLToFile((URL)FlatDB4GeoNamesFactory.class.getResource("/org/tip/flatdb4geonames/model/ressources/LICENSE"), (File)new File(localTargetRepository, "LICENSE"));
    }

    public static boolean isValidDatabase(File directory) {
        boolean result;
        if (directory == null) {
            result = false;
        } else if (!directory.isDirectory()) {
            result = false;
        } else if (!directory.exists()) {
            result = false;
        } else {
            File mainFile = new File(directory.getAbsoluteFile() + File.separator + "allCountries.txt");
            File featuresFile = new File(directory.getAbsoluteFile() + File.separator + "featureCodes_en.txt");
            File index1File = new File(directory.getAbsoluteFile() + File.separator + "id_seek.index");
            File index2File = new File(directory.getAbsoluteFile() + File.separator + "id_seek.index");
            File index3File = new File(directory.getAbsoluteFile() + File.separator + "seeks.index");
            File index4File = new File(directory.getAbsoluteFile() + File.separator + "word_seek.index");
            File index5File = new File(directory.getAbsoluteFile() + File.separator + "admin2Codes.txt");
            if (!mainFile.exists() || !mainFile.isFile()) {
                logger.debug("Missing :" + mainFile.getAbsolutePath());
                result = false;
            } else if (!featuresFile.exists() || !featuresFile.isFile()) {
                logger.debug("Missing :" + featuresFile.getAbsolutePath());
                result = false;
            } else if (!index1File.exists() || !index1File.isFile()) {
                logger.debug("Missing :" + index1File.getAbsolutePath());
                result = false;
            } else if (!index2File.exists() || !index2File.isFile()) {
                logger.debug("Missing :" + index2File.getAbsolutePath());
                result = false;
            } else if (!index3File.exists() || !index3File.isFile()) {
                logger.debug("Missing :" + index3File.getAbsolutePath());
                result = false;
            } else if (!index4File.exists() || !index4File.isFile()) {
                logger.debug("Missing :" + index4File.getAbsolutePath());
                result = false;
            } else if (!index5File.exists() || !index5File.isFile()) {
                logger.debug("Missing :" + index4File.getAbsolutePath());
                result = false;
            } else {
                result = true;
            }
        }
        return result;
    }

    public static GeoNamesFlatDatabase open(File repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        GeoNamesFlatDatabase result = new GeoNamesFlatDatabase(repository);
        return result;
    }

    public static GeoNamesFlatDatabase open(String repository) throws IOException {
        GeoNamesFlatDatabase result = FlatDB4GeoNamesFactory.open(new File(repository));
        return result;
    }
}

