/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesFactory;
import org.tip.flatdb4geonames.model.GeoNamesFlatDatabase;

public class FlatDB4GeoNames {
    private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNames.class);
    private static GeoNamesFlatDatabase instance = null;

    public static void buildIndex(File localRepository) throws IOException {
        FlatDB4GeoNamesFactory.buildIndex(localRepository);
    }

    public static void close() {
        if (instance == null) {
            throw new IllegalStateException("None instance.");
        }
        instance.close();
        instance = null;
    }

    public static void downloadDatabase(String sourceRepositoryUrl, File localTargetRepository) throws IOException {
        FlatDB4GeoNamesFactory.downloadDatabase(sourceRepositoryUrl, localTargetRepository);
    }

    public static void downloadGeoNamesFiles(File localTargetRepository) throws IOException {
        FlatDB4GeoNamesFactory.downloadGeoNamesFiles(localTargetRepository);
    }

    public static void downloadGeoNamesFiles(String sourceRepositoryUrl, File localTargetRepository) throws IOException {
        FlatDB4GeoNamesFactory.downloadGeoNamesFiles(sourceRepositoryUrl, localTargetRepository);
    }

    public static GeoNamesFlatDatabase instance() {
        GeoNamesFlatDatabase result = instance;
        return result;
    }

    public static boolean isOpened() {
        boolean result = instance != null;
        return result;
    }

    public static boolean isValidDatabase(File directory) {
        boolean result = FlatDB4GeoNamesFactory.isValidDatabase(directory);
        return result;
    }

    public static GeoNamesFlatDatabase open(File repository) throws IOException {
        if (instance != null) {
            FlatDB4GeoNames.close();
        }
        GeoNamesFlatDatabase result = instance = FlatDB4GeoNamesFactory.open(repository);
        return result;
    }

    public static GeoNamesFlatDatabase open(String repository) throws IOException {
        GeoNamesFlatDatabase result = instance = FlatDB4GeoNamesFactory.open(repository);
        return result;
    }
}

