/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.gui.views.buildindexes;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.gui.views.buildindexes.BuildIndexesSourceSelector;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesFactory;
import org.tip.flatdb4geonames.util.Chronometer;

public class BuildIndexesDialog
extends JDialog {
    private static final long serialVersionUID = 2320545249835089493L;
    private static Logger logger = LoggerFactory.getLogger(BuildIndexesDialog.class);
    private final JPanel contentPanel = new JPanel();
    private JTextField txtfldSourceDirectory;
    private JTextField txtfldFreeDiskSpace;
    private JButton btnBuild;
    private JButton btnCancel;
    private JLabel lblAllCountriesTxtValue;
    private JLabel lblFeatureCodeEnTxtValue;
    private SwingWorker<Boolean, Integer> buildWorker;
    private SwingWorker<Boolean, Integer> progressWorker;
    private JButton btnDone;
    private JProgressBar progressBarIdSeekIndex;
    private JProgressBar progressBarSeeksIndex;
    private JProgressBar progressBarWordSeekIndex;
    private Chronometer chrono;
    private JLabel lblTimer;
    private JButton btnSelector;
    private JProgressBar progressBarGlobal;

    public BuildIndexesDialog() {
        this.setModal(true);
        this.setTitle("Build Indexes");
        this.setBounds(100, 100, 630, 445);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        JPanel introPanel = new JPanel();
        this.contentPanel.add(introPanel);
        JLabel lblNewLabel = new JLabel("<html>\nThe main GeoNames file takes 1.2GB and contains more than 10 million of entries.<br/>\nTo increase request performance, FlatDB4GeoNames build indexes<br/>\nto reach faster GeoNames data by geonameId and words.<br/>\nThis Panel allows you to build these indexes.\n</html>");
        introPanel.add(lblNewLabel);
        Component verticalStrut = Box.createVerticalStrut(10);
        this.contentPanel.add(verticalStrut);
        JPanel inputPanel = new JPanel();
        this.contentPanel.add(inputPanel);
        inputPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSource = new JLabel("Source directory:");
        inputPanel.add((Component)lblSource, "2, 2, right, default");
        this.txtfldSourceDirectory = new JTextField();
        this.txtfldSourceDirectory.setEditable(false);
        inputPanel.add((Component)this.txtfldSourceDirectory, "4, 2, fill, default");
        this.txtfldSourceDirectory.setColumns(10);
        this.btnSelector = new JButton("...");
        this.btnSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File target = BuildIndexesSourceSelector.showSelectorDialog(null, null);
                if (target != null) {
                    BuildIndexesDialog.this.setSourceDirectory(target);
                }
            }
        });
        inputPanel.add((Component)this.btnSelector, "6, 2");
        JLabel lblAllCountriesTxt = new JLabel("allCountries.txt:");
        inputPanel.add((Component)lblAllCountriesTxt, "2, 4, right, default");
        this.lblAllCountriesTxtValue = new JLabel("missing");
        inputPanel.add((Component)this.lblAllCountriesTxtValue, "4, 4, center, default");
        JLabel lblFeatureCodesEnTxt = new JLabel("featureCodes_en.txt:");
        inputPanel.add((Component)lblFeatureCodesEnTxt, "2, 6");
        this.lblFeatureCodeEnTxtValue = new JLabel("missing");
        inputPanel.add((Component)this.lblFeatureCodeEnTxtValue, "4, 6, center, default");
        JLabel lblSpaceDisk = new JLabel("Free disk space:");
        inputPanel.add((Component)lblSpaceDisk, "2, 8, right, default");
        this.txtfldFreeDiskSpace = new JTextField();
        this.txtfldFreeDiskSpace.setEditable(false);
        this.txtfldFreeDiskSpace.setHorizontalAlignment(4);
        inputPanel.add((Component)this.txtfldFreeDiskSpace, "4, 8, fill, default");
        this.txtfldFreeDiskSpace.setColumns(10);
        this.progressBarGlobal = new JProgressBar();
        inputPanel.add((Component)this.progressBarGlobal, "4, 12");
        JLabel lblNewLabel1 = new JLabel("word_seek.index:");
        inputPanel.add((Component)lblNewLabel1, "2, 14, right, default");
        this.progressBarWordSeekIndex = new JProgressBar();
        inputPanel.add((Component)this.progressBarWordSeekIndex, "4, 14");
        JLabel lblSeeksIndex = new JLabel("seeks.index:");
        inputPanel.add((Component)lblSeeksIndex, "2, 16, right, default");
        this.progressBarSeeksIndex = new JProgressBar();
        inputPanel.add((Component)this.progressBarSeeksIndex, "4, 16");
        JLabel lblIdSeekIndex = new JLabel("id_seek.index:");
        inputPanel.add((Component)lblIdSeekIndex, "2, 18, right, default");
        this.progressBarIdSeekIndex = new JProgressBar();
        inputPanel.add((Component)this.progressBarIdSeekIndex, "4, 18");
        this.lblTimer = new JLabel("00:00:00");
        inputPanel.add((Component)this.lblTimer, "4, 21, center, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (BuildIndexesDialog.this.buildWorker != null) {
                    BuildIndexesDialog.this.buildWorker.cancel(true);
                }
                if (BuildIndexesDialog.this.progressWorker != null) {
                    BuildIndexesDialog.this.progressWorker.cancel(true);
                }
                if (BuildIndexesDialog.this.buildWorker != null && BuildIndexesDialog.this.progressWorker != null) {
                    BuildIndexesDialog.this.clearTarget(BuildIndexesDialog.this.txtfldSourceDirectory.getText());
                }
                BuildIndexesDialog.this.dispose();
            }
        });
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnBuild = new JButton("Build");
        this.btnBuild.setEnabled(false);
        this.btnBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BuildIndexesDialog.this.btnBuild.setEnabled(false);
                BuildIndexesDialog.this.btnSelector.setEnabled(false);
                final String targetDirectory = BuildIndexesDialog.this.txtfldSourceDirectory.getText();
                BuildIndexesDialog.this.chrono = new Chronometer();
                BuildIndexesDialog.this.buildWorker = new SwingWorker<Boolean, Integer>(){

                    @Override
                    protected Boolean doInBackground() {
                        Boolean result;
                        try {
                            BuildIndexesDialog.this.clearTarget(targetDirectory);
                            FlatDB4GeoNamesFactory.buildIndex(new File(targetDirectory));
                            result = true;
                        }
                        catch (FileNotFoundException exception) {
                            exception.printStackTrace();
                            logger.error("Technical problem detected (1).", (Throwable)exception);
                            String title = "Error";
                            String message = "File not found: " + exception.getMessage();
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            result = false;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            logger.error("Technical problem detected (2).", (Throwable)exception);
                            String title = "Error";
                            String message = "Download error: " + exception.getMessage();
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            result = false;
                        }
                        return result;
                    }

                    @Override
                    protected void done() {
                        logger.debug("build index progress done");
                        BuildIndexesDialog.this.btnCancel.setEnabled(false);
                        BuildIndexesDialog.this.btnBuild.setEnabled(false);
                        BuildIndexesDialog.this.btnDone.setEnabled(true);
                        BuildIndexesDialog.this.progressWorker.cancel(true);
                        BuildIndexesDialog.this.progressBarGlobal.setValue(100);
                        BuildIndexesDialog.this.progressBarIdSeekIndex.setValue(100);
                        BuildIndexesDialog.this.progressBarSeeksIndex.setValue(100);
                        BuildIndexesDialog.this.progressBarWordSeekIndex.setValue(100);
                    }
                };
                BuildIndexesDialog.this.buildWorker.execute();
                BuildIndexesDialog.this.progressWorker = new SwingWorker<Boolean, Integer>(){

                    @Override
                    protected Boolean doInBackground() throws InterruptedException {
                        boolean ended = false;
                        while (!ended) {
                            Thread.sleep(1000L);
                            this.publish(new Integer[0]);
                        }
                        return true;
                    }

                    @Override
                    protected void done() {
                        logger.debug("progressworker done");
                    }

                    @Override
                    protected void process(List<Integer> chunks) {
                        BuildIndexesDialog.this.updateFreeDiskSpace();
                        if (new File(targetDirectory, "id_seek.index").exists()) {
                            BuildIndexesDialog.this.progressBarIdSeekIndex.setValue(100);
                        }
                        if (new File(targetDirectory, "seeks.index").exists()) {
                            BuildIndexesDialog.this.progressBarSeeksIndex.setValue(100);
                        }
                        if (new File(targetDirectory, "word_seek.index").exists()) {
                            BuildIndexesDialog.this.progressBarWordSeekIndex.setValue(100);
                        }
                        long duration = BuildIndexesDialog.this.chrono.stop().interval();
                        BuildIndexesDialog.this.progressBarGlobal.setValue((int)(duration * 100L / 1500000L));
                        String timerValue = Chronometer.toTimer(duration);
                        BuildIndexesDialog.this.lblTimer.setText(timerValue);
                    }
                };
                BuildIndexesDialog.this.progressWorker.execute();
            }
        });
        this.btnBuild.setActionCommand("OK");
        buttonPane.add(this.btnBuild);
        this.getRootPane().setDefaultButton(this.btnBuild);
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnDone = new JButton("Done");
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BuildIndexesDialog.this.dispose();
            }
        });
        this.btnDone.setEnabled(false);
        this.btnDone.setActionCommand("OK");
        buttonPane.add(this.btnDone);
    }

    public void clearTarget(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            new File(path, "id_seek.index").delete();
            new File(path, "seeks.index").delete();
            new File(path, "word_seek.index").delete();
            new File(path, "word_seeks.index.rejection").delete();
        }
    }

    public void setSourceDirectory(File target) {
        if (target != null && target.exists() && target.isDirectory()) {
            if (target.canWrite()) {
                this.txtfldSourceDirectory.setText(target.getAbsolutePath());
                String value = String.format("%,dMB", target.getUsableSpace() / 1024L / 1024L);
                this.txtfldFreeDiskSpace.setText(value);
                File allCountriesFile = new File(target + File.separator + "allCountries.txt");
                File featureCodesFile = new File(target + File.separator + "featureCodes_en.txt");
                if (allCountriesFile.exists()) {
                    this.lblAllCountriesTxtValue.setText("found");
                } else {
                    this.lblAllCountriesTxtValue.setText("missing");
                }
                if (featureCodesFile.exists()) {
                    this.lblFeatureCodeEnTxtValue.setText("found");
                } else {
                    this.lblFeatureCodeEnTxtValue.setText("missing");
                }
                if (allCountriesFile.exists() && featureCodesFile.exists()) {
                    this.btnBuild.setEnabled(true);
                } else {
                    String title = "Warning";
                    String message = "One GeoNames file is missing. Please restart download.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            } else {
                String title = "Warning";
                String message = "This directory is not writable.";
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
        }
    }

    public void updateFreeDiskSpace() {
        String value = String.format("%,dMB", new File(this.txtfldSourceDirectory.getText()).getUsableSpace() / 1024L / 1024L);
        this.txtfldFreeDiskSpace.setText(value);
    }

    public static void main(String[] args) {
        try {
            new BuildIndexesDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showDialog() {
        BuildIndexesDialog.showDialog(null);
    }

    public static void showDialog(Component parent) {
        BuildIndexesDialog dialog = new BuildIndexesDialog();
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }
}

