/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.swing.downloaddatabase;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTargetSelector
extends JFileChooser {
    private static final long serialVersionUID = 6910915335171754463L;
    private static Logger logger = LoggerFactory.getLogger(DownloadTargetSelector.class);

    public DownloadTargetSelector(File targetFile) {
        File file = targetFile == null || StringUtils.isBlank((CharSequence)targetFile.getAbsolutePath()) ? null : (targetFile.isFile() ? targetFile.getParentFile() : targetFile);
        this.setSelectedFile(file);
        this.setDialogTitle("Download directory");
        this.setFileSelectionMode(1);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Select");
        this.setDialogType(2);
    }

    @Override
    public void approveSelection() {
        File targetFile = this.getSelectedFile();
        logger.debug("getCurrentDirectory(): {}", (Object)this.getCurrentDirectory());
        logger.debug("selectedFile={}", (Object)targetFile);
        super.approveSelection();
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        logger.info("SELECED FILE {}", (Object)file);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.resetChoosableFileFilters();
        }
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        DownloadTargetSelector selector = new DownloadTargetSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

