/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.workers;

import fr.devinsy.util.StringList;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.workers.StatisticsWorker;
import org.tip.flatdb4geonames.util.StringLongPair;
import org.tip.flatdb4geonames.util.StringLongPairs;

public class StatisticsReporter {
    private static Logger logger = LoggerFactory.getLogger(StatisticsReporter.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static StringList reportLongestWords(int maxLineCount) throws IOException {
        StringLongPairs data = StatisticsWorker.censusLongestWords(maxLineCount);
        StringList result = new StringList();
        result.append("<H1>LONGEST WORS</H1>");
        result.append("<p>maxLineCount=").append(maxLineCount).appendln("</p>");
        result.appendln("<p>");
        result.appendln("<table class=\"table_default\">");
        result.appendln("  <tr>");
        result.appendln("    <th>Nr.</th>");
        result.appendln("    <th>Word</th>");
        result.appendln("    <th>Length</th>");
        result.appendln("    <th>Count</th>");
        result.appendln("  </tr>");
        int lineCount = 0;
        for (StringLongPair pair : data) {
            result.appendln("  <tr>");
            result.append("    <td class=\"center\">").append(++lineCount).appendln("</td>");
            result.append("    <td class=\"left\">").append(pair.getString()).appendln("</td>");
            result.append("    <td class=\"center\">").append(pair.getLong().longValue()).appendln("</td>");
            result.append("    <td class=\"center\">").append(pair.getCount()).appendln("</td>");
            result.appendln("  </tr>");
        }
        result.appendln("</table>");
        result.appendln("</p>");
        return result;
    }

    public static StringList reportWordMatching(int maxLineCount) throws IOException {
        StringLongPairs data = StatisticsWorker.censusWordMatching(maxLineCount);
        StringList result = new StringList();
        result.append("<H1>WORD MATCHING</H1>");
        result.append("<p>maxLineCount=").append(maxLineCount).appendln("</p>");
        result.appendln("<p>");
        result.appendln("<table class=\"table_default\">");
        result.appendln("  <tr>");
        result.appendln("    <th>Nr.</th>");
        result.appendln("    <th>Word</th>");
        result.appendln("    <th>Matching</th>");
        result.appendln("  </tr>");
        int lineCount = 0;
        for (StringLongPair pair : data) {
            result.appendln("  <tr>");
            result.append("    <td class=\"center\">").append(++lineCount).appendln("</td>");
            result.append("    <td class=\"left\">").append(pair.getString()).appendln("</td>");
            result.append("    <td class=\"center\">").append(pair.getLong().longValue()).appendln("</td>");
            result.appendln("  </tr>");
        }
        result.appendln("</table>");
        result.appendln("</p>");
        return result;
    }
}

