/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import fr.devinsy.util.StringList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.util.Chronometer;

public class IndexOfWordSeeks {
    private static Logger logger = LoggerFactory.getLogger(IndexOfWordSeeks.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private RandomAccessFile data;
    private RandomAccessFile index1;
    private RandomAccessFile index2;
    private int index2LineLength;

    public IndexOfWordSeeks(File dataFile, File repository) throws IOException {
        if (dataFile == null || repository == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        this.data = new RandomAccessFile(dataFile, "r");
        File index1File = new File(repository.getAbsoluteFile() + File.separator + "seeks.index");
        this.index1 = new RandomAccessFile(index1File, "r");
        File index2File = new File(repository.getAbsoluteFile() + File.separator + "word_seek.index");
        this.index2 = new RandomAccessFile(index2File, "r");
        this.index2.seek(0L);
        this.index2LineLength = IndexOfWordSeeks.readUTFLineLength(this.index2) + 1;
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)this.data);
        IOUtils.closeQuietly((Closeable)this.index1);
        IOUtils.closeQuietly((Closeable)this.index2);
    }

    public StringList get(String word) throws IOException {
        Long seek;
        StringList result = new StringList();
        if (word != null && (seek = this.getSeek(word)) != null) {
            this.index1.seek(seek);
            String indexLine = this.index1.readLine();
            String[] stringArray = indexLine.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String seekString = stringArray[n2];
                long dataSeek = Long.parseLong(seekString);
                this.data.seek(dataSeek);
                String line = IndexOfWordSeeks.readUTFLine(this.data);
                result.add((Object)line);
                ++n2;
            }
        }
        return result;
    }

    public String getIndex2Line(long lineIndex) throws IOException {
        this.index2.seek(lineIndex * (long)this.index2LineLength);
        String result = IndexOfWordSeeks.readUTFLine(this.index2, this.index2LineLength - 1);
        return result;
    }

    public Long getSeek(String word) throws IOException {
        long min = 0L;
        long max = this.index2LineCount() - 1L;
        boolean ended = false;
        int stepCount = 0;
        Chronometer chrono = new Chronometer();
        Long result = null;
        while (!ended) {
            ++stepCount;
            long dicho = (max + min) / 2L;
            if (dicho < min) {
                ended = true;
                result = null;
                continue;
            }
            String line = this.getIndex2Line(dicho);
            String candidate = line.split("\t")[0];
            logger.debug("{}\t{}\t{}\t{}\t[{}]", new Object[]{stepCount, min, max, dicho, candidate});
            if (word.compareTo(candidate) < 0) {
                max = dicho - 1L;
                continue;
            }
            if (word.compareTo(candidate) > 0) {
                min = dicho + 1L;
                continue;
            }
            ended = true;
            result = new Long(line.split("\t")[1].trim());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("result={}\ttime={}\tstepCount={}", new Object[]{result, Chronometer.toHumanString(chrono.stop().interval()), stepCount});
        }
        return result;
    }

    private long index2LineCount() throws IOException {
        long result = this.index2.length() / (long)this.index2LineLength;
        return result;
    }

    public static String readUTFLine(RandomAccessFile in) throws IOException {
        String result = IndexOfWordSeeks.readUTFLine(in, IndexOfWordSeeks.readUTFLineLength(in));
        return result;
    }

    public static String readUTFLine(RandomAccessFile in, int lineLength) throws IOException {
        byte[] buffer = new byte[lineLength];
        in.read(buffer);
        String result = Charset.forName("utf-8").decode(ByteBuffer.wrap(buffer)).toString();
        return result;
    }

    public static int readUTFLineLength(RandomAccessFile in) throws IOException {
        long currentSeek = in.getFilePointer();
        int result = 0;
        boolean ended = false;
        while (!ended) {
            int value = in.read();
            switch (value) {
                case -1: 
                case 10: 
                case 13: {
                    ended = true;
                    break;
                }
                default: {
                    ++result;
                }
            }
        }
        in.seek(currentSeek);
        return result;
    }
}

