/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexOfHierarchy {
    private static Logger logger = LoggerFactory.getLogger(IndexOfHierarchy.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private Map<Integer, Integer> index = new HashMap<Integer, Integer>();

    public IndexOfHierarchy(File source) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), DEFAULT_CHARSET_NAME));
            int lineCount = 0;
            boolean ended = false;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                String[] tokens = line.split("\t");
                if (tokens.length != 3) continue;
                String parent = tokens[0];
                String child = tokens[1];
                String relation = tokens[2];
                if (!StringUtils.equals((CharSequence)relation, (CharSequence)"ADM")) continue;
                this.index.put(Integer.valueOf(child), Integer.valueOf(parent));
            }
            logger.debug("count line=" + lineCount);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
    }

    public void clear() {
        this.index.clear();
    }

    public Integer get(Integer geonameId) {
        Integer result = this.index.get(geonameId);
        return result;
    }

    public Integer get(String geonameId) {
        Integer result = this.get(Integer.valueOf(geonameId));
        return result;
    }

    public int size() {
        int result = this.index.size();
        return result;
    }
}

