/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import fr.devinsy.util.StringSet;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.index.Feature;

public class Features
extends ArrayList<Feature> {
    private static final long serialVersionUID = -8546831996283740924L;
    private static Logger logger = LoggerFactory.getLogger(Features.class);

    public Features() {
    }

    public Features(Features source) {
        super(source.size());
        for (Feature feature : source) {
            this.add(feature);
        }
    }

    public Features(int capacity) {
        super(capacity);
    }

    public Feature get(String featureClassCode, String featureCode) {
        Feature result;
        if (StringUtils.isBlank((CharSequence)featureClassCode) || StringUtils.isBlank((CharSequence)featureCode)) {
            result = null;
        } else {
            boolean ended = false;
            int index = 0;
            result = null;
            while (!ended) {
                if (index < this.size()) {
                    Feature feature = (Feature)this.get(index);
                    if (feature.getFeatureClassCode().equals(featureClassCode) && feature.getFeatureCode().equals(featureCode)) {
                        ended = true;
                        result = feature;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = null;
            }
        }
        return result;
    }

    public Features getByFeatureClass(String featureClassCode) {
        Features result = new Features();
        for (Feature feature : this) {
            if (feature.getFeatureClassCode() != featureClassCode) continue;
            result.add(feature);
        }
        return result;
    }

    public StringSet getFeatureClassCodes() {
        StringSet result = new StringSet();
        for (Feature feature : this) {
            result.add(feature.getFeatureClassCode());
        }
        return result;
    }

    public StringSet getFeatureCodes() {
        StringSet result = new StringSet();
        for (Feature feature : this) {
            result.add(feature.getFeatureCode());
        }
        return result;
    }
}

