/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import java.io.IOException;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.GeoNamesLines;
import org.tip.flatdb4geonames.model.index.FeatureClass;
import org.tip.flatdb4geonames.util.Chronometer;

public class FlatDB4GeoNamesTest {
    private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNamesTest.class);
    public static final String DATABASE_HOME = "data/";

    @Test
    public void test0() throws IOException, FlatDB4GeoNamesException {
        FlatDB4GeoNames.open(DATABASE_HOME);
        String result = FlatDB4GeoNames.instance().searchFeatureDescriptionPath("US.NC.157");
        System.out.println("=>" + result);
    }

    @Test
    public void test1() throws IOException, FlatDB4GeoNamesException {
        FlatDB4GeoNames.open(DATABASE_HOME);
        GeoNamesLines lines = FlatDB4GeoNames.instance().search("Massy", FeatureClass.CITY_VILLAGE);
        Assertions.assertThat((List)lines).isNotNull();
        Assertions.assertThat((boolean)lines.containsGeoNameId(2995206L)).isTrue();
        Assertions.assertThat((boolean)lines.containsGeoNameId(3002895L)).isTrue();
    }

    @Test
    public void test2() throws IOException, FlatDB4GeoNamesException {
        FlatDB4GeoNames.open(DATABASE_HOME);
    }

    @Test
    public void test9() {
        try {
            FlatDB4GeoNames.open(DATABASE_HOME);
            Chronometer chrono = new Chronometer();
            GeoNamesLines lines = FlatDB4GeoNames.instance().search("Massy", FeatureClass.CITY_VILLAGE);
            for (GeoNamesLine line : lines) {
                System.out.println(line.toLine());
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (FlatDB4GeoNamesException exception) {
            exception.printStackTrace();
        }
    }

    @Test
    public void testFlatDB4GeoNames00() throws IOException, FlatDB4GeoNamesException {
        Runtime.getRuntime().gc();
        long a = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Used   memory= " + a / 1024L / 1024L);
        FlatDB4GeoNames.open(DATABASE_HOME);
        Runtime.getRuntime().gc();
        long b = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Used   memory= " + b / 1024L / 1024L);
        FlatDB4GeoNames.instance().close();
        Runtime.getRuntime().gc();
        long c = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Used   memory= " + c / 1024L / 1024L);
    }
}

