/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.gui.views.downloadgeonamesfiles;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.gui.views.downloadgeonamesfiles.DownloadGeoNamesFilesCriteria;
import org.tip.flatdb4geonames.gui.views.downloadgeonamesfiles.DownloadTargetSelector;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesFactory;
import org.tip.flatdb4geonames.util.Chronometer;

public class DownloadGeoNamesFilesDialog
extends JDialog {
    private static final long serialVersionUID = 2320545249835089493L;
    private static Logger logger = LoggerFactory.getLogger(DownloadGeoNamesFilesDialog.class);
    private final JPanel contentPanel = new JPanel();
    private JTextField txtfldTargetDirectory;
    private JTextField txtfldFreeDiskSpace;
    private JButton btnDownload;
    private JComboBox cmbxSourceRepository;
    private SwingWorker<Boolean, Integer> downloadWorker;
    private SwingWorker<Boolean, Integer> progressWorker;
    private JButton btnCancel;
    private JButton btnDone;
    private JProgressBar progressBarAllCountriesZip;
    private JProgressBar progressBarAllCountriesTxt;
    private JProgressBar progressBarFeatureCodesEnTxt;
    private JLabel lblAllCountriesZip;
    private JLabel lblAllCountriesTxt;
    private JLabel lblFeatureCodeEnTxt;
    private Chronometer chrono;
    private JLabel lblTimer;
    private JButton btnSelector;
    private JLabel lblAdmin1Codes;
    private JLabel lblAdmin2Codes;
    private JProgressBar progressBarAdmin1Codes;
    private JProgressBar progressBarAdmin2Codes;

    public DownloadGeoNamesFilesDialog() {
        this.setModal(true);
        this.setTitle("Download GeoNames dump files");
        this.setBounds(100, 100, 630, 450);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        JPanel introPanel = new JPanel();
        this.contentPanel.add(introPanel);
        JLabel lblNewLabel = new JLabel("<html>\nGeoNames provides official dump files.<br/>\nFlatDB4GeoNames requires some of them.<br/>\nThis panel will download them for you in the directory of your choice.\n</html>");
        introPanel.add(lblNewLabel);
        Component verticalStrut = Box.createVerticalStrut(10);
        this.contentPanel.add(verticalStrut);
        JPanel inputPanel = new JPanel();
        this.contentPanel.add(inputPanel);
        inputPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblSource = new JLabel("Source repository:");
        inputPanel.add((Component)lblSource, "2, 2, right, default");
        this.cmbxSourceRepository = new JComboBox();
        this.cmbxSourceRepository.setModel(new DefaultComboBoxModel<String>(new String[]{"http://download.geonames.org/export/dump/"}));
        inputPanel.add((Component)this.cmbxSourceRepository, "4, 2, fill, default");
        JLabel lblTarget = new JLabel("Target directory:");
        inputPanel.add((Component)lblTarget, "2, 4, right, default");
        this.txtfldTargetDirectory = new JTextField();
        this.txtfldTargetDirectory.setEditable(false);
        inputPanel.add((Component)this.txtfldTargetDirectory, "4, 4, fill, default");
        this.txtfldTargetDirectory.setColumns(10);
        this.btnSelector = new JButton("...");
        this.btnSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File target = DownloadTargetSelector.showSelectorDialog(null, null);
                if (target != null) {
                    DownloadGeoNamesFilesDialog.this.setTargetDirectory(target);
                }
            }
        });
        inputPanel.add((Component)this.btnSelector, "6, 4");
        JLabel lblSpaceDisk = new JLabel("Free disk space:");
        inputPanel.add((Component)lblSpaceDisk, "2, 6, right, default");
        this.txtfldFreeDiskSpace = new JTextField();
        this.txtfldFreeDiskSpace.setEditable(false);
        this.txtfldFreeDiskSpace.setHorizontalAlignment(4);
        inputPanel.add((Component)this.txtfldFreeDiskSpace, "4, 6, fill, default");
        this.txtfldFreeDiskSpace.setColumns(10);
        this.lblAllCountriesZip = new JLabel("allCountries.zip:");
        this.lblAllCountriesZip.setEnabled(false);
        inputPanel.add((Component)this.lblAllCountriesZip, "2, 12, right, default");
        this.progressBarAllCountriesZip = new JProgressBar();
        this.progressBarAllCountriesZip.setEnabled(false);
        inputPanel.add((Component)this.progressBarAllCountriesZip, "4, 12");
        this.lblAllCountriesTxt = new JLabel("unzip allCountries.zip:");
        this.lblAllCountriesTxt.setEnabled(false);
        inputPanel.add((Component)this.lblAllCountriesTxt, "2, 14, right, default");
        this.progressBarAllCountriesTxt = new JProgressBar();
        this.progressBarAllCountriesTxt.setEnabled(false);
        inputPanel.add((Component)this.progressBarAllCountriesTxt, "4, 14");
        this.lblFeatureCodeEnTxt = new JLabel("featureCodes_en.txt:");
        this.lblFeatureCodeEnTxt.setEnabled(false);
        inputPanel.add((Component)this.lblFeatureCodeEnTxt, "2, 16, right, default");
        this.progressBarFeatureCodesEnTxt = new JProgressBar();
        this.progressBarFeatureCodesEnTxt.setEnabled(false);
        inputPanel.add((Component)this.progressBarFeatureCodesEnTxt, "4, 16");
        this.lblAdmin1Codes = new JLabel("admin1CodesASCII.txt:");
        this.lblAdmin1Codes.setEnabled(false);
        inputPanel.add((Component)this.lblAdmin1Codes, "2, 18, right, default");
        this.progressBarAdmin1Codes = new JProgressBar();
        this.progressBarAdmin1Codes.setEnabled(false);
        inputPanel.add((Component)this.progressBarAdmin1Codes, "4, 18");
        this.lblAdmin2Codes = new JLabel("admin2Codes.txt:");
        this.lblAdmin2Codes.setEnabled(false);
        inputPanel.add((Component)this.lblAdmin2Codes, "2, 20, right, default");
        this.progressBarAdmin2Codes = new JProgressBar();
        this.progressBarAdmin2Codes.setEnabled(false);
        inputPanel.add((Component)this.progressBarAdmin2Codes, "4, 20");
        this.lblTimer = new JLabel("00:00:00");
        inputPanel.add((Component)this.lblTimer, "4, 23, center, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (DownloadGeoNamesFilesDialog.this.downloadWorker != null) {
                    DownloadGeoNamesFilesDialog.this.downloadWorker.cancel(true);
                }
                if (DownloadGeoNamesFilesDialog.this.progressWorker != null) {
                    DownloadGeoNamesFilesDialog.this.progressWorker.cancel(true);
                }
                DownloadGeoNamesFilesDialog.this.clearTarget(DownloadGeoNamesFilesDialog.this.txtfldTargetDirectory.getText());
                DownloadGeoNamesFilesDialog.this.dispose();
            }
        });
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnDownload = new JButton("Download");
        buttonPane.add(this.btnDownload);
        this.btnDownload.setEnabled(false);
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final DownloadGeoNamesFilesCriteria criteria = DownloadGeoNamesFilesDialog.this.getCriteria();
                try {
                    DownloadGeoNamesFilesDialog.this.updateFreeDiskSpace();
                    DownloadGeoNamesFilesDialog.this.btnDownload.setEnabled(false);
                    DownloadGeoNamesFilesDialog.this.btnSelector.setEnabled(false);
                    DownloadGeoNamesFilesDialog.this.lblAllCountriesZip.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.lblAllCountriesTxt.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.lblFeatureCodeEnTxt.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.lblAdmin1Codes.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.lblAdmin2Codes.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.progressBarAllCountriesZip.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.progressBarAllCountriesTxt.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.progressBarFeatureCodesEnTxt.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.progressBarAdmin1Codes.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.progressBarAdmin2Codes.setEnabled(true);
                    DownloadGeoNamesFilesDialog.this.chrono = new Chronometer();
                    DownloadGeoNamesFilesDialog.this.downloadWorker = new SwingWorker<Boolean, Integer>(){

                        @Override
                        protected Boolean doInBackground() {
                            Boolean result;
                            try {
                                DownloadGeoNamesFilesDialog.this.clearTarget(criteria.getTargetDirectory());
                                File targetFile = new File(criteria.getTargetDirectory());
                                FlatDB4GeoNamesFactory.downloadGeoNamesFiles(criteria.getSourceRepository(), targetFile);
                                result = true;
                            }
                            catch (FileNotFoundException exception) {
                                exception.printStackTrace();
                                String title = "Error";
                                String message = "File not found: " + exception.getMessage();
                                JOptionPane.showMessageDialog(null, message, title, 0);
                                result = false;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                String title = "Error";
                                String message = "Download error: " + exception.getMessage();
                                JOptionPane.showMessageDialog(null, message, title, 0);
                                result = false;
                            }
                            return result;
                        }

                        @Override
                        protected void done() {
                            logger.debug("download progress done");
                            DownloadGeoNamesFilesDialog.this.btnCancel.setEnabled(false);
                            DownloadGeoNamesFilesDialog.this.btnDownload.setEnabled(false);
                            DownloadGeoNamesFilesDialog.this.btnDone.setEnabled(true);
                            DownloadGeoNamesFilesDialog.this.progressWorker.cancel(true);
                            DownloadGeoNamesFilesDialog.this.progressBarAllCountriesZip.setValue(100);
                            DownloadGeoNamesFilesDialog.this.progressBarAllCountriesTxt.setValue(100);
                            DownloadGeoNamesFilesDialog.this.progressBarFeatureCodesEnTxt.setValue(100);
                            DownloadGeoNamesFilesDialog.this.progressBarAdmin1Codes.setValue(100);
                            DownloadGeoNamesFilesDialog.this.progressBarAdmin2Codes.setValue(100);
                        }
                    };
                    DownloadGeoNamesFilesDialog.this.downloadWorker.execute();
                    URL allCountriesZipURL = new URL(String.valueOf(criteria.getSourceRepository()) + "/allCountries.zip");
                    final long allCountriesZipLength = allCountriesZipURL.openConnection().getContentLength();
                    logger.debug("allCountriesZipLength=" + allCountriesZipLength);
                    DownloadGeoNamesFilesDialog.this.progressWorker = new SwingWorker<Boolean, Integer>(){

                        @Override
                        protected Boolean doInBackground() throws InterruptedException {
                            boolean ended = false;
                            while (!ended) {
                                Thread.sleep(1000L);
                                this.publish(new Integer[0]);
                            }
                            return true;
                        }

                        @Override
                        protected void done() {
                            logger.debug("progressworker done");
                        }

                        @Override
                        protected void process(List<Integer> chunks) {
                            int percentage;
                            logger.debug("progress worker process");
                            DownloadGeoNamesFilesDialog.this.updateFreeDiskSpace();
                            if (new File(String.valueOf(criteria.getTargetDirectory()) + "/" + "allCountries.txt").exists()) {
                                DownloadGeoNamesFilesDialog.this.progressBarAllCountriesZip.setValue(100);
                                DownloadGeoNamesFilesDialog.this.progressBarAllCountriesTxt.setValue(100);
                            } else {
                                File targetAllCountriesZipFile = new File(String.valueOf(criteria.getTargetDirectory()) + "/" + "allCountries.zip");
                                percentage = targetAllCountriesZipFile.exists() ? (int)(targetAllCountriesZipFile.length() * 100L / allCountriesZipLength) : 0;
                                DownloadGeoNamesFilesDialog.this.progressBarAllCountriesZip.setValue(percentage);
                                DownloadGeoNamesFilesDialog.this.progressBarAllCountriesTxt.setValue(0);
                            }
                            percentage = new File(String.valueOf(criteria.getTargetDirectory()) + "/" + "featureCodes_en.txt").exists() ? 100 : 0;
                            DownloadGeoNamesFilesDialog.this.progressBarFeatureCodesEnTxt.setValue(percentage);
                            String timerValue = Chronometer.toTimer(DownloadGeoNamesFilesDialog.this.chrono.stop().interval());
                            DownloadGeoNamesFilesDialog.this.lblTimer.setText(timerValue);
                        }
                    };
                    DownloadGeoNamesFilesDialog.this.progressWorker.execute();
                }
                catch (IOException exception) {
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
        this.btnDownload.setActionCommand("OK");
        this.getRootPane().setDefaultButton(this.btnDownload);
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnDone = new JButton("Done");
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DownloadGeoNamesFilesDialog.this.dispose();
            }
        });
        this.btnDone.setEnabled(false);
        this.btnDone.setActionCommand("OK");
        buttonPane.add(this.btnDone);
    }

    public void clearTarget(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            new File(path, "allCountries.zip").delete();
            new File(path, "allCountries.txt").delete();
            new File(path, "featureCodes_en.txt").delete();
            new File(path, "admin1CodesASCII.txt").delete();
            new File(path, "admin2Codes.txt").delete();
            new File(path, "README").delete();
            new File(path, "id_seek.index").delete();
            new File(path, "seeks.index").delete();
            new File(path, "word_seek.index").delete();
            new File(path, "word_seeks.index.rejection").delete();
        }
    }

    private DownloadGeoNamesFilesCriteria getCriteria() {
        DownloadGeoNamesFilesCriteria result = new DownloadGeoNamesFilesCriteria();
        result.setSourceRepository((String)this.cmbxSourceRepository.getSelectedItem());
        result.setTargetDirectory(this.txtfldTargetDirectory.getText());
        return result;
    }

    public void setTargetDirectory(File target) {
        if (target != null && target.exists() && target.isDirectory()) {
            if (target.canWrite()) {
                this.txtfldTargetDirectory.setText(target.getAbsolutePath());
                this.updateFreeDiskSpace();
                this.btnDownload.setEnabled(true);
            } else {
                String title = "Warning";
                String message = "This directory is not writable.";
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
        }
    }

    public void updateFreeDiskSpace() {
        String value = String.format("%,dMB", new File(this.txtfldTargetDirectory.getText()).getUsableSpace() / 1024L / 1024L);
        this.txtfldFreeDiskSpace.setText(value);
    }

    public static void main(String[] args) {
        try {
            new DownloadGeoNamesFilesDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showDialog() {
        DownloadGeoNamesFilesDialog.showDialog(null);
    }

    public static void showDialog(Component parent) {
        DownloadGeoNamesFilesDialog dialog = new DownloadGeoNamesFilesDialog();
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }
}

