/*
 * Copyright (C) 2015-2016 Christian Pierre MOMON <christian.momon@devinsy.fr>
 *
 * This file is part of FlatDB4GeoNames.
 *
 * FlatDB4GeoNames is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.tip.flatdb4geonames.util;

/**
 * 
 * @author Christian Pierre MOMON (christian.momon@devinsy.fr)
 * 
 */
public class StringLongPair
{

	private String aString;
	private Long aLong;
	private int count;

	/**
	 *
	 */
	public StringLongPair()
	{
		super();
	}

	/**
	 *
	 */
	public StringLongPair(final String alpha, final int bravo)
	{
		super();

		this.aString = alpha;
		this.aLong = new Long(bravo);
	}

	/**
	 *
	 */
	public StringLongPair(final String alpha, final Long bravo)
	{
		super();

		this.aString = alpha;
		this.aLong = bravo;
	}

	public int getCount()
	{
		return this.count;
	}

	/**
	 * 
	 * @return
	 */
	public Long getLong()
	{
		Long result;

		result = this.aLong;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public String getString()
	{
		String result;

		result = this.aString;

		//
		return result;
	}

	/**
	 * 
	 */
	public void inc()
	{
		this.count += 1;
	}

	public void setCount(final int count)
	{
		this.count = count;
	}

}
