/*
 * Copyright (C) 2015-2016 Christian Pierre MOMON <christian.momon@devinsy.fr>
 *
 * This file is part of FlatDB4GeoNames.
 *
 * FlatDB4GeoNames is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.tip.flatdb4geonames.model;

import java.io.File;
import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Christian Pierre MOMON (christian.momon@devinsy.fr)
 */
public class FlatDB4GeoNames
{
	private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNames.class);

	private static GeoNamesFlatDatabase instance = null;

	/**
	 * 
	 * @param localRepository
	 * @throws IOException
	 */
	public static void buildIndex(final File localRepository) throws IOException
	{
		FlatDB4GeoNamesFactory.buildIndex(localRepository);
	}

	/**
	 * 
	 */
	public static void close()
	{
		if (instance == null)
		{
			throw new IllegalStateException("None instance.");
		}
		else
		{
			instance.close();
			instance = null;
		}
	}

	/**
	 * Downloads required files from the official GeoNames repository to a local
	 * repository.
	 * 
	 * @param localTargetRepository
	 * @throws IOException
	 */
	public static void downloadDatabase(final String sourceRepositoryUrl, final File localTargetRepository) throws IOException
	{
		FlatDB4GeoNamesFactory.downloadDatabase(sourceRepositoryUrl, localTargetRepository);
	}

	/**
	 * Downloads required files from the official GeoNames repository to a local
	 * repository.
	 * 
	 * @param localTargetRepository
	 * @throws IOException
	 */
	public static void downloadGeoNamesFiles(final File localTargetRepository) throws IOException
	{
		FlatDB4GeoNamesFactory.downloadGeoNamesFiles(localTargetRepository);
	}

	/**
	 * 
	 * @param repository
	 * @param localTargetRepository
	 * @throws IOException
	 */
	public static void downloadGeoNamesFiles(final String sourceRepositoryUrl, final File localTargetRepository) throws IOException
	{
		FlatDB4GeoNamesFactory.downloadGeoNamesFiles(sourceRepositoryUrl, localTargetRepository);
	}

	/**
	 * 
	 * @return
	 */
	public static GeoNamesFlatDatabase instance()
	{
		GeoNamesFlatDatabase result;

		result = instance;

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public static boolean isOpened()
	{
		boolean result;

		if (instance == null)
		{
			result = false;
		}
		else
		{
			result = true;
		}

		//
		return result;
	}

	/**
	 * 
	 * @param directory
	 * @return
	 */
	public static boolean isValidDatabase(final File directory)
	{
		boolean result;

		result = FlatDB4GeoNamesFactory.isValidDatabase(directory);

		//
		return result;
	}

	/**
	 * 
	 * @param repository
	 * @throws IOException
	 */
	public static GeoNamesFlatDatabase open(final File repository) throws IOException
	{
		GeoNamesFlatDatabase result;

		if (instance != null)
		{
			close();
		}

		instance = FlatDB4GeoNamesFactory.open(repository);
		result = instance;

		//
		return result;
	}

	/**
	 * 
	 * @param repository
	 * @throws IOException
	 */
	public static GeoNamesFlatDatabase open(final String repository) throws IOException
	{
		GeoNamesFlatDatabase result;

		instance = FlatDB4GeoNamesFactory.open(repository);
		result = instance;

		//
		return result;
	}
}
