/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.util;

import java.util.Comparator;
import org.tip.flatdb4geonames.util.StringLongPair;

public class StringLongPairComparator
implements Comparator<StringLongPair> {
    private Sorting sorting;

    public StringLongPairComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(StringLongPair alpha, StringLongPair bravo) {
        int result = StringLongPairComparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public static int compare(StringLongPair alpha, StringLongPair bravo, Sorting sorting) {
        int result;
        if (sorting == null) {
            result = 0;
        } else {
            switch (sorting) {
                case STRING: {
                    String limaValue = StringLongPairComparator.getString(alpha);
                    String mikeValue = StringLongPairComparator.getString(bravo);
                    if (limaValue == null && mikeValue == null) {
                        result = 0;
                        break;
                    }
                    if (limaValue == null) {
                        result = -1;
                        break;
                    }
                    if (mikeValue == null) {
                        result = 1;
                        break;
                    }
                    result = limaValue.compareTo(mikeValue);
                    break;
                }
                case LONG: {
                    Long limaValue = StringLongPairComparator.getLong(alpha);
                    Long mikeValue = StringLongPairComparator.getLong(bravo);
                    if (limaValue == null && mikeValue == null) {
                        result = 0;
                        break;
                    }
                    if (limaValue == null) {
                        result = -1;
                        break;
                    }
                    if (mikeValue == null) {
                        result = 1;
                        break;
                    }
                    result = limaValue.compareTo(mikeValue);
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public static Long getLong(StringLongPair source) {
        Long result = source == null ? null : source.getLong();
        return result;
    }

    public static String getString(StringLongPair source) {
        String result = source == null ? null : source.getString();
        return result;
    }

    public static enum Sorting {
        STRING,
        LONG;

    }
}

