/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.util;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.util.BufferedStringListReader;
import org.tip.flatdb4geonames.util.FileSortingConcatenator;
import org.tip.flatdb4geonames.util.Files;
import org.tip.flatdb4geonames.util.StringListReader;

public class Shrinker {
    private static Logger logger = LoggerFactory.getLogger(Shrinker.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static StringList shrink(StringList source) {
        StringList result = new StringList(source.size());
        source.sort();
        logger.debug("sorted");
        boolean ended = false;
        StringList currentLine = null;
        String currentKey = null;
        int lineCount = 0;
        while (!ended) {
            if (lineCount < source.size()) {
                String[] tokens;
                String line;
                if (currentKey == null) {
                    line = (String)source.get(lineCount);
                    tokens = line.split("\t");
                    currentKey = tokens[0];
                    currentLine = new StringList();
                    currentLine.add((Object)line);
                } else {
                    line = (String)source.get(lineCount);
                    tokens = line.split("\t");
                    String key = tokens[0];
                    String ids = tokens[1];
                    if (StringUtils.equals((CharSequence)currentKey, (CharSequence)key)) {
                        currentLine.append(",").append(ids);
                    } else {
                        result.add((Object)currentLine.toString());
                        currentLine = new StringList();
                        currentLine.add((Object)line);
                        currentKey = key;
                    }
                }
                ++lineCount;
                continue;
            }
            ended = true;
        }
        logger.debug("shrinked: {} -> {}", (Object)source.size(), (Object)result.size());
        return result;
    }

    public static void shrink(StringListReader in, PrintWriter out) throws IOException {
        boolean ended = false;
        StringList currentLine = null;
        String currentWord = null;
        int lineCount = 0;
        int shrinkCount = 0;
        while (!ended) {
            String[] tokens;
            String line = in.readLine();
            if (line == null) {
                ended = true;
                if (currentLine == null) continue;
                out.println(currentLine.toString());
                continue;
            }
            if (currentWord == null) {
                tokens = line.split("\t");
                currentWord = tokens[0];
                currentLine = new StringList();
                currentLine.add((Object)line);
            } else {
                tokens = line.split("\t");
                String word = tokens[0];
                String ids = tokens[1];
                if (StringUtils.equals((CharSequence)currentWord, (CharSequence)word)) {
                    currentLine.append(",").append(ids);
                    ++shrinkCount;
                } else {
                    out.println(currentLine.toString());
                    currentLine = new StringList();
                    currentLine.add((Object)line);
                    currentWord = word;
                }
            }
            ++lineCount;
        }
        logger.debug("shrinked: " + lineCount + " -> " + (lineCount - shrinkCount));
    }

    public static void shrinkConcatentating(Files source, File target) throws IOException {
        FileSortingConcatenator in = null;
        PrintWriter out = null;
        try {
            in = new FileSortingConcatenator(source);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), DEFAULT_CHARSET_NAME));
            Shrinker.shrink(in, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Writer)out);
    }

    public static void shrinkStringFile(File source) throws IOException {
        File target = new File(String.valueOf(source.getAbsolutePath()) + ".shrinked" + System.currentTimeMillis());
        Shrinker.shrinkStringFile(source, target);
        target.renameTo(source);
    }

    public static void shrinkStringFile(File source, File target) throws IOException {
        BufferedStringListReader in = null;
        PrintWriter out = null;
        try {
            in = new BufferedStringListReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), DEFAULT_CHARSET_NAME)));
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), DEFAULT_CHARSET_NAME));
            Shrinker.shrink(in, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Writer)out);
    }
}

