/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    private static Logger logger = LoggerFactory.getLogger(Downloader.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static File download(String sourceUrl, File localTargetRepository) throws IOException {
        File result;
        if (StringUtils.isBlank((CharSequence)sourceUrl) || localTargetRepository == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        if (localTargetRepository.isFile()) {
            throw new IllegalArgumentException("Local target repository is a file.");
        }
        if (sourceUrl.startsWith("http")) {
            URL source = new URL(sourceUrl);
            result = new File(FilenameUtils.concat((String)localTargetRepository.getAbsolutePath(), (String)FilenameUtils.getName((String)sourceUrl)));
            FileUtils.copyURLToFile((URL)source, (File)result);
        } else {
            result = new File(FilenameUtils.concat((String)localTargetRepository.getAbsolutePath(), (String)FilenameUtils.getName((String)sourceUrl)));
            FileUtils.copyFile((File)new File(sourceUrl), (File)result);
        }
        return result;
    }
}

