/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.util.Chronometer;
import org.tip.flatdb4geonames.util.Files;

public class AutomaticFileSplitter {
    private static Logger logger = LoggerFactory.getLogger(AutomaticFileSplitter.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private File referentFile;
    private Files files;
    private int limit;
    private int lineCount = 0;
    private PrintWriter out;

    public AutomaticFileSplitter(File referentFile, int limit) throws IOException {
        this.referentFile = referentFile;
        this.limit = limit;
        this.files = new Files(limit);
        this.nextFile();
    }

    public void close() {
        IOUtils.closeQuietly((Writer)this.out);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public Files getOutputFiles() {
        return this.files;
    }

    public File getReferentFile() {
        return this.referentFile;
    }

    private void nextFile() throws UnsupportedEncodingException, FileNotFoundException {
        this.close();
        File file = new File(String.valueOf(this.referentFile.getAbsolutePath()) + "." + this.files.size());
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
        this.files.add(file);
        this.lineCount = 0;
    }

    public void println(String line) throws IOException {
        if (line != null) {
            if (this.lineCount == this.limit) {
                logger.debug("Limit reached.");
                this.nextFile();
            }
            this.out.println(line);
            ++this.lineCount;
        }
    }

    public static Files splitFile(File source, File target, int limit) throws IOException {
        BufferedReader in = null;
        AutomaticFileSplitter out = null;
        long lineCount = 0L;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), DEFAULT_CHARSET_NAME));
            out = new AutomaticFileSplitter(target, limit);
            boolean ended = false;
            Chronometer chrono = new Chronometer();
            while (!ended) {
                String line;
                if (lineCount % 1000000L == 0L) {
                    System.gc();
                    logger.debug("lineCount=" + lineCount + " \tfiles=" + out.getOutputFiles().size() + " \tmemory=" + Runtime.getRuntime().totalMemory() / 1024L / 1024L + " Mo \t" + (int)(chrono.stop().interval() / 1000L) + " s");
                }
                if ((line = in.readLine()) == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                out.println(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        if (out != null) {
            out.close();
        }
        Files result = out.getOutputFiles();
        return result;
    }

    public static Files splitFile(File source, int limit) throws IOException {
        Files result = AutomaticFileSplitter.splitFile(source, source, limit);
        return result;
    }
}

