/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.swing.downloaddatabase;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.swing.downloaddatabase.DownloadDatabaseCriteria;
import org.tip.flatdb4geonames.swing.downloaddatabase.DownloadTargetSelector;
import org.tip.flatdb4geonames.util.Chronometer;

public class DownloadDatabaseDialog
extends JDialog {
    private static final long serialVersionUID = 2320545249835089493L;
    private static Logger logger = LoggerFactory.getLogger(DownloadDatabaseDialog.class);
    private final JPanel contentPanel = new JPanel();
    private JTextField txtfldTargetDirectory;
    private JTextField txtfldFreeDiskSpace;
    private JButton btnDownload;
    private JComboBox cmbxSourceRepository;
    private SwingWorker<Boolean, Integer> downloadWorker;
    private SwingWorker<Boolean, Integer> progressWorker;
    private JButton btnCancel;
    private JButton btnDone;
    private JProgressBar progressBarDatabaseZip;
    private JProgressBar progressBarDatabaseUnzip;
    private JLabel lblAllDatabaseZip;
    private JLabel lblAllDatabaseUnzip;
    private Chronometer chrono;
    private JLabel lblTimer;
    private JButton btnSelector;

    public DownloadDatabaseDialog() {
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("Download Datbase");
        this.setBounds(100, 100, 630, 420);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        JPanel introPanel = new JPanel();
        this.contentPanel.add(introPanel);
        JLabel lblNewLabel = new JLabel("<html>\nFlatDB4GeoNames provides quick and easy access to GeoNames data as local files.<br/>\nFlatDB4GeoNames requires GeoNames files and dedicated indexes.<br/>\nThis panel will download them for you in the directory of your choice.\n</html>");
        introPanel.add(lblNewLabel);
        Component verticalStrut = Box.createVerticalStrut(10);
        this.contentPanel.add(verticalStrut);
        JPanel inputPanel = new JPanel();
        this.contentPanel.add(inputPanel);
        inputPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblSource = new JLabel("Source repository:");
        inputPanel.add((Component)lblSource, "2, 2, right, default");
        this.cmbxSourceRepository = new JComboBox();
        this.cmbxSourceRepository.setEditable(true);
        this.cmbxSourceRepository.setModel(new DefaultComboBoxModel<String>(new String[]{"http://www.devinsy.fr/Puck/Repository/"}));
        inputPanel.add((Component)this.cmbxSourceRepository, "4, 2, fill, default");
        JLabel lblTarget = new JLabel("Target directory:");
        inputPanel.add((Component)lblTarget, "2, 4, right, default");
        this.txtfldTargetDirectory = new JTextField();
        this.txtfldTargetDirectory.setEditable(false);
        inputPanel.add((Component)this.txtfldTargetDirectory, "4, 4, fill, default");
        this.txtfldTargetDirectory.setColumns(10);
        this.btnSelector = new JButton("...");
        this.btnSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File target = DownloadTargetSelector.showSelectorDialog(null, null);
                if (target != null) {
                    DownloadDatabaseDialog.this.setTargetDirectory(target);
                }
            }
        });
        inputPanel.add((Component)this.btnSelector, "6, 4");
        JLabel lblSpaceDisk = new JLabel("Free disk space:");
        inputPanel.add((Component)lblSpaceDisk, "2, 6, right, default");
        this.txtfldFreeDiskSpace = new JTextField();
        this.txtfldFreeDiskSpace.setEditable(false);
        this.txtfldFreeDiskSpace.setHorizontalAlignment(4);
        inputPanel.add((Component)this.txtfldFreeDiskSpace, "4, 6, fill, default");
        this.txtfldFreeDiskSpace.setColumns(10);
        JLabel lblfreeDiskSpace = new JLabel("Free disk space required:      3 000MB ");
        inputPanel.add((Component)lblfreeDiskSpace, "4, 8, right, default");
        JPanel panel = new JPanel();
        inputPanel.add((Component)panel, "4, 9, fill, fill");
        panel.setLayout(new BoxLayout(panel, 0));
        this.lblAllDatabaseZip = new JLabel("database.zip:");
        this.lblAllDatabaseZip.setEnabled(false);
        inputPanel.add((Component)this.lblAllDatabaseZip, "2, 12, right, default");
        this.progressBarDatabaseZip = new JProgressBar();
        this.progressBarDatabaseZip.setEnabled(false);
        inputPanel.add((Component)this.progressBarDatabaseZip, "4, 12");
        this.lblAllDatabaseUnzip = new JLabel("unzip database.zip:");
        this.lblAllDatabaseUnzip.setEnabled(false);
        inputPanel.add((Component)this.lblAllDatabaseUnzip, "2, 14, right, default");
        this.progressBarDatabaseUnzip = new JProgressBar();
        this.progressBarDatabaseUnzip.setEnabled(false);
        inputPanel.add((Component)this.progressBarDatabaseUnzip, "4, 14");
        this.lblTimer = new JLabel("00:00:00");
        inputPanel.add((Component)this.lblTimer, "4, 16, center, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (DownloadDatabaseDialog.this.downloadWorker != null) {
                    DownloadDatabaseDialog.this.downloadWorker.cancel(true);
                }
                if (DownloadDatabaseDialog.this.progressWorker != null) {
                    DownloadDatabaseDialog.this.progressWorker.cancel(true);
                }
                DownloadDatabaseDialog.this.clearTarget(DownloadDatabaseDialog.this.txtfldTargetDirectory.getText());
                DownloadDatabaseDialog.this.dispose();
            }
        });
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnDownload = new JButton("Download");
        buttonPane.add(this.btnDownload);
        this.btnDownload.setEnabled(false);
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final DownloadDatabaseCriteria criteria = DownloadDatabaseDialog.this.getCriteria();
                try {
                    long databaseZipLength;
                    DownloadDatabaseDialog.this.updateFreeDiskSpace();
                    DownloadDatabaseDialog.this.btnDownload.setEnabled(false);
                    DownloadDatabaseDialog.this.btnSelector.setEnabled(false);
                    DownloadDatabaseDialog.this.lblAllDatabaseZip.setEnabled(true);
                    DownloadDatabaseDialog.this.lblAllDatabaseUnzip.setEnabled(true);
                    DownloadDatabaseDialog.this.progressBarDatabaseZip.setEnabled(true);
                    DownloadDatabaseDialog.this.progressBarDatabaseUnzip.setEnabled(true);
                    DownloadDatabaseDialog.this.chrono = new Chronometer();
                    DownloadDatabaseDialog.this.downloadWorker = new SwingWorker<Boolean, Integer>(){

                        @Override
                        protected Boolean doInBackground() {
                            Boolean result;
                            try {
                                DownloadDatabaseDialog.this.clearTarget(criteria.getTargetDirectory());
                                File targetFile = new File(criteria.getTargetDirectory());
                                FlatDB4GeoNames.downloadDatabase(criteria.getSourceRepository(), targetFile);
                                result = true;
                            }
                            catch (FileNotFoundException exception) {
                                exception.printStackTrace();
                                String title = "Error";
                                String message = "File not found: " + exception.getMessage();
                                JOptionPane.showMessageDialog(null, message, title, 0);
                                result = false;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                String title = "Error";
                                String message = "Download error: " + exception.getMessage();
                                JOptionPane.showMessageDialog(null, message, title, 0);
                                result = false;
                            }
                            return result;
                        }

                        @Override
                        protected void done() {
                            logger.debug("download progress done");
                            DownloadDatabaseDialog.this.btnCancel.setEnabled(false);
                            DownloadDatabaseDialog.this.btnDownload.setEnabled(false);
                            DownloadDatabaseDialog.this.btnDone.setEnabled(true);
                            if (DownloadDatabaseDialog.this.progressWorker != null) {
                                DownloadDatabaseDialog.this.progressWorker.cancel(true);
                            }
                            DownloadDatabaseDialog.this.progressBarDatabaseZip.setValue(100);
                            DownloadDatabaseDialog.this.progressBarDatabaseUnzip.setValue(100);
                        }
                    };
                    DownloadDatabaseDialog.this.downloadWorker.execute();
                    if (criteria.getSourceRepository().startsWith("http")) {
                        URL databaseZipURL = new URL(String.valueOf(criteria.getSourceRepository()) + "FlatDB4GeoNames-database.zip");
                        databaseZipLength = databaseZipURL.openConnection().getContentLength();
                    } else {
                        databaseZipLength = new File(String.valueOf(criteria.getSourceRepository()) + "FlatDB4GeoNames-database.zip").length();
                    }
                    logger.debug("databaseZipLength=" + databaseZipLength);
                    DownloadDatabaseDialog.this.progressWorker = new SwingWorker<Boolean, Integer>(){

                        @Override
                        protected Boolean doInBackground() throws InterruptedException {
                            boolean ended = false;
                            while (!ended) {
                                Thread.sleep(1000L);
                                this.publish(new Integer[0]);
                            }
                            return true;
                        }

                        @Override
                        protected void done() {
                            logger.debug("progressworker done");
                        }

                        @Override
                        protected void process(List<Integer> chunks) {
                            logger.debug("progress worker process");
                            DownloadDatabaseDialog.this.updateFreeDiskSpace();
                            File targetFile = new File(String.valueOf(criteria.getTargetDirectory()) + File.separator + "FlatDB4GeoNames-database.zip");
                            int percentage = targetFile.exists() ? (int)(targetFile.length() * 100L / databaseZipLength) : 0;
                            DownloadDatabaseDialog.this.progressBarDatabaseZip.setValue(percentage);
                            DownloadDatabaseDialog.this.progressBarDatabaseUnzip.setValue(0);
                            String timerValue = Chronometer.toTimer(DownloadDatabaseDialog.this.chrono.stop().interval());
                            DownloadDatabaseDialog.this.lblTimer.setText(timerValue);
                        }
                    };
                    DownloadDatabaseDialog.this.progressWorker.execute();
                }
                catch (Exception exception) {
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
        this.btnDownload.setActionCommand("OK");
        this.getRootPane().setDefaultButton(this.btnDownload);
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnDone = new JButton("Done");
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DownloadDatabaseDialog.this.dispose();
            }
        });
        this.btnDone.setEnabled(false);
        this.btnDone.setActionCommand("OK");
        buttonPane.add(this.btnDone);
    }

    public void clearTarget(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            new File(path, "allCountries.zip").delete();
            new File(path, "allCountries.txt").delete();
            new File(path, "featureCodes_en.txt").delete();
            new File(path, "admin1CodesASCII.txt").delete();
            new File(path, "admin2Codes.txt").delete();
            new File(path, "README").delete();
        }
    }

    private DownloadDatabaseCriteria getCriteria() {
        DownloadDatabaseCriteria result = new DownloadDatabaseCriteria();
        result.setSourceRepository((String)this.cmbxSourceRepository.getSelectedItem());
        result.setTargetDirectory(this.txtfldTargetDirectory.getText());
        return result;
    }

    public void setTargetDirectory(File target) {
        if (target != null && target.exists() && target.isDirectory()) {
            if (target.canWrite()) {
                this.txtfldTargetDirectory.setText(target.getAbsolutePath());
                this.updateFreeDiskSpace();
                this.btnDownload.setEnabled(true);
            } else {
                String title = "Warning";
                String message = "This directory is not writable.";
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
        }
    }

    public void updateFreeDiskSpace() {
        String value = String.format("%,dMB", new File(this.txtfldTargetDirectory.getText()).getUsableSpace() / 1024L / 1024L);
        this.txtfldFreeDiskSpace.setText(value);
    }

    public static void main(String[] args) {
        try {
            new DownloadDatabaseDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showDialog() {
        DownloadDatabaseDialog.showDialog(null);
    }

    public static void showDialog(Component parent) {
        DownloadDatabaseDialog dialog = new DownloadDatabaseDialog();
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }
}

