/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.index.AdministrativePath;
import org.tip.flatdb4geonames.model.index.AdministrativePaths;

public class IndexOfAdministrativePaths {
    private static Logger logger = LoggerFactory.getLogger(IndexOfAdministrativePaths.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private AdministrativePaths administrativePaths = new AdministrativePaths();
    private Map<String, AdministrativePath> index = new HashMap<String, AdministrativePath>();

    public IndexOfAdministrativePaths(File code1File, File code2File) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(IndexOfAdministrativePaths.class.getResourceAsStream("/org/tip/flatdb4geonames/model/index/ISO_3166-1-alpha-2.properties")));
            int lineCount = 0;
            boolean ended = false;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                if (line.startsWith("#")) continue;
                String[] tokens = line.split("=");
                AdministrativePath code = new AdministrativePath(tokens[0], tokens[1], null);
                this.administrativePaths.add(code);
                this.index.put(code.getTag(), code);
            }
            logger.debug("count line=" + lineCount);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        File[] fileArray = new File[]{code1File, code2File};
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File source = fileArray[n2];
            BufferedReader in2 = null;
            try {
                in2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), DEFAULT_CHARSET_NAME));
                int lineCount = 0;
                boolean ended = false;
                while (!ended) {
                    String line = in2.readLine();
                    if (line == null) {
                        ended = true;
                        continue;
                    }
                    ++lineCount;
                    String[] tokens = line.split("\t");
                    if (tokens.length != 4) continue;
                    AdministrativePath code = new AdministrativePath(tokens[0], tokens[1], new Integer(tokens[3]));
                    this.administrativePaths.add(code);
                    this.index.put(code.getTag(), code);
                }
                logger.debug("count line=" + lineCount);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in2);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in2);
            ++n2;
        }
    }

    public void clear() {
        this.index.clear();
        this.administrativePaths.clear();
    }

    public AdministrativePath get(String codePath) {
        AdministrativePath result = codePath == null ? null : this.index.get(IndexOfAdministrativePaths.normalizeCodePath(codePath));
        return result;
    }

    public AdministrativePath get(String countryCode, String code1, String code2, String code3, String code4) {
        AdministrativePath result = this.get(AdministrativePath.convertToCodePath(countryCode, code1, code2, code3, code4));
        return result;
    }

    public AdministrativePaths getCodes() {
        AdministrativePaths result = new AdministrativePaths(this.administrativePaths);
        return result;
    }

    public String searchAdministrativeToponymPath(String administrativeCodePath) {
        String result;
        if (administrativeCodePath == null) {
            result = null;
        } else {
            StringList codePaths = new StringList();
            StringList currentCodePath = new StringList();
            String[] stringArray = IndexOfAdministrativePaths.normalizeCodePath(administrativeCodePath).split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                currentCodePath.append(code);
                codePaths.append(currentCodePath.toStringSeparatedBy("."));
                ++n2;
            }
            StringList toponymPath = new StringList();
            for (String codePath : codePaths) {
                AdministrativePath path = this.get(codePath);
                if (path == null) {
                    toponymPath.append("?");
                    continue;
                }
                toponymPath.append(path.getToponym());
            }
            result = toponymPath.toStringSeparatedBy(" / ");
        }
        return result;
    }

    public String searchAdministrativeToponymPath(String countryCode, String adminCode1, String adminCode2, String adminCode3, String adminCode4) {
        String result;
        if (countryCode == null) {
            result = null;
        } else {
            String administrativeCodePaths = AdministrativePath.convertToCodePath(countryCode, adminCode1, adminCode2, adminCode3, adminCode4);
            result = this.searchAdministrativeToponymPath(administrativeCodePaths);
        }
        return result;
    }

    public static String normalizeCodePath(String source) {
        String result = StringUtils.length((CharSequence)source) == 5 && StringUtils.endsWith((CharSequence)source, (CharSequence)".00") ? source.substring(0, source.lastIndexOf(".00")) : source;
        return result;
    }
}

