/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import fr.devinsy.util.StringList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.index.FeatureClass;

public class Feature {
    private static Logger logger = LoggerFactory.getLogger(Feature.class);
    private FeatureClass featureClass;
    private String featureCode;
    private String shortDescription;
    private String description;

    public Feature(String featureClassCode, String featureCode, String shortDescription, String description) {
        if (!FeatureClass.isClassCode(featureClassCode)) {
            throw new IllegalArgumentException("Bad feature class value.");
        }
        this.featureClass = FeatureClass.valueOfCode(featureClassCode);
        this.featureCode = featureCode;
        this.shortDescription = shortDescription;
        this.description = description;
    }

    public String getCodePath() {
        String result = Feature.convertToFeaturePath(this.featureClass.getCode(), this.featureCode);
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionPath() {
        String result = this.featureCode == null ? this.shortDescription : String.format("%s / %s", this.featureClass.getDescription(), this.shortDescription);
        return result;
    }

    public FeatureClass getFeatureClass() {
        return this.featureClass;
    }

    public String getFeatureClassCode() {
        String result = this.featureClass.getCode();
        return result;
    }

    public String getFeatureCode() {
        return this.featureCode;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setCode(String code) {
        this.featureCode = code;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFeatureClass(FeatureClass featureClass) {
        this.featureClass = featureClass;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String toString() {
        StringList buffer = new StringList();
        buffer.append(this.getCodePath());
        buffer.append(this.shortDescription);
        buffer.append(this.description);
        String result = buffer.toStringSeparatedBy("\t");
        return result;
    }

    public static Pair<String, String> convertToCodes(String codePath) {
        String[] codes;
        Pair result = StringUtils.isBlank((CharSequence)codePath) ? null : ((codes = codePath.split("\\.")).length < 2 ? Pair.of((Object)codes[0], null) : Pair.of((Object)codes[0], (Object)codes[1]));
        return result;
    }

    public static String convertToFeaturePath(String featureClassCode, String featureCode) {
        String result;
        if (featureClassCode == null) {
            result = null;
        } else {
            StringList buffer = new StringList();
            buffer.append(featureClassCode);
            buffer.append(featureCode);
            result = buffer.toStringSeparatedBy(".");
        }
        return result;
    }
}

