/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import java.io.IOException;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.GeoNamesFlatDatabase;
import org.tip.flatdb4geonames.model.index.AdministrativePath;

public class AdministrativeTest {
    private static Logger logger = LoggerFactory.getLogger(AdministrativeTest.class);
    public static final String DATABASE_HOME = "data/";

    @Test
    public void searchAdministrativeToponym01() throws IOException, FlatDB4GeoNamesException {
        GeoNamesFlatDatabase database = FlatDB4GeoNames.open(DATABASE_HOME);
        Assertions.assertThat((String)database.searchAdministrativeToponym(null, null, null, null, null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", null, null, null, null)).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "00", null, null, null)).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "FOO", null, null, null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", null, null, null)).isEqualTo((Object)"Lorraine");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", null, null)).isEqualTo((Object)"D\u00e9partement de Meurthe-et-Moselle");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", "571", null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", "571", "80240")).isNull();
    }

    @Test
    public void searchAdministrativeToponym02() throws IOException, FlatDB4GeoNamesException {
        GeoNamesFlatDatabase database = FlatDB4GeoNames.open(DATABASE_HOME);
        Assertions.assertThat((String)database.searchAdministrativeToponym(null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR")).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR.00")).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR.FOO")).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR.B2")).isEqualTo((Object)"Lorraine");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR.B2.54")).isEqualTo((Object)"D\u00e9partement de Meurthe-et-Moselle");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR.B2.54")).isEqualTo((Object)"D\u00e9partement de Meurthe-et-Moselle");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", "571", null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", "571", "80240")).isNull();
    }

    @Test
    public void testConvertToCodePath01() throws IOException, FlatDB4GeoNamesException {
        Assertions.assertThat((String)AdministrativePath.convertToCodePath(null, null, null, null, null)).isNull();
        Assertions.assertThat((String)AdministrativePath.convertToCodePath("FR", null, null, null, null)).isEqualTo((Object)"FR");
        Assertions.assertThat((String)AdministrativePath.convertToCodePath("FR", "B2", null, null, null)).isEqualTo((Object)"FR.B2");
        Assertions.assertThat((String)AdministrativePath.convertToCodePath("FR", "B2", "54", null, null)).isEqualTo((Object)"FR.B2.54");
        Assertions.assertThat((String)AdministrativePath.convertToCodePath("FR", "B2", "54", "571", null)).isEqualTo((Object)"FR.B2.54.571");
        Assertions.assertThat((String)AdministrativePath.convertToCodePath("FR", "B2", "54", "571", "80240")).isEqualTo((Object)"FR.B2.54.571.80240");
    }

    @Test
    public void testSearchAdministrativeToponym01() throws IOException, FlatDB4GeoNamesException {
        GeoNamesFlatDatabase database = FlatDB4GeoNames.open(DATABASE_HOME);
        Assertions.assertThat((String)database.searchAdministrativeToponym(null, null, null, null, null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", null, null, null, null)).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "00", null, null, null)).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "FOO", null, null, null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", null, null, null)).isEqualTo((Object)"Lorraine");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", null, null)).isEqualTo((Object)"D\u00e9partement de Meurthe-et-Moselle");
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", "571", null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponym("FR", "B2", "54", "571", "80240")).isNull();
    }

    @Test
    public void testSearchAdministrativeToponymPath01() throws IOException, FlatDB4GeoNamesException {
        GeoNamesFlatDatabase database = FlatDB4GeoNames.open(DATABASE_HOME);
        Assertions.assertThat((String)database.searchAdministrativeToponymPath(null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR")).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR.00")).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR.FOO")).isEqualTo((Object)"France / ?");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR.B2")).isEqualTo((Object)"France / Lorraine");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR.B2.54")).isEqualTo((Object)"France / Lorraine / D\u00e9partement de Meurthe-et-Moselle");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR.B2.54.571")).isEqualTo((Object)"France / Lorraine / D\u00e9partement de Meurthe-et-Moselle / ?");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR.B2.54.571.80240")).isEqualTo((Object)"France / Lorraine / D\u00e9partement de Meurthe-et-Moselle / ? / ?");
    }

    @Test
    public void testSearchAdministrativeToponymPath02() throws IOException, FlatDB4GeoNamesException {
        GeoNamesFlatDatabase database = FlatDB4GeoNames.open(DATABASE_HOME);
        Assertions.assertThat((String)database.searchAdministrativeToponymPath(null, null, null, null, null)).isNull();
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR", null, null, null, null)).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR", "00", null, null, null)).isEqualTo((Object)"France");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR", "FOO", null, null, null)).isEqualTo((Object)"France / ?");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR", "B2", null, null, null)).isEqualTo((Object)"France / Lorraine");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR", "B2", "54", null, null)).isEqualTo((Object)"France / Lorraine / D\u00e9partement de Meurthe-et-Moselle");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR", "B2", "54", "571", null)).isEqualTo((Object)"France / Lorraine / D\u00e9partement de Meurthe-et-Moselle / ?");
        Assertions.assertThat((String)database.searchAdministrativeToponymPath("FR", "B2", "54", "571", "80240")).isEqualTo((Object)"France / Lorraine / D\u00e9partement de Meurthe-et-Moselle / ? / ?");
    }
}

