/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model;

import java.io.IOException;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.GeoNamesFlatDatabase;
import org.tip.flatdb4geonames.model.index.FeatureClass;

public class GeoNamesFlatDatabaseTest {
    private static Logger logger = LoggerFactory.getLogger(GeoNamesFlatDatabaseTest.class);
    public static final String DATABASE_HOME = "data/";

    @Test
    public void testSearchFeatureDescription() throws IOException, FlatDB4GeoNamesException {
        FlatDB4GeoNames.open(DATABASE_HOME);
        GeoNamesFlatDatabase database = FlatDB4GeoNames.instance();
        Assertions.assertThat((String)database.searchFeatureDescription(null)).isNull();
        Assertions.assertThat((String)database.searchFeatureDescription("X")).isNull();
        Assertions.assertThat((String)database.searchFeatureDescription("H")).isNull();
        Assertions.assertThat((String)database.searchFeatureDescription("H.CNLA")).isEqualTo((Object)"a conduit used to carry water");
        Assertions.assertThat((String)database.searchFeatureDescription("H.FOO")).isNull();
        Assertions.assertThat((String)database.searchFeatureDescription(null, null)).isNull();
        Assertions.assertThat((String)database.searchFeatureDescription("X", null)).isNull();
        Assertions.assertThat((String)database.searchFeatureDescription("H", null)).isNull();
        Assertions.assertThat((String)database.searchFeatureDescription("H", "CNLA")).isEqualTo((Object)"a conduit used to carry water");
        Assertions.assertThat((String)database.searchFeatureDescription("H", "FOO")).isNull();
    }

    @Test
    public void testSearchFeatureDescriptionPath() throws IOException, FlatDB4GeoNamesException {
        FlatDB4GeoNames.open(DATABASE_HOME);
        GeoNamesFlatDatabase database = FlatDB4GeoNames.instance();
        Assertions.assertThat((String)database.searchFeatureDescriptionPath(null)).isNull();
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("X")).isNull();
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("H")).isEqualTo((Object)"Stream, lake\u2026");
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("CNLA")).isEqualTo((Object)"Stream, lake\u2026 / aqueduct");
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("H.CNLA")).isEqualTo((Object)"Stream, lake\u2026 / aqueduct");
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("H.FOO")).isNull();
        Assertions.assertThat((String)database.searchFeatureDescriptionPath(null, null)).isNull();
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("X", null)).isNull();
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("H", null)).isEqualTo((Object)"Stream, lake\u2026");
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("H", "CNLA")).isEqualTo((Object)"Stream, lake\u2026 / aqueduct");
        Assertions.assertThat((String)database.searchFeatureDescriptionPath("H", "FOO")).isNull();
    }

    @Test
    public void testSearchFeatureShortDescription() throws IOException, FlatDB4GeoNamesException {
        FlatDB4GeoNames.open(DATABASE_HOME);
        GeoNamesFlatDatabase database = FlatDB4GeoNames.instance();
        Assertions.assertThat((String)database.searchFeatureShortDescription(null)).isNull();
        Assertions.assertThat((String)database.searchFeatureShortDescription("X")).isNull();
        Assertions.assertThat((String)database.searchFeatureShortDescription("H")).isEqualTo((Object)FeatureClass.valueOfCode("H").getDescription());
        Assertions.assertThat((String)database.searchFeatureShortDescription("CNLA")).isEqualTo((Object)"aqueduct");
        Assertions.assertThat((String)database.searchFeatureShortDescription("H.CNLA")).isEqualTo((Object)"aqueduct");
        Assertions.assertThat((String)database.searchFeatureShortDescription("H.FOO")).isNull();
        Assertions.assertThat((String)database.searchFeatureShortDescription(null, null)).isNull();
        Assertions.assertThat((String)database.searchFeatureShortDescription("X", null)).isNull();
        Assertions.assertThat((String)database.searchFeatureShortDescription("H", null)).isEqualTo((Object)FeatureClass.valueOfCode("H").getDescription());
        Assertions.assertThat((String)database.searchFeatureShortDescription("H", "CNLA")).isEqualTo((Object)"aqueduct");
        Assertions.assertThat((String)database.searchFeatureShortDescription("H", "FOO")).isNull();
    }
}

