/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.cli.FlatDB4GeoNamesCLI;
import org.tip.flatdb4geonames.gui.FlatDB4GeoNamesGUI;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;

public class FlatDB4GeoNamesLauncher {
    private static Logger logger = LoggerFactory.getLogger(FlatDB4GeoNamesLauncher.class);

    public static void main(String[] args) throws IOException, FlatDB4GeoNamesException {
        File loggerConfig = new File("log4j.properties");
        if (loggerConfig.exists()) {
            PropertyConfigurator.configure((String)loggerConfig.getAbsolutePath());
            logger.info("Dedicated log configuration done.");
            logger.info("Configuration file was found in [{}].", (Object)loggerConfig.getAbsoluteFile());
        } else {
            BasicConfigurator.configure();
            logger.info("Basic log configuration done.");
            logger.info("Configuration file was not found in [{}].", (Object)loggerConfig.getAbsoluteFile());
        }
        if (args.length > 0) {
            FlatDB4GeoNamesCLI.run(args);
        } else if (args.length == 0) {
            FlatDB4GeoNamesGUI.instance().run();
        }
    }
}

