/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.util.AutomaticFileSplitter;
import org.tip.flatdb4geonames.util.Chronometer;
import org.tip.flatdb4geonames.util.FileSortingConcatenator;
import org.tip.flatdb4geonames.util.Files;

public class StringFileSorter {
    private static Logger logger = LoggerFactory.getLogger(StringFileSorter.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int DEFAULT_SPLIT_LIMIT = 2000000;

    public static void sortBigStringFile(File source) throws IOException {
        StringFileSorter.sortBigStringFile(source, 2000000);
    }

    public static void sortBigStringFile(File source, File target, int lineLimit) throws IOException {
        StringFileSorter.sortBigStringFile(source, target, lineLimit, null);
    }

    public static void sortBigStringFile(File source, File target, int lineLimit, Comparator<String> comparator) throws IOException {
        logger.debug("sort big string file starting...");
        logger.debug("split file start...");
        Chronometer chrono = new Chronometer();
        Files splitFiles = AutomaticFileSplitter.splitFile(source, lineLimit);
        logger.debug("split file done. {}", (Object)chrono.stop().interval());
        System.gc();
        logger.debug(" memory={} Mo", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        logger.debug("sort files start...");
        chrono.reset();
        for (File file : splitFiles) {
            logger.debug("\tsort " + file.toString());
            Chronometer chronoStep = new Chronometer();
            StringFileSorter.sortStringFile(file, comparator);
            logger.debug("\tsort done. {}", (Object)chronoStep.stop().interval());
        }
        logger.debug("sort done. {}", (Object)chrono.stop().interval());
        System.gc();
        logger.debug(" memory={} Mo", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        logger.debug("concatenate sorting start...");
        chrono.reset();
        FileSortingConcatenator.concatenateSorting(splitFiles, target, comparator);
        logger.debug("concatenate sorting done. {}", (Object)chrono.stop().interval());
        logger.debug("delete temporary files start...");
        for (File file : splitFiles) {
            file.delete();
        }
        logger.debug("delete temporary files done.");
        logger.debug("sort big string file done.");
    }

    public static void sortBigStringFile(File source, int lineLimit) throws IOException {
        File target = new File(String.valueOf(source.getAbsolutePath()) + ".sorted" + System.currentTimeMillis());
        StringFileSorter.sortBigStringFile(source, target, lineLimit);
        target.renameTo(source);
    }

    public static void sortBigStringFile(File source, int lineLimit, Comparator<String> comparator) throws IOException {
        File target = new File(String.valueOf(source.getAbsolutePath()) + ".sorted" + System.currentTimeMillis());
        StringFileSorter.sortBigStringFile(source, target, lineLimit, comparator);
        target.renameTo(source);
    }

    public static void sortStringFile(File source) throws IOException {
        StringFileSorter.sortStringFile(source, null);
    }

    public static void sortStringFile(File source, Comparator<String> comparator) throws IOException {
        List lines = FileUtils.readLines((File)source);
        Collections.sort(lines, comparator);
        File target = new File(String.valueOf(source.getAbsolutePath()) + ".sorted" + System.currentTimeMillis());
        FileUtils.writeLines((File)target, (Collection)lines);
        source.delete();
        target.renameTo(source);
    }
}

