/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.util.Chronometer;
import org.tip.flatdb4geonames.util.Files;
import org.tip.flatdb4geonames.util.SingleLineBufferedFileReader;
import org.tip.flatdb4geonames.util.SingleLineBufferedFileReaders;
import org.tip.flatdb4geonames.util.StringListReader;

public class FileSortingConcatenator
implements StringListReader {
    private static Logger logger = LoggerFactory.getLogger(FileSortingConcatenator.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private SingleLineBufferedFileReaders readers;
    private Comparator<String> comparator;

    public FileSortingConcatenator(Files files) throws IOException {
        this(files, null);
    }

    public FileSortingConcatenator(Files files, Comparator<String> comparator) throws IOException {
        this.readers = new SingleLineBufferedFileReaders(files.size());
        this.comparator = comparator;
        for (File file : files) {
            SingleLineBufferedFileReader reader = new SingleLineBufferedFileReader(file);
            this.readers.add(reader);
        }
    }

    @Override
    public void close() {
        for (SingleLineBufferedFileReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public String readLine() throws IOException {
        this.readers.sort(this.comparator);
        String result = ((SingleLineBufferedFileReader)this.readers.get(0)).readLine();
        return result;
    }

    public static void concatenateSorting(Files source, File target, Comparator<String> comparator) throws IOException {
        FileSortingConcatenator in = null;
        PrintWriter out = null;
        try {
            in = new FileSortingConcatenator(source, comparator);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), DEFAULT_CHARSET_NAME));
            boolean ended = false;
            long lineCount = 0L;
            Chronometer chrono = new Chronometer();
            while (!ended) {
                String line;
                if (lineCount % 100000L == 0L) {
                    System.gc();
                    logger.debug("lineCount=" + lineCount + " \tmemory=" + Runtime.getRuntime().totalMemory() / 1024L / 1024L + " Mo \t" + (int)(chrono.stop().interval() / 1000L) + " s");
                }
                if ((line = in.readLine()) == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                out.println(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Writer)out);
    }
}

