/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.index.IndexOfWordSeeks;

public class IndexOfIdSeek {
    private static Logger logger = LoggerFactory.getLogger(IndexOfIdSeek.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private RandomAccessFile data;
    private RandomAccessFile index;
    private int lineLength;

    public IndexOfIdSeek(File dataFile, File indexDirectory) throws IOException {
        if (dataFile == null || indexDirectory == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        this.data = new RandomAccessFile(dataFile, "r");
        File indexFile = new File(indexDirectory.getAbsoluteFile() + File.separator + "id_seek.index");
        this.index = new RandomAccessFile(indexFile, "r");
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(indexFile), DEFAULT_CHARSET_NAME));
            this.lineLength = in.readLine().length() + 1;
            logger.debug("index1.lineLength={}", (Object)this.lineLength);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)this.data);
        IOUtils.closeQuietly((Closeable)this.index);
    }

    public String get(int geonameId) throws IOException {
        String result;
        if (geonameId < 1) {
            throw new IllegalArgumentException("Bad id.");
        }
        long indexSeek = (geonameId - 1) * this.lineLength;
        this.index.seek(indexSeek);
        String indexLine = this.index.readLine();
        logger.debug("get({})=seek({})=[{}]", new Object[]{geonameId, indexSeek, indexLine});
        if (indexLine.charAt(0) == ' ') {
            result = null;
        } else {
            long dataSeek = Long.parseLong(indexLine.trim());
            this.data.seek(dataSeek);
            result = IndexOfWordSeeks.readUTFLine(this.data);
        }
        return result;
    }
}

