/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.index.Feature;
import org.tip.flatdb4geonames.model.index.FeatureClass;
import org.tip.flatdb4geonames.model.index.Features;

public class IndexOfFeatures {
    private static Logger logger = LoggerFactory.getLogger(IndexOfFeatures.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private Features features = new Features();
    private Map<String, Feature> index = new HashMap<String, Feature>();

    public IndexOfFeatures(File source) throws IOException {
        FeatureClass[] featureClassArray = FeatureClass.values();
        int n = featureClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureClass featureClass = featureClassArray[n2];
            Feature feature = new Feature(featureClass.getCode(), null, featureClass.getDescription(), null);
            this.features.add(feature);
            this.index.put(feature.getCodePath(), feature);
            ++n2;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), DEFAULT_CHARSET_NAME));
            int lineCount = 0;
            boolean ended = false;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                String[] tokens = line.split("\t");
                String[] tags = tokens[0].split("\\.");
                if (tags.length <= 1) continue;
                String featureClassCode = tags[0];
                String featureCode = tags[1];
                String shortDescription = tokens[1];
                String description = tokens.length > 2 ? tokens[2] : null;
                Feature feature = new Feature(featureClassCode, featureCode, shortDescription, description);
                this.features.add(feature);
                this.index.put(feature.getCodePath(), feature);
                this.index.put(feature.getFeatureCode(), feature);
            }
            logger.debug("count line=" + lineCount);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
    }

    public void clear() {
        this.index.clear();
        this.features.clear();
    }

    public Feature get(String featurePath) {
        Feature result = this.index.get(featurePath);
        return result;
    }

    public Feature get(String className, String code) {
        Feature result = this.index.get(Feature.convertToFeaturePath(className, code));
        return result;
    }

    public String getFeatureDescription(String featurePath) {
        Feature feature = this.get(featurePath);
        String result = feature == null ? null : feature.getDescription();
        return result;
    }

    public String getFeatureDescription(String className, String code) {
        String result = this.getFeatureDescription(Feature.convertToFeaturePath(className, code));
        return result;
    }

    public String getFeatureDescriptionPath(String codePath) {
        Feature feature = this.get(codePath);
        String result = feature == null ? null : feature.getDescriptionPath();
        return result;
    }

    public String getFeatureDescriptionPath(String featureClassName, String featureCode) {
        Feature feature = this.get(featureClassName, featureCode);
        String result = feature == null ? null : feature.getDescriptionPath();
        return result;
    }

    public Features getFeatures() {
        Features result = new Features(this.features);
        return result;
    }

    public String getFeatureShortDescription(String featurePath) {
        Feature feature = this.get(featurePath);
        String result = feature == null ? null : feature.getShortDescription();
        return result;
    }

    public String getFeatureShortDescription(String className, String code) {
        String result = this.getFeatureShortDescription(Feature.convertToFeaturePath(className, code));
        return result;
    }
}

