/*
 * Decompiled with CFR 0.152.
 */
package org.tip.flatdb4geonames.model.index;

import fr.devinsy.util.StringList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdministrativePath {
    private static Logger logger = LoggerFactory.getLogger(AdministrativePath.class);
    private String codePath;
    private String toponym;
    private Integer geonameId;

    public AdministrativePath(String path, String description, Integer geonameId) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("Null parameter.");
        }
        this.codePath = path;
        this.toponym = description;
        this.geonameId = geonameId;
    }

    public String getCode1() {
        String[] tokens = this.codePath.split("\\.");
        String result = tokens.length > 1 ? tokens[1] : null;
        return result;
    }

    public String getCode2() {
        String[] tokens = this.codePath.split("\\.");
        String result = tokens.length > 2 ? tokens[2] : null;
        return result;
    }

    public String getCode3() {
        String[] tokens = this.codePath.split("\\.");
        String result = tokens.length > 3 ? tokens[3] : null;
        return result;
    }

    public String getCode4() {
        String[] tokens = this.codePath.split("\\.");
        String result = tokens.length > 4 ? tokens[4] : null;
        return result;
    }

    public String getCountyCode() {
        String result = this.codePath.split("\\.")[0];
        return result;
    }

    public int getGeonameId() {
        return this.geonameId;
    }

    public String getTag() {
        return this.codePath;
    }

    public String getToponym() {
        return this.toponym;
    }

    public void setGeonameId(int geonameId) {
        this.geonameId = geonameId;
    }

    public void setTag(String tag) {
        this.codePath = tag;
    }

    public void setToponym(String toponymValue) {
        this.toponym = toponymValue;
    }

    public String toString() {
        StringList buffer = new StringList();
        buffer.append(this.codePath);
        buffer.append(this.geonameId.intValue());
        String result = buffer.toStringSeparatedBy("\t");
        return result;
    }

    public static String convertToCodePath(String countryCode, String code1, String code2, String code3, String code4) {
        String result;
        if (countryCode == null) {
            result = null;
        } else {
            StringList buffer = new StringList();
            buffer.append(countryCode);
            buffer.append(code1);
            buffer.append(code2);
            buffer.append(code3);
            buffer.append(code4);
            result = buffer.toStringSeparatedBy(".");
        }
        return result;
    }
}

